/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent;

import java.util.concurrent.Callable;
import org.threadly.concurrent.SubmitterExecutor;
import org.threadly.concurrent.future.FutureUtils;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.ExceptionUtils;

public class SameThreadSubmitterExecutor
implements SubmitterExecutor {
    private static final SameThreadSubmitterExecutor INSTANCE = new SameThreadSubmitterExecutor();

    public static SameThreadSubmitterExecutor instance() {
        return INSTANCE;
    }

    protected SameThreadSubmitterExecutor() {
    }

    @Override
    public void execute(Runnable task) {
        ArgumentVerifier.assertNotNull(task, "task");
        try {
            task.run();
        }
        catch (Throwable t) {
            ExceptionUtils.handleException(t);
        }
    }

    @Override
    public <T> ListenableFuture<T> submit(Runnable task, T result) {
        ArgumentVerifier.assertNotNull(task, "task");
        try {
            task.run();
            return FutureUtils.immediateResultFuture(result);
        }
        catch (Throwable t) {
            return FutureUtils.immediateFailureFuture(t);
        }
    }

    @Override
    public <T> ListenableFuture<T> submit(Callable<T> task) {
        ArgumentVerifier.assertNotNull(task, "task");
        try {
            T result = task.call();
            return FutureUtils.immediateResultFuture(result);
        }
        catch (Throwable t) {
            return FutureUtils.immediateFailureFuture(t);
        }
    }
}

