/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent;

import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.Clock;

public class SchedulingUtils {
    protected static volatile int cachedHourShift = Integer.MIN_VALUE;

    public static long getDelayTillMinute(int minute) {
        ArgumentVerifier.assertLessThan(minute, TimeUnit.HOURS.toMinutes(1L), "minute");
        ArgumentVerifier.assertNotNegative(minute, "minute");
        return SchedulingUtils.getDelayTillMinute(Clock.lastKnownTimeMillis(), minute);
    }

    protected static long getDelayTillMinute(long now, int minute) {
        long currentMin = TimeUnit.MILLISECONDS.toMinutes(now % TimeUnit.HOURS.toMillis(1L));
        long minutesToWait = 0L;
        if ((long)minute > currentMin) {
            minutesToWait = (long)minute - currentMin;
        } else if ((long)minute <= currentMin) {
            minutesToWait = TimeUnit.HOURS.toMinutes(1L) - currentMin + (long)minute;
        }
        long offset = now % TimeUnit.MINUTES.toMillis(1L);
        return TimeUnit.MINUTES.toMillis(minutesToWait) - offset;
    }

    public static long getDelayTillHour(int hour, int minute) {
        ArgumentVerifier.assertLessThan(hour, TimeUnit.DAYS.toHours(1L), "hour");
        ArgumentVerifier.assertNotNegative(hour, "hour");
        ArgumentVerifier.assertLessThan(minute, TimeUnit.HOURS.toMinutes(1L), "minute");
        ArgumentVerifier.assertNotNegative(minute, "minute");
        return SchedulingUtils.getDelayTillHour(Clock.lastKnownTimeMillis(), hour, minute);
    }

    protected static long getDelayTillHour(long now, int hour, int minute) {
        long delayInMillis = TimeUnit.MINUTES.toMillis(minute);
        long currentHour = TimeUnit.MILLISECONDS.toHours(now % TimeUnit.DAYS.toMillis(1L));
        if ((long)hour > currentHour) {
            delayInMillis += TimeUnit.HOURS.toMillis((long)hour - currentHour);
        } else if ((long)hour < currentHour) {
            delayInMillis += TimeUnit.HOURS.toMillis(TimeUnit.DAYS.toHours(1L) - currentHour + (long)hour);
        } else {
            long result = SchedulingUtils.getDelayTillMinute(Clock.lastKnownTimeMillis(), minute);
            if (TimeUnit.MILLISECONDS.toMinutes(result) <= (long)minute) {
                return result;
            }
            return result + TimeUnit.HOURS.toMillis(TimeUnit.DAYS.toHours(1L) - 1L);
        }
        long offset = now % TimeUnit.HOURS.toMillis(1L);
        return delayInMillis - offset;
    }

    public static int shiftLocalHourToUTC(int hour) {
        ArgumentVerifier.assertLessThan(hour, TimeUnit.DAYS.toHours(1L), "hour");
        ArgumentVerifier.assertNotNegative(hour, "hour");
        if (cachedHourShift == Integer.MIN_VALUE) {
            Calendar calendar = Calendar.getInstance();
            int shiftInMillis = calendar.get(15) + calendar.get(16);
            cachedHourShift = (int)((long)shiftInMillis / TimeUnit.HOURS.toMillis(1L));
        }
        if ((long)(hour -= cachedHourShift) > TimeUnit.DAYS.toHours(1L) - 1L) {
            hour = (int)((long)hour % TimeUnit.DAYS.toHours(1L));
        } else if (hour < 0) {
            hour = (int)((long)hour + TimeUnit.DAYS.toHours(1L));
        }
        return hour;
    }
}

