/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.threadly.concurrent.AbstractPriorityScheduler;
import org.threadly.concurrent.ConfigurableThreadFactory;
import org.threadly.concurrent.DoNothingRunnable;
import org.threadly.concurrent.NoThreadScheduler;
import org.threadly.concurrent.TaskPriority;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.ExceptionUtils;

public class SingleThreadScheduler
extends AbstractPriorityScheduler {
    protected final SchedulerManager sManager;

    public SingleThreadScheduler() {
        this(null, 500L);
    }

    public SingleThreadScheduler(TaskPriority defaultPriority, long maxWaitForLowPriorityInMs) {
        this(defaultPriority, maxWaitForLowPriorityInMs, true);
    }

    public SingleThreadScheduler(boolean daemonThread) {
        this(null, 500L, daemonThread);
    }

    public SingleThreadScheduler(TaskPriority defaultPriority, long maxWaitForLowPriorityInMs, boolean daemonThread) {
        this(defaultPriority, maxWaitForLowPriorityInMs, new ConfigurableThreadFactory(SingleThreadScheduler.class.getSimpleName() + "-", true, daemonThread, 5, null, null, null));
    }

    public SingleThreadScheduler(ThreadFactory threadFactory) {
        this(null, 500L, threadFactory);
    }

    public SingleThreadScheduler(TaskPriority defaultPriority, long maxWaitForLowPriorityInMs, ThreadFactory threadFactory) {
        this(defaultPriority, new SchedulerManager(defaultPriority, maxWaitForLowPriorityInMs, threadFactory));
    }

    protected SingleThreadScheduler(TaskPriority defaultPriority, SchedulerManager schedulerManager) {
        super(defaultPriority);
        this.sManager = schedulerManager;
    }

    protected NoThreadScheduler getRunningScheduler() throws RejectedExecutionException {
        this.sManager.startIfNotRunning();
        if (this.sManager.hasBeenStopped()) {
            throw new RejectedExecutionException("Thread pool shutdown");
        }
        return this.sManager.scheduler;
    }

    private List<Runnable> shutdown(boolean stopImmediately) {
        return this.sManager.stop(stopImmediately);
    }

    public void shutdown() {
        this.shutdown(false);
    }

    public List<Runnable> shutdownNow() {
        return this.shutdown(true);
    }

    public void awaitTermination() throws InterruptedException {
        this.sManager.execThread.join();
    }

    public boolean awaitTermination(long timeoutMillis) throws InterruptedException {
        if (timeoutMillis > 0L) {
            this.sManager.execThread.join(timeoutMillis);
        } else if (timeoutMillis == Long.MAX_VALUE) {
            this.sManager.execThread.join();
        }
        return !this.sManager.execThread.isAlive();
    }

    @Override
    public boolean isShutdown() {
        return this.sManager.hasBeenStopped();
    }

    public boolean isTerminated() {
        return this.sManager.hasBeenStopped() && !this.sManager.execThread.isAlive();
    }

    public void prestartExecutionThread() {
        this.prestartExecutionThread(false);
    }

    public void prestartExecutionThread(boolean blockTillStarted) {
        if (this.sManager.startIfNotRunning()) {
            this.sManager.scheduler.execute(DoNothingRunnable.instance());
        }
        if (blockTillStarted) {
            while (!this.sManager.execThread.isAlive() && this.sManager.state.get() < 1) {
                Thread.yield();
            }
        }
    }

    @Override
    protected AbstractPriorityScheduler.QueueManager getQueueManager() {
        return this.sManager.scheduler.queueManager;
    }

    @Override
    protected AbstractPriorityScheduler.OneTimeTaskWrapper doSchedule(Runnable task, long delayInMillis, TaskPriority priority) {
        return this.getRunningScheduler().doSchedule(task, delayInMillis, priority);
    }

    @Override
    public void scheduleWithFixedDelay(Runnable task, long initialDelay, long recurringDelay, TaskPriority priority) {
        this.getRunningScheduler().scheduleWithFixedDelay(task, initialDelay, recurringDelay, priority);
    }

    @Override
    public void scheduleAtFixedRate(Runnable task, long initialDelay, long period, TaskPriority priority) {
        this.getRunningScheduler().scheduleAtFixedRate(task, initialDelay, period, priority);
    }

    protected void finalize() {
        this.shutdown();
    }

    @Override
    public int getActiveTaskCount() {
        return this.sManager.scheduler.getActiveTaskCount();
    }

    protected static class SchedulerManager
    implements Runnable {
        protected final NoThreadScheduler scheduler;
        protected final AtomicInteger state = new AtomicInteger(-1);
        protected final Thread execThread;

        public SchedulerManager(TaskPriority defaultPriority, long maxWaitForLowPriorityInMs, ThreadFactory threadFactory) {
            this(new NoThreadScheduler(defaultPriority, maxWaitForLowPriorityInMs), threadFactory);
        }

        public SchedulerManager(NoThreadScheduler scheduler, ThreadFactory threadFactory) {
            ArgumentVerifier.assertNotNull(threadFactory, "threadFactory");
            this.scheduler = scheduler;
            this.execThread = threadFactory.newThread(this);
            if (this.execThread.isAlive()) {
                throw new IllegalThreadStateException();
            }
        }

        public boolean hasBeenStopped() {
            return this.state.get() > 0;
        }

        public boolean startIfNotRunning() {
            if (this.state.getPlain() == -1 && this.state.compareAndSet(-1, 0)) {
                this.execThread.start();
                return true;
            }
            return false;
        }

        public List<Runnable> stop(boolean stopImmediately) {
            int stateVal = this.state.get();
            while (stateVal < 1) {
                if (this.state.weakCompareAndSetVolatile(stateVal, 1)) {
                    if (stopImmediately || stateVal == -1) {
                        return this.finishShutdown();
                    }
                    this.scheduler.execute(new AbstractPriorityScheduler.InternalRunnable(){

                        @Override
                        public void run() {
                            this.finishShutdown();
                        }
                    }, TaskPriority.Low);
                    break;
                }
                stateVal = this.state.get();
            }
            return Collections.emptyList();
        }

        private List<Runnable> finishShutdown() {
            this.state.set(2);
            this.scheduler.cancelTick();
            return this.scheduler.clearTasks();
        }

        @Override
        public void run() {
            while (this.state.get() != 2) {
                try {
                    this.scheduler.blockingTick(null);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleException(t);
                }
            }
        }
    }
}

