/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.threadly.util.ArgumentVerifier;

public class ConcurrentArrayList<T>
implements List<T>,
Deque<T>,
RandomAccess {
    private static final short HASH_CODE_PRIME_NUMBER = 31;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    protected final Object modificationLock;
    protected volatile DataSet<T> currentData;

    protected static <E> DataSet<E> makeEmptyDataSet(int frontPadding, int rearPadding) {
        ArgumentVerifier.assertNotNegative(frontPadding, "frontPadding");
        ArgumentVerifier.assertNotNegative(rearPadding, "rearPadding");
        return new DataSet(EMPTY_OBJECT_ARRAY, 0, 0, frontPadding, rearPadding);
    }

    public ConcurrentArrayList() {
        this(0, 0);
    }

    public ConcurrentArrayList(int frontPadding, int rearPadding) {
        this(null, frontPadding, rearPadding);
    }

    protected ConcurrentArrayList(Object modificationLock) {
        this(modificationLock, 0, 0);
    }

    protected ConcurrentArrayList(Object modificationLock, int frontPadding, int rearPadding) {
        this(ConcurrentArrayList.makeEmptyDataSet(frontPadding, rearPadding), modificationLock);
    }

    protected ConcurrentArrayList(DataSet<T> startSet, Object modificationLock) {
        ArgumentVerifier.assertNotNull(startSet, "startSet");
        if (modificationLock == null) {
            modificationLock = new Object();
        }
        this.modificationLock = modificationLock;
        this.currentData = startSet;
    }

    public Object getModificationLock() {
        return this.modificationLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFrontPadding(int frontPadding) {
        ArgumentVerifier.assertNotNegative(frontPadding, "frontPadding");
        Object object = this.modificationLock;
        synchronized (object) {
            this.currentData.frontPadding = frontPadding;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRearPadding(int rearPadding) {
        ArgumentVerifier.assertNotNegative(rearPadding, "rearPadding");
        Object object = this.modificationLock;
        synchronized (object) {
            this.currentData.rearPadding = rearPadding;
        }
    }

    public int getFrontPadding() {
        return this.currentData.frontPadding;
    }

    public int getRearPadding() {
        return this.currentData.rearPadding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize() {
        Object object = this.modificationLock;
        synchronized (object) {
            this.currentData = this.currentData.trimToSize();
        }
    }

    @Override
    public int size() {
        return this.currentData.size;
    }

    @Override
    public boolean isEmpty() {
        return this.currentData.size == 0;
    }

    @Override
    public T get(int index) {
        try {
            return this.currentData.get(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public int indexOf(Object o) {
        return this.currentData.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.currentData.lastIndexOf(o);
    }

    @Override
    public boolean contains(Object o) {
        return this.currentData.indexOf(o) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c == null || c.isEmpty()) {
            return true;
        }
        DataSet<T> workingSet = this.currentData;
        Iterator<?> it = c.iterator();
        while (it.hasNext()) {
            if (workingSet.indexOf(it.next()) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object[] toArray() {
        DataSet<T> workingSet = this.currentData;
        return Arrays.copyOfRange(workingSet.dataArray, workingSet.dataStartIndex, workingSet.dataEndIndex);
    }

    @Override
    public <E> E[] toArray(E[] a) {
        DataSet<T> workingSet = this.currentData;
        if (a.length < workingSet.size) {
            return Arrays.copyOfRange(workingSet.dataArray, workingSet.dataStartIndex, workingSet.dataEndIndex, a.getClass());
        }
        System.arraycopy(workingSet.dataArray, workingSet.dataStartIndex, a, 0, workingSet.size);
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T e) {
        if (e == null) {
            return false;
        }
        Object object = this.modificationLock;
        synchronized (object) {
            this.currentData = this.currentData.addToEnd(e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        Iterator<T> it = c.iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            throw new IllegalArgumentException("Can not store null values");
        }
        Object object = this.modificationLock;
        synchronized (object) {
            this.currentData = this.currentData.addAll(c);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index can not be negative");
        }
        if (c == null) {
            return false;
        }
        Iterator<T> it = c.iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            it.remove();
        }
        if (c.isEmpty()) {
            return false;
        }
        Object object = this.modificationLock;
        synchronized (object) {
            if (index > this.currentData.size) {
                throw new IndexOutOfBoundsException("Index is beyond the array size: " + index);
            }
            this.currentData = this.currentData.addAll(index, c);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        DataSet<T> resultSet;
        DataSet<T> originalSet;
        if (c == this) {
            return false;
        }
        if (c == null || c.isEmpty()) {
            if (this.isEmpty()) {
                return false;
            }
            this.clear();
            return true;
        }
        Object object = this.modificationLock;
        synchronized (object) {
            originalSet = this.currentData;
            resultSet = this.currentData.retainAll(c);
            this.currentData = resultSet;
        }
        return !resultSet.equalsExactly(originalSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.modificationLock;
        synchronized (object) {
            this.currentData = ConcurrentArrayList.makeEmptyDataSet(this.currentData.frontPadding, this.currentData.rearPadding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFirst(T e) {
        if (e == null) {
            throw new UnsupportedOperationException("This structure can not accept nulls");
        }
        Object object = this.modificationLock;
        synchronized (object) {
            this.currentData = this.currentData.addToFront(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLast(T e) {
        if (e == null) {
            throw new UnsupportedOperationException("This structure can not accept nulls");
        }
        Object object = this.modificationLock;
        synchronized (object) {
            this.currentData = this.currentData.addToEnd(e);
        }
    }

    @Override
    public boolean offerFirst(T e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(T e) {
        this.addLast(e);
        return true;
    }

    @Override
    public T removeFirst() {
        T result = this.pollFirst();
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public T removeLast() {
        T result = this.pollLast();
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T pollFirst() {
        Object object = this.modificationLock;
        synchronized (object) {
            T result = this.peekFirst();
            if (result != null) {
                this.currentData = this.currentData.remove(0);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T pollLast() {
        Object object = this.modificationLock;
        synchronized (object) {
            T result = this.peekLast();
            if (result != null) {
                this.currentData = this.currentData.remove(this.currentData.size - 1);
            }
            return result;
        }
    }

    @Override
    public T getFirst() {
        T result = this.peekFirst();
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public T getLast() {
        T result = this.peekLast();
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public T peek() {
        return this.peekFirst();
    }

    @Override
    public T peekFirst() {
        DataSet<T> set = this.currentData;
        if (set.size > 0) {
            return set.get(0);
        }
        return null;
    }

    @Override
    public T peekLast() {
        DataSet<T> set = this.currentData;
        if (set.size > 0) {
            return set.get(set.size - 1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        DataSet<T> resultSet;
        DataSet<T> originalSet;
        if (c == null || c.isEmpty()) {
            return false;
        }
        Object object = this.modificationLock;
        synchronized (object) {
            originalSet = this.currentData;
            resultSet = this.currentData.removeAll(c);
            this.currentData = resultSet;
        }
        return !resultSet.equalsExactly(originalSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean remove(Object o, boolean searchBackwards) {
        if (o == null) {
            return false;
        }
        Object object = this.modificationLock;
        synchronized (object) {
            int index = searchBackwards ? this.currentData.lastIndexOf(o) : this.currentData.indexOf(o);
            if (index < 0) {
                return false;
            }
            this.currentData = this.currentData.remove(index);
            return true;
        }
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.remove(o, false);
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        return this.remove(o, true);
    }

    @Override
    public boolean remove(Object o) {
        return this.removeFirstOccurrence(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove(int index) {
        DataSet<T> originalSet;
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index can not be negative");
        }
        Object object = this.modificationLock;
        synchronized (object) {
            if (index > this.currentData.size - 1) {
                throw new IndexOutOfBoundsException("Index is beyond the array max index: " + index);
            }
            originalSet = this.currentData;
            this.currentData = this.currentData.remove(index);
        }
        return originalSet.get(index);
    }

    @Override
    public boolean offer(T e) {
        return this.offerLast(e);
    }

    @Override
    public T remove() {
        return this.removeFirst();
    }

    @Override
    public T poll() {
        return this.pollFirst();
    }

    @Override
    public T element() {
        return this.getFirst();
    }

    @Override
    public void push(T e) {
        this.addFirst(e);
    }

    @Override
    public T pop() {
        return this.removeFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T set(int index, T element) {
        DataSet<T> originalSet;
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index can not be negative");
        }
        Object object = this.modificationLock;
        synchronized (object) {
            if (index > this.currentData.size - 1) {
                throw new IndexOutOfBoundsException("Index is beyond the array max index: " + index);
            }
            originalSet = this.currentData;
            this.currentData = this.currentData.set(index, element);
        }
        return originalSet.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, T element) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index can not be negative");
        }
        Object object = this.modificationLock;
        synchronized (object) {
            if (index > this.currentData.size) {
                throw new IndexOutOfBoundsException("Index is beyond the array size: " + index);
            }
            this.currentData = this.currentData.add(index, element);
        }
    }

    public void reposition(T item, int newIndex) {
        this.reposition(item, newIndex, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reposition(T item, int newIndex, boolean searchBackwards) {
        if (newIndex < 0) {
            throw new IndexOutOfBoundsException("New index can not be negative");
        }
        Object object = this.modificationLock;
        synchronized (object) {
            int index;
            if (newIndex > this.currentData.size) {
                throw new IndexOutOfBoundsException(newIndex + " is beyond the array's size: " + this.currentData.size);
            }
            int n = index = searchBackwards ? this.lastIndexOf(item) : this.indexOf(item);
            if (index < 0) {
                throw new NoSuchElementException("Could not find item: " + item);
            }
            if (index == newIndex) {
                return;
            }
            this.currentData = this.currentData.reposition(index, newIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reposition(int originalIndex, int newIndex) {
        if (newIndex < 0) {
            throw new IndexOutOfBoundsException("new index can not be negative");
        }
        if (originalIndex < 0) {
            throw new IndexOutOfBoundsException("original index can not be negative");
        }
        if (originalIndex == newIndex) {
            return;
        }
        Object object = this.modificationLock;
        synchronized (object) {
            if (newIndex > this.currentData.size) {
                throw new IndexOutOfBoundsException("new index " + newIndex + " is beyond the array's length: " + this.currentData.size);
            }
            if (originalIndex > this.currentData.size) {
                throw new IndexOutOfBoundsException("original index " + originalIndex + " is beyond the array's length: " + this.currentData.size);
            }
            this.currentData = this.currentData.reposition(originalIndex, newIndex);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new DataSetListIterator(this.currentData, index);
    }

    @Override
    public Iterator<T> descendingIterator() {
        final ListIterator<T> li = this.listIterator(this.currentData.size);
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return li.hasPrevious();
            }

            @Override
            public T next() {
                return li.previous();
            }

            @Override
            public void remove() {
                li.remove();
            }
        };
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        DataSet<T> workingData = this.currentData;
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("from index can not be negative");
        }
        if (fromIndex > workingData.size) {
            throw new IndexOutOfBoundsException("from index must be <= size: " + workingData.size);
        }
        if (toIndex > workingData.size) {
            throw new IndexOutOfBoundsException("to index must be <= size: " + workingData.size);
        }
        if (toIndex <= fromIndex) {
            throw new IndexOutOfBoundsException("fromIndex must be < toIndex");
        }
        DataSet newSet = new DataSet(workingData.dataArray, workingData.dataStartIndex + fromIndex, workingData.dataEndIndex - (workingData.dataEndIndex - toIndex), this.currentData.frontPadding, this.currentData.rearPadding);
        return new ConcurrentArrayList(newSet, this.modificationLock);
    }

    public String toString() {
        return this.currentData.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ConcurrentArrayList) {
            ConcurrentArrayList cal = (ConcurrentArrayList)o;
            return this.currentData.equalsEquivelent(cal.currentData);
        }
        if (o instanceof List) {
            List list = (List)o;
            if (list.size() != this.size()) {
                return false;
            }
            Iterator<T> thisIt = this.iterator();
            Iterator listIt = list.iterator();
            while (thisIt.hasNext() && listIt.hasNext()) {
                if (thisIt.next().equals(listIt.next())) continue;
                return false;
            }
            return !thisIt.hasNext() && !listIt.hasNext();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.currentData.hashCode();
    }

    protected static class DataSet<T> {
        protected final Object[] dataArray;
        protected final int dataStartIndex;
        protected final int dataEndIndex;
        protected final int size;
        private int frontPadding;
        private int rearPadding;

        protected DataSet(Object[] dataArray, int frontPadding, int rearPadding) {
            this(dataArray, frontPadding, dataArray.length - rearPadding, frontPadding, rearPadding);
        }

        protected DataSet(Object[] dataArray, int dataStartIndex, int dataEndIndex, int frontPadding, int rearPadding) {
            this.dataArray = dataArray;
            this.dataStartIndex = dataStartIndex;
            this.dataEndIndex = dataEndIndex;
            this.size = dataEndIndex - dataStartIndex;
            this.frontPadding = frontPadding;
            this.rearPadding = rearPadding;
        }

        public DataSet<T> trimToSize() {
            if (this.dataStartIndex == 0 && this.dataEndIndex == this.dataArray.length) {
                return this;
            }
            Object[] newData = new Object[this.size];
            System.arraycopy(this.dataArray, this.dataStartIndex, newData, 0, this.size);
            return new DataSet<T>(newData, 0, this.size, this.frontPadding, this.rearPadding);
        }

        public DataSet<T> reposition(int origCurrentIndex, int origNewIndex) {
            if (this.size == 1) {
                return this;
            }
            if (origNewIndex == this.size && origCurrentIndex == this.size - 1) {
                return this;
            }
            int newIndex = origNewIndex + this.dataStartIndex;
            int currentIndex = origCurrentIndex + this.dataStartIndex;
            if (newIndex > currentIndex) {
                Object[] newData;
                if (newIndex == this.dataEndIndex) {
                    if (currentIndex == this.dataStartIndex && this.dataArray.length - 1 > this.dataEndIndex && this.dataArray[this.dataEndIndex] == null) {
                        this.dataArray[this.dataEndIndex] = this.dataArray[currentIndex];
                        return new DataSet<T>(this.dataArray, this.dataStartIndex + 1, this.dataEndIndex + 1, this.frontPadding, this.rearPadding);
                    }
                    newData = new Object[this.size + this.frontPadding + this.rearPadding];
                    System.arraycopy(this.dataArray, this.dataStartIndex, newData, this.frontPadding, origCurrentIndex);
                    System.arraycopy(this.dataArray, currentIndex + 1, newData, this.frontPadding + origCurrentIndex, this.size - origCurrentIndex - 1);
                } else {
                    newData = new Object[this.size + this.frontPadding + this.rearPadding];
                    System.arraycopy(this.dataArray, newIndex, newData, this.frontPadding + origNewIndex, this.size - origNewIndex);
                    System.arraycopy(this.dataArray, currentIndex + 1, newData, this.frontPadding + origCurrentIndex, origNewIndex - origCurrentIndex);
                    System.arraycopy(this.dataArray, this.dataStartIndex, newData, this.frontPadding, origCurrentIndex);
                }
                newData[this.frontPadding + origNewIndex - 1] = this.dataArray[currentIndex];
                return new DataSet<T>(newData, this.frontPadding, this.rearPadding);
            }
            if (newIndex < currentIndex) {
                Object[] newData;
                if (newIndex == this.dataStartIndex) {
                    if (this.dataStartIndex > 0 && currentIndex == this.dataEndIndex - 1 && this.dataArray[this.dataStartIndex - 1] == null) {
                        this.dataArray[this.dataStartIndex - 1] = this.dataArray[currentIndex];
                        return new DataSet<T>(this.dataArray, this.dataStartIndex - 1, this.dataEndIndex - 1, this.frontPadding, this.rearPadding);
                    }
                    newData = new Object[this.size + this.frontPadding + this.rearPadding];
                    System.arraycopy(this.dataArray, this.dataStartIndex, newData, this.frontPadding + 1, origCurrentIndex);
                    System.arraycopy(this.dataArray, currentIndex + 1, newData, this.frontPadding + origCurrentIndex + 1, this.dataEndIndex - currentIndex - 1);
                } else {
                    newData = new Object[this.size + this.frontPadding + this.rearPadding];
                    System.arraycopy(this.dataArray, this.dataStartIndex, newData, this.frontPadding, origNewIndex);
                    System.arraycopy(this.dataArray, newIndex, newData, this.frontPadding + origNewIndex + 1, origCurrentIndex - origNewIndex);
                    if (origCurrentIndex < this.size - 1) {
                        System.arraycopy(this.dataArray, currentIndex + 1, newData, this.frontPadding + origCurrentIndex + 1, this.size - origCurrentIndex - 1);
                    }
                }
                newData[this.frontPadding + origNewIndex] = this.dataArray[currentIndex];
                return new DataSet<T>(newData, this.frontPadding, this.rearPadding);
            }
            return this;
        }

        private Object[] getArrayCopy(int newSize) {
            Object[] newData = new Object[newSize + this.frontPadding + this.rearPadding];
            System.arraycopy(this.dataArray, this.dataStartIndex, newData, this.frontPadding, Math.min(this.size, newSize));
            return newData;
        }

        public T get(int index) {
            return (T)this.dataArray[index + this.dataStartIndex];
        }

        public int indexOf(Object o) {
            for (int i = this.dataStartIndex; i < this.dataEndIndex; ++i) {
                if (!this.dataArray[i].equals(o)) continue;
                return i - this.dataStartIndex;
            }
            return -1;
        }

        public int lastIndexOf(Object o) {
            for (int i = this.dataEndIndex - 1; i >= this.dataStartIndex; --i) {
                if (!this.dataArray[i].equals(o)) continue;
                return i - this.dataStartIndex;
            }
            return -1;
        }

        public DataSet<T> set(int index, T element) {
            if (index == this.size) {
                return this.addToEnd(element);
            }
            Object[] newData = this.getArrayCopy(this.size);
            newData[index + this.frontPadding] = element;
            return new DataSet<T>(newData, this.frontPadding, this.rearPadding);
        }

        public DataSet<T> addToFront(T e) {
            if (this.dataStartIndex > 0 && this.dataArray[this.dataStartIndex - 1] == null) {
                this.dataArray[this.dataStartIndex - 1] = e;
                return new DataSet<T>(this.dataArray, this.dataStartIndex - 1, this.dataEndIndex, this.frontPadding, this.rearPadding);
            }
            Object[] newData = new Object[this.size + 1 + this.frontPadding + this.rearPadding];
            newData[this.frontPadding] = e;
            System.arraycopy(this.dataArray, this.dataStartIndex, newData, this.frontPadding + 1, this.size);
            return new DataSet<T>(newData, this.frontPadding, this.rearPadding);
        }

        public DataSet<T> addToEnd(T e) {
            if (this.dataArray.length - 1 >= this.dataEndIndex && this.dataArray[this.dataEndIndex] == null) {
                this.dataArray[this.dataEndIndex] = e;
                return new DataSet<T>(this.dataArray, this.dataStartIndex, this.dataEndIndex + 1, this.frontPadding, this.rearPadding);
            }
            Object[] newData = this.getArrayCopy(this.size + 1);
            newData[this.size + this.frontPadding] = e;
            return new DataSet<T>(newData, this.frontPadding, this.rearPadding);
        }

        public DataSet<T> add(int origIndex, T element) {
            if (origIndex == 0) {
                return this.addToFront(element);
            }
            if (origIndex == this.size) {
                return this.addToEnd(element);
            }
            Object[] newData = new Object[this.size + 1 + this.frontPadding + this.rearPadding];
            System.arraycopy(this.dataArray, this.dataStartIndex, newData, this.frontPadding, origIndex);
            newData[this.frontPadding + origIndex] = element;
            System.arraycopy(this.dataArray, this.dataStartIndex + origIndex, newData, this.frontPadding + origIndex + 1, this.size - origIndex);
            return new DataSet<T>(newData, this.frontPadding, this.rearPadding);
        }

        public DataSet<T> addAll(Collection<? extends T> c) {
            return this.addAll(this.size, c);
        }

        public DataSet<T> addAll(int origIndex, Collection<? extends T> c) {
            if (c == null || c.isEmpty()) {
                return this;
            }
            Object[] toAdd = c.toArray();
            if (origIndex == 0) {
                if (toAdd.length <= this.dataStartIndex && this.dataArray[this.dataStartIndex - 1] == null) {
                    System.arraycopy(toAdd, 0, this.dataArray, this.dataStartIndex - toAdd.length, toAdd.length);
                    return new DataSet<T>(this.dataArray, this.dataStartIndex - toAdd.length, this.dataEndIndex, this.frontPadding, this.rearPadding);
                }
                Object[] newData = new Object[this.size + toAdd.length + this.frontPadding + this.rearPadding];
                System.arraycopy(toAdd, 0, newData, this.frontPadding, toAdd.length);
                System.arraycopy(this.dataArray, this.dataStartIndex, newData, this.frontPadding + toAdd.length, this.size);
                return new DataSet<T>(newData, this.frontPadding, this.rearPadding);
            }
            if (origIndex == this.size) {
                if (this.dataEndIndex + toAdd.length <= this.dataArray.length && this.dataArray[this.dataEndIndex] == null) {
                    System.arraycopy(toAdd, 0, this.dataArray, this.dataEndIndex, toAdd.length);
                    return new DataSet<T>(this.dataArray, this.dataStartIndex, this.dataEndIndex + toAdd.length, this.frontPadding, this.rearPadding);
                }
                Object[] newData = this.getArrayCopy(this.size + toAdd.length);
                System.arraycopy(toAdd, 0, newData, this.size + this.frontPadding, toAdd.length);
                return new DataSet<T>(newData, this.frontPadding, this.rearPadding);
            }
            Object[] newData = new Object[this.size + toAdd.length + this.frontPadding + this.rearPadding];
            System.arraycopy(this.dataArray, this.dataStartIndex, newData, this.frontPadding, origIndex);
            System.arraycopy(toAdd, 0, newData, this.frontPadding + origIndex, toAdd.length);
            System.arraycopy(this.dataArray, this.dataStartIndex + origIndex, newData, this.frontPadding + origIndex + toAdd.length, this.size - origIndex);
            return new DataSet<T>(newData, this.frontPadding, this.rearPadding);
        }

        public DataSet<T> remove(int origIndex) {
            int index = origIndex + this.dataStartIndex;
            if (index == this.dataStartIndex) {
                return new DataSet<T>(this.dataArray, this.dataStartIndex + 1, this.dataEndIndex, this.frontPadding, this.rearPadding);
            }
            if (index == this.dataEndIndex - 1) {
                return new DataSet<T>(this.dataArray, this.dataStartIndex, this.dataEndIndex - 1, this.frontPadding, this.rearPadding);
            }
            Object[] newData = new Object[this.size - 1 + this.frontPadding + this.rearPadding];
            System.arraycopy(this.dataArray, this.dataStartIndex, newData, this.frontPadding, origIndex);
            System.arraycopy(this.dataArray, index + 1, newData, this.frontPadding + origIndex, this.size - origIndex - 1);
            return new DataSet<T>(newData, this.frontPadding, this.rearPadding);
        }

        public DataSet<T> removeAll(Collection<?> c) {
            Object[] resultArray = null;
            int i = this.frontPadding;
            for (int currentIndex = 0; currentIndex < this.size; ++currentIndex) {
                T currItem = this.get(currentIndex);
                if (!c.contains(currItem)) {
                    if (resultArray != null) {
                        resultArray[i++] = currItem;
                        continue;
                    }
                    ++i;
                    continue;
                }
                if (resultArray != null) continue;
                resultArray = new Object[this.size + this.frontPadding + this.rearPadding];
                System.arraycopy(this.dataArray, this.dataStartIndex, resultArray, this.frontPadding, i);
            }
            if (resultArray != null) {
                return new DataSet<T>(resultArray, this.frontPadding, i, this.frontPadding, this.rearPadding);
            }
            return this;
        }

        public DataSet<T> retainAll(Collection<?> c) {
            Object[] resultArray = null;
            int i = this.frontPadding;
            for (int currentIndex = 0; currentIndex < this.size; ++currentIndex) {
                T currItem = this.get(currentIndex);
                if (c.contains(currItem)) {
                    if (resultArray != null) {
                        resultArray[i++] = currItem;
                        continue;
                    }
                    ++i;
                    continue;
                }
                if (resultArray != null) continue;
                resultArray = new Object[this.size + this.frontPadding + this.rearPadding];
                System.arraycopy(this.dataArray, this.dataStartIndex, resultArray, this.frontPadding, i);
            }
            if (resultArray != null) {
                return new DataSet<T>(resultArray, this.frontPadding, i, this.frontPadding, this.rearPadding);
            }
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof DataSet) {
                DataSet ds = (DataSet)o;
                return this.equalsEquivelent(ds);
            }
            return false;
        }

        public boolean equalsEquivelent(DataSet ds) {
            if (this.size != ds.size) {
                return false;
            }
            for (int i = 0; i < this.size; ++i) {
                T thisItem = this.get(i);
                T thatItem = ds.get(i);
                if ((thisItem != null || thatItem == null) && (thisItem == null || thisItem.equals(thatItem))) continue;
                return false;
            }
            return true;
        }

        public boolean equalsExactly(DataSet ds) {
            if (this == ds) {
                return true;
            }
            if (this.dataStartIndex != ds.dataStartIndex || this.dataEndIndex != ds.dataEndIndex || this.dataArray.length != ds.dataArray.length) {
                return false;
            }
            for (int i = 0; i < this.dataArray.length; ++i) {
                if ((this.dataArray[i] != null || ds.dataArray[i] == null) && (this.dataArray[i] == null || this.dataArray[i].equals(ds.dataArray[i]))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hashCode = 1;
            for (int i = this.dataStartIndex; i < this.dataEndIndex; ++i) {
                hashCode = 31 * hashCode + this.dataArray[i].hashCode();
            }
            return hashCode;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append('[');
            for (int i = 0; i < this.dataArray.length; ++i) {
                if (i != 0) {
                    result.append(", ");
                }
                if (i == this.dataStartIndex) {
                    result.append('S');
                }
                result.append(i).append('-').append(this.dataArray[i]);
                if (i != this.dataEndIndex - 1) continue;
                result.append('E');
            }
            result.append(']');
            return result.toString();
        }
    }

    protected class DataSetListIterator
    implements ListIterator<T> {
        private DataSet<T> dataSet;
        private int nextIndex;

        public DataSetListIterator(DataSet<T> dataSet, int index) {
            this.dataSet = dataSet;
            this.nextIndex = index;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < this.dataSet.size;
        }

        @Override
        public T next() {
            this.verifyPosition();
            return this.dataSet.get(this.nextIndex++);
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndex - 1 >= 0;
        }

        @Override
        public T previous() {
            --this.nextIndex;
            this.verifyPosition();
            return this.dataSet.get(this.nextIndex);
        }

        private void verifyPosition() {
            if (this.nextIndex < 0 || this.nextIndex >= this.dataSet.size) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Object object = ConcurrentArrayList.this.modificationLock;
            synchronized (object) {
                if (ConcurrentArrayList.this.currentData == this.dataSet) {
                    ConcurrentArrayList.this.remove(--this.nextIndex);
                    this.dataSet = ConcurrentArrayList.this.currentData;
                } else {
                    int globalIndex = ConcurrentArrayList.this.indexOf(this.dataSet.get(this.nextIndex - 1));
                    if (globalIndex >= 0) {
                        ConcurrentArrayList.this.remove(globalIndex);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(T e) {
            Object object = ConcurrentArrayList.this.modificationLock;
            synchronized (object) {
                if (ConcurrentArrayList.this.currentData == this.dataSet) {
                    ConcurrentArrayList.this.set(this.nextIndex - 1, e);
                    this.dataSet = ConcurrentArrayList.this.currentData;
                } else {
                    int globalIndex = ConcurrentArrayList.this.indexOf(this.dataSet.get(this.nextIndex - 1));
                    if (globalIndex >= 0) {
                        ConcurrentArrayList.this.set(globalIndex, e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(T e) {
            Object object = ConcurrentArrayList.this.modificationLock;
            synchronized (object) {
                if (ConcurrentArrayList.this.currentData == this.dataSet) {
                    ConcurrentArrayList.this.add(this.nextIndex, e);
                    ++this.nextIndex;
                    this.dataSet = ConcurrentArrayList.this.currentData;
                } else {
                    int globalIndex = ConcurrentArrayList.this.indexOf(this.dataSet.get(this.nextIndex - 1));
                    if (globalIndex >= 0) {
                        ConcurrentArrayList.this.add(globalIndex + 1, e);
                    }
                }
            }
        }
    }
}

