/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.future;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import org.threadly.concurrent.event.RunnableListenerHelper;
import org.threadly.concurrent.future.AbstractCancellationMessageProvidingListenableFuture;
import org.threadly.concurrent.future.FutureCallback;
import org.threadly.concurrent.future.InternalFutureUtils;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.util.Clock;

abstract class AbstractCompletableListenableFuture<T>
extends AbstractCancellationMessageProvidingListenableFuture<T> {
    protected static final int STATE_NEW = 0;
    protected static final int STATE_COMPLETING = 1;
    protected static final int STATE_RESULT = 2;
    protected static final int STATE_ERROR = 3;
    protected static final int STATE_CANCELLED = 4;
    protected static final int STATE_INTERRUPTING = 5;
    protected static final int STATE_INTERRUPTED = 6;
    protected static final int STATE_CLEARED_OFFSET = 100;
    private static final VarHandle STATE;
    private static final VarHandle PARKED_CHAIN;
    private static final VarHandle PARKED_THREAD_NEXT;
    protected final RunnableListenerHelper listenerHelper = new RunnableListenerHelper(true);
    protected volatile Thread execThread;
    protected volatile int state;
    private volatile ParkedThread parkedChain;
    private Executor executingExecutor;
    private T result;
    private Throwable failure;

    protected AbstractCompletableListenableFuture(Executor executingExecutor) {
        this.executingExecutor = executingExecutor;
    }

    protected abstract void handleCompleteState();

    private void completeState() {
        ParkedThread pt;
        while ((pt = this.parkedChain) != null) {
            if (!PARKED_CHAIN.weakCompareAndSet(this, pt, null)) continue;
            while (pt != null) {
                LockSupport.unpark(pt.thread);
                ParkedThread next = pt.next;
                pt.next = null;
                pt = next;
            }
        }
        this.handleCompleteState();
        this.executingExecutor = null;
    }

    protected boolean completeWithFailure(Throwable t) {
        if (STATE.compareAndSet(this, 0, 1)) {
            this.failure = t == null ? new Exception() : t;
            STATE.setRelease(this, 3);
            this.completeState();
            this.listenerHelper.callListeners();
            return true;
        }
        return false;
    }

    protected boolean completeWithResult(T result) {
        if (STATE.compareAndSet(this, 0, 1)) {
            this.result = result;
            STATE.setRelease(this, 2);
            this.completeState();
            this.listenerHelper.callListeners();
            return true;
        }
        return false;
    }

    public void clearResult() {
        int state;
        if (this.state == 0) {
            throw new IllegalStateException("Result not set yet");
        }
        try {
            while ((state = this.awaitResultState(false, 0L)) == 5) {
                Thread.yield();
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Result not set yet", e);
        }
        STATE.setRelease(this, 100 + state);
        this.result = null;
        this.failure = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean interrupt) {
        block8: {
            if (this.state != 0 || !STATE.compareAndSet(this, 0, interrupt ? 5 : 4)) {
                return false;
            }
            try {
                if (!interrupt) break block8;
                try {
                    Thread t = this.execThread;
                    if (t != null) {
                        t.interrupt();
                    }
                }
                finally {
                    STATE.setRelease(this, 6);
                }
            }
            finally {
                this.completeState();
                this.listenerHelper.callListeners();
            }
        }
        return true;
    }

    @Override
    public ListenableFuture<T> listener(Runnable listener, Executor executor, ListenableFuture.ListenerOptimizationStrategy optimize) {
        this.listenerHelper.addListener(listener, (Executor)(executor == this.executingExecutor && optimize == ListenableFuture.ListenerOptimizationStrategy.SingleThreadIfExecutorMatchOrDone | optimize == ListenableFuture.ListenerOptimizationStrategy.SingleThreadIfExecutorMatch ? null : executor), optimize == ListenableFuture.ListenerOptimizationStrategy.InvokingThreadIfDone | optimize == ListenableFuture.ListenerOptimizationStrategy.SingleThreadIfExecutorMatchOrDone ? null : executor);
        return this;
    }

    @Override
    public StackTraceElement[] getRunningStackTrace() {
        Thread t = this.execThread;
        if (t == null) {
            return null;
        }
        StackTraceElement[] stack = t.getStackTrace();
        if (stack.length == 0 || t != this.execThread) {
            return null;
        }
        return stack;
    }

    @Override
    public boolean isCancelled() {
        int s = this.state;
        if (s > 100) {
            return s - 100 >= 4;
        }
        return s >= 4;
    }

    @Override
    public boolean isDone() {
        return this.state != 0;
    }

    @Override
    public boolean isCompletedExceptionally() {
        int s = this.state;
        if (s > 100) {
            return s - 100 >= 3;
        }
        return s >= 3;
    }

    /*
     * Unable to fully structure code
     */
    protected int awaitResultState(boolean timed, long nanos) throws InterruptedException {
        if (timed && nanos <= 0L) {
            return this.state;
        }
        startTime = 0L;
        queued = false;
        pt = null;
        while (true) {
            block23: {
                block24: {
                    block21: {
                        block22: {
                            s = this.state;
                            if (s <= 1) break block21;
                            var9_8 = s;
                            if (!queued) break block22;
                            block5: while (true) {
                                prev = null;
                                curr = this.parkedChain;
                                while (curr != null) {
                                    if (curr == pt) {
                                        if (!(prev == null ? AbstractCompletableListenableFuture.PARKED_CHAIN.compareAndSet(this, pt, pt.next) != false : AbstractCompletableListenableFuture.PARKED_THREAD_NEXT.compareAndSet(prev, pt, pt.next) != false)) continue block5;
                                        break block5;
                                    }
                                    prev = curr;
                                    curr = curr.next;
                                }
                                break;
                            }
                        }
                        return var9_8;
                    }
                    if (s == 1) {
                        Thread.yield();
                        continue;
                    }
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    if (!queued) {
                        if (pt == null) {
                            if (timed) {
                                startTime = Clock.accurateTimeNanos();
                            }
                            pt = new ParkedThread();
                        }
                        pt.next = this.parkedChain;
                        queued = AbstractCompletableListenableFuture.PARKED_CHAIN.weakCompareAndSet(this, pt.next, pt);
                        continue;
                    }
                    if (!timed) ** GOTO lbl61
                    elapsed = Clock.accurateTimeNanos() - startTime;
                    if (elapsed < nanos) break block23;
                    var11_11 = this.state;
                    if (!queued) break block24;
                    block7: while (true) {
                        prev = null;
                        curr = this.parkedChain;
                        while (curr != null) {
                            if (curr == pt) {
                                if (!(prev == null ? AbstractCompletableListenableFuture.PARKED_CHAIN.compareAndSet(this, pt, pt.next) != false : AbstractCompletableListenableFuture.PARKED_THREAD_NEXT.compareAndSet(prev, pt, pt.next) != false)) continue block7;
                                break block7;
                            }
                            prev = curr;
                            curr = curr.next;
                        }
                        break;
                    }
                }
                return var11_11;
            }
            if (this.state >= 1) continue;
            LockSupport.parkNanos(this, nanos - elapsed);
            continue;
lbl61:
            // 1 sources

            LockSupport.park(this);
            continue;
            break;
        }
        catch (Throwable var14_14) {
            if (queued) {
                block9: while (true) {
                    prev = null;
                    curr = this.parkedChain;
                    while (curr != null) {
                        if (curr == pt) {
                            if (!(prev == null ? AbstractCompletableListenableFuture.PARKED_CHAIN.compareAndSet(this, pt, pt.next) != false : AbstractCompletableListenableFuture.PARKED_THREAD_NEXT.compareAndSet(prev, pt, pt.next) != false)) continue block9;
                            break block9;
                        }
                        prev = curr;
                        curr = curr.next;
                    }
                    break;
                }
            }
            throw var14_14;
        }
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        int state = this.awaitResultState(false, 0L);
        if (state == 3) {
            throw new ExecutionException(this.failure);
        }
        if (state > 100) {
            throw new IllegalStateException("Result cleared, future get's not possible");
        }
        if (state >= 4) {
            throw new CancellationException(this.getCancellationExceptionMessage());
        }
        return this.result;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        int state = this.awaitResultState(true, unit.toNanos(timeout));
        if (state < 2) {
            throw new TimeoutException();
        }
        if (state == 3) {
            throw new ExecutionException(this.failure);
        }
        if (state > 100) {
            throw new IllegalStateException("Result cleared, future get's not possible");
        }
        if (state >= 4) {
            throw new CancellationException(this.getCancellationExceptionMessage());
        }
        return this.result;
    }

    @Override
    public Throwable getFailure() throws InterruptedException {
        int state = this.awaitResultState(false, 0L);
        if (state == 3) {
            return this.failure;
        }
        if (state > 100) {
            return new IllegalStateException("Result cleared, future get's not possible");
        }
        if (state >= 4) {
            return new CancellationException(this.getCancellationExceptionMessage());
        }
        return null;
    }

    @Override
    public Throwable getFailure(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        int state = this.awaitResultState(true, unit.toNanos(timeout));
        if (state < 2) {
            throw new TimeoutException();
        }
        if (state == 3) {
            return this.failure;
        }
        if (state > 100) {
            return new IllegalStateException("Result cleared, future get's not possible");
        }
        if (state >= 4) {
            return new CancellationException(this.getCancellationExceptionMessage());
        }
        return null;
    }

    @Override
    public ListenableFuture<T> callback(FutureCallback<? super T> callback, Executor executor, ListenableFuture.ListenerOptimizationStrategy optimize) {
        if (InternalFutureUtils.invokeCompletedDirectly(executor, optimize)) {
            int s = this.state;
            if (s == 2) {
                callback.handleResult(this.result);
                return this;
            }
            if (s == 3) {
                callback.handleFailure(this.failure);
                return this;
            }
            if (s > 100) {
                callback.handleFailure(new IllegalStateException("Result cleared"));
                return this;
            }
            if (s >= 4) {
                callback.handleFailure(new CancellationException(this.getCancellationExceptionMessage()));
                return this;
            }
        }
        this.listenerHelper.addListener(() -> {
            int s = this.state;
            if (s == 2) {
                callback.handleResult(this.result);
            } else if (s == 3) {
                callback.handleFailure(this.failure);
            } else if (s > 100) {
                callback.handleFailure(new IllegalStateException("Result cleared"));
            } else if (s >= 4) {
                callback.handleFailure(new CancellationException(this.getCancellationExceptionMessage()));
            }
        }, (Executor)(executor == this.executingExecutor && optimize == ListenableFuture.ListenerOptimizationStrategy.SingleThreadIfExecutorMatchOrDone | optimize == ListenableFuture.ListenerOptimizationStrategy.SingleThreadIfExecutorMatch ? null : executor), optimize == ListenableFuture.ListenerOptimizationStrategy.InvokingThreadIfDone | optimize == ListenableFuture.ListenerOptimizationStrategy.SingleThreadIfExecutorMatchOrDone ? null : executor);
        return this;
    }

    @Override
    public ListenableFuture<T> resultCallback(Consumer<? super T> callback, Executor executor, ListenableFuture.ListenerOptimizationStrategy optimize) {
        int s = this.state;
        if (s > 2) {
            return this;
        }
        if (InternalFutureUtils.invokeCompletedDirectly(executor, optimize) && s == 2) {
            callback.accept(this.result);
            return this;
        }
        this.listenerHelper.addListener(() -> {
            if (this.state == 2) {
                callback.accept(this.result);
            }
        }, (Executor)(executor == this.executingExecutor && optimize == ListenableFuture.ListenerOptimizationStrategy.SingleThreadIfExecutorMatchOrDone | optimize == ListenableFuture.ListenerOptimizationStrategy.SingleThreadIfExecutorMatch ? null : executor), optimize == ListenableFuture.ListenerOptimizationStrategy.InvokingThreadIfDone | optimize == ListenableFuture.ListenerOptimizationStrategy.SingleThreadIfExecutorMatchOrDone ? null : executor);
        return this;
    }

    @Override
    public ListenableFuture<T> failureCallback(Consumer<Throwable> callback, Executor executor, ListenableFuture.ListenerOptimizationStrategy optimize) {
        int s = this.state;
        if (s == 2 || s == 102) {
            return this;
        }
        if (InternalFutureUtils.invokeCompletedDirectly(executor, optimize)) {
            if (s == 3) {
                callback.accept(this.failure);
                return this;
            }
            if (s > 100) {
                callback.accept(new IllegalStateException("Result cleared"));
                return this;
            }
            if (s >= 4) {
                callback.accept(new CancellationException(this.getCancellationExceptionMessage()));
                return this;
            }
        }
        this.listenerHelper.addListener(() -> {
            int s = this.state;
            if (s == 3) {
                callback.accept(this.failure);
            } else if (s > 100) {
                if (s > 102) {
                    callback.accept(new IllegalStateException("Result cleared"));
                }
            } else if (s >= 4) {
                callback.accept(new CancellationException(this.getCancellationExceptionMessage()));
            }
        }, (Executor)(executor == this.executingExecutor && optimize == ListenableFuture.ListenerOptimizationStrategy.SingleThreadIfExecutorMatchOrDone | optimize == ListenableFuture.ListenerOptimizationStrategy.SingleThreadIfExecutorMatch ? null : executor), optimize == ListenableFuture.ListenerOptimizationStrategy.InvokingThreadIfDone | optimize == ListenableFuture.ListenerOptimizationStrategy.SingleThreadIfExecutorMatchOrDone ? null : executor);
        return this;
    }

    public String toString() {
        return this.toString(null);
    }

    protected String toString(Object task) {
        boolean cleared;
        StringBuilder sb = new StringBuilder(100);
        sb.append(super.toString());
        int s = this.state;
        boolean bl = cleared = s > 100;
        if (cleared) {
            s -= 100;
        }
        switch (s) {
            case 2: {
                sb.append("[Completed normally]");
                break;
            }
            case 3: {
                sb.append("[Completed exceptionally: ").append(cleared ? "CLEARED" : this.failure).append("]");
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                sb.append("[Cancelled]");
                break;
            }
            default: {
                if (task == null) {
                    sb.append("[Not completed]");
                    break;
                }
                sb.append("[Not completed, task = ").append(task).append("]");
            }
        }
        if (cleared) {
            sb.append("[RESULT CLEARED]");
        }
        return sb.toString();
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            STATE = l.findVarHandle(AbstractCompletableListenableFuture.class, "state", Integer.TYPE);
            PARKED_CHAIN = l.findVarHandle(AbstractCompletableListenableFuture.class, "parkedChain", ParkedThread.class);
            PARKED_THREAD_NEXT = l.findVarHandle(ParkedThread.class, "next", ParkedThread.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
        Class<LockSupport> clazz = LockSupport.class;
    }

    private static class ParkedThread {
        protected final Thread thread = Thread.currentThread();
        protected volatile ParkedThread next;

        private ParkedThread() {
        }
    }
}

