/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.future;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.threadly.concurrent.RunnableCallableAdapter;
import org.threadly.concurrent.SameThreadSubmitterExecutor;
import org.threadly.concurrent.SubmitterScheduler;
import org.threadly.concurrent.future.FutureCallback;
import org.threadly.concurrent.future.ImmediateFailureListenableFuture;
import org.threadly.concurrent.future.ImmediateResultListenableFuture;
import org.threadly.concurrent.future.InternalFutureUtils;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.SettableListenableFuture;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.ArrayIterator;
import org.threadly.util.Clock;
import org.threadly.util.ExceptionUtils;

public class FutureUtils
extends InternalFutureUtils {
    public static void blockTillAllComplete(Future<?> ... futures) throws InterruptedException {
        FutureUtils.countFuturesWithResult(ArrayIterator.makeIterable(futures), null);
    }

    public static void blockTillAllComplete(Iterable<? extends Future<?>> futures) throws InterruptedException {
        FutureUtils.countFuturesWithResult(futures, null);
    }

    public static void blockTillAllComplete(Iterable<? extends Future<?>> futures, long timeoutInMillis) throws InterruptedException, TimeoutException {
        FutureUtils.countFuturesWithResult(futures, null, timeoutInMillis);
    }

    public static void blockTillAllCompleteOrFirstError(Future<?> ... futures) throws InterruptedException, ExecutionException {
        FutureUtils.blockTillAllCompleteOrFirstError(ArrayIterator.makeIterable(futures));
    }

    public static void blockTillAllCompleteOrFirstError(Iterable<? extends Future<?>> futures) throws InterruptedException, ExecutionException {
        if (futures == null) {
            return;
        }
        for (Future<?> f : futures) {
            f.get();
        }
    }

    public static void blockTillAllCompleteOrFirstError(Iterable<? extends Future<?>> futures, long timeoutInMillis) throws InterruptedException, TimeoutException, ExecutionException {
        if (futures == null) {
            return;
        }
        long startTime = Clock.accurateForwardProgressingMillis();
        for (Future<?> f : futures) {
            long remainingTime = timeoutInMillis - (Clock.lastKnownForwardProgressingMillis() - startTime);
            if (remainingTime <= 0L) {
                throw new TimeoutException();
            }
            f.get(remainingTime, TimeUnit.MILLISECONDS);
        }
    }

    public static <T> int countFuturesWithResult(Iterable<? extends Future<?>> futures, T comparisonResult) throws InterruptedException {
        if (futures == null) {
            return 0;
        }
        int resultCount = 0;
        for (Future<?> f : futures) {
            if (f.isCancelled()) continue;
            try {
                if (comparisonResult == null) {
                    if (f.get() != null) continue;
                    ++resultCount;
                    continue;
                }
                if (!comparisonResult.equals(f.get())) continue;
                ++resultCount;
            }
            catch (CancellationException | ExecutionException exception) {}
        }
        return resultCount;
    }

    public static <T> int countFuturesWithResult(Iterable<? extends Future<?>> futures, T comparisonResult, long timeoutInMillis) throws InterruptedException, TimeoutException {
        if (futures == null) {
            return 0;
        }
        int resultCount = 0;
        long startTime = Clock.accurateForwardProgressingMillis();
        for (Future<?> f : futures) {
            long remainingTime = timeoutInMillis - (Clock.lastKnownForwardProgressingMillis() - startTime);
            if (remainingTime <= 0L) {
                throw new TimeoutException();
            }
            try {
                if (comparisonResult == null) {
                    if (f.get(remainingTime, TimeUnit.MILLISECONDS) != null) continue;
                    ++resultCount;
                    continue;
                }
                if (!comparisonResult.equals(f.get(remainingTime, TimeUnit.MILLISECONDS))) continue;
                ++resultCount;
            }
            catch (CancellationException | ExecutionException exception) {}
        }
        return resultCount;
    }

    public static void invokeAfterAllComplete(Collection<? extends ListenableFuture<?>> futures, Runnable listener) {
        FutureUtils.invokeAfterAllComplete(futures, listener, null);
    }

    public static void invokeAfterAllComplete(Collection<? extends ListenableFuture<?>> futures, Runnable listener, Executor executor) {
        int size;
        ArgumentVerifier.assertNotNull(listener, "listener");
        int n = size = futures == null ? 0 : futures.size();
        if (size == 0) {
            if (executor == null) {
                listener.run();
            } else {
                executor.execute(listener);
            }
        } else if (size == 1) {
            futures.iterator().next().listener(listener, executor);
        } else {
            AtomicInteger remaining = new AtomicInteger(size);
            Runnable decrementingListener = () -> {
                if (remaining.decrementAndGet() == 0) {
                    if (executor == null) {
                        listener.run();
                    } else {
                        executor.execute(listener);
                    }
                }
            };
            for (ListenableFuture<?> lf : futures) {
                lf.listener(decrementingListener);
            }
        }
    }

    public static <T> ListenableFuture<T> makeFirstResultFuture(Collection<? extends ListenableFuture<? extends T>> c, boolean ignoreErrors) {
        FutureCallback callback;
        final SettableListenableFuture result = new SettableListenableFuture(false);
        int expectedSize = 0;
        AtomicInteger atomicSize = null;
        if (ignoreErrors) {
            expectedSize = c.size();
            final AtomicInteger errorsRemaining = atomicSize = new AtomicInteger(expectedSize);
            callback = new FutureCallback<T>(){

                @Override
                public void handleResult(T t) {
                    result.setResult(t);
                }

                @Override
                public void handleFailure(Throwable t) {
                    if (errorsRemaining.decrementAndGet() == 0) {
                        result.setFailure(t);
                    }
                }
            };
        } else {
            callback = result;
        }
        int callbackCount = 0;
        for (ListenableFuture lf : c) {
            ++callbackCount;
            lf.callback(callback);
        }
        if (callbackCount == 0) {
            result.setFailure(new IllegalArgumentException("Empty collection"));
        } else if (atomicSize != null && expectedSize != callbackCount) {
            atomicSize.addAndGet(callbackCount - expectedSize);
        }
        return result;
    }

    public static <T> ListenableFuture<T> makeFirstResultFuture(final Collection<? extends ListenableFuture<? extends T>> c, boolean ignoreErrors, final boolean interruptOnCancel) {
        FutureCallback callback;
        final SettableListenableFuture result = new SettableListenableFuture(false);
        int expectedSize = 0;
        AtomicInteger atomicSize = null;
        if (ignoreErrors) {
            expectedSize = c.size();
            final AtomicInteger errorsRemaining = atomicSize = new AtomicInteger(expectedSize);
            callback = new FutureCallback<T>(){

                @Override
                public void handleResult(T t) {
                    if (result.setResult(t)) {
                        FutureUtils.cancelIncompleteFutures(c, interruptOnCancel);
                    }
                }

                @Override
                public void handleFailure(Throwable t) {
                    if (errorsRemaining.decrementAndGet() == 0) {
                        result.setFailure(t);
                    }
                }
            };
        } else {
            callback = new FutureCallback<T>(){

                @Override
                public void handleResult(T t) {
                    if (result.setResult(t)) {
                        FutureUtils.cancelIncompleteFutures(c, interruptOnCancel);
                    }
                }

                @Override
                public void handleFailure(Throwable t) {
                    if (result.setFailure(t)) {
                        FutureUtils.cancelIncompleteFutures(c, interruptOnCancel);
                    }
                }
            };
        }
        int callbackCount = 0;
        for (ListenableFuture<T> lf : c) {
            ++callbackCount;
            lf.callback(callback);
        }
        if (callbackCount == 0) {
            result.setFailure(new IllegalArgumentException("Empty collection"));
        } else if (atomicSize != null && expectedSize != callbackCount) {
            atomicSize.addAndGet(callbackCount - expectedSize);
        }
        return result;
    }

    public static ListenableFuture<?> makeCompleteFuture(List<? extends ListenableFuture<?>> futures) {
        if (futures == null || futures.isEmpty()) {
            return ImmediateResultListenableFuture.NULL_RESULT;
        }
        if (futures.size() == 1) {
            return futures.get(0);
        }
        return FutureUtils.makeCompleteFuture(futures);
    }

    public static ListenableFuture<?> makeCompleteFuture(Collection<? extends ListenableFuture<?>> futures) {
        if (futures == null || futures.isEmpty()) {
            return ImmediateResultListenableFuture.NULL_RESULT;
        }
        if (futures.size() == 1) {
            return futures.iterator().next();
        }
        return FutureUtils.makeCompleteFuture(futures);
    }

    public static ListenableFuture<?> makeCompleteFuture(ListenableFuture<?> ... futures) {
        return FutureUtils.makeCompleteFuture(ArrayIterator.makeIterable(futures));
    }

    public static ListenableFuture<?> makeCompleteFuture(Iterable<? extends ListenableFuture<?>> futures) {
        if (futures == null) {
            return ImmediateResultListenableFuture.NULL_RESULT;
        }
        Iterator<ListenableFuture<?>> it = futures.iterator();
        if (!it.hasNext()) {
            return ImmediateResultListenableFuture.NULL_RESULT;
        }
        InternalFutureUtils.EmptyFutureCollection result = new InternalFutureUtils.EmptyFutureCollection((Iterator<? extends ListenableFuture<?>>)it);
        if (result.isDone()) {
            return ImmediateResultListenableFuture.NULL_RESULT;
        }
        return result;
    }

    public static <T> ListenableFuture<T> makeCompleteFuture(Iterable<? extends ListenableFuture<?>> futures, final T result) {
        if (futures == null) {
            return FutureUtils.immediateResultFuture(result);
        }
        Iterator<ListenableFuture<?>> it = futures.iterator();
        if (!it.hasNext()) {
            return FutureUtils.immediateResultFuture(result);
        }
        InternalFutureUtils.EmptyFutureCollection efc = new InternalFutureUtils.EmptyFutureCollection((Iterator<? extends ListenableFuture<?>>)it);
        if (efc.isDone()) {
            return FutureUtils.immediateResultFuture(result);
        }
        final InternalFutureUtils.CancelDelegateSettableListenableFuture resultFuture = new InternalFutureUtils.CancelDelegateSettableListenableFuture(efc, null);
        efc.callback(new FutureCallback<Object>(){

            @Override
            public void handleResult(Object ignored) {
                resultFuture.setResult(result);
            }

            @Override
            public void handleFailure(Throwable t) {
                resultFuture.setFailure(t);
            }
        }, (Executor)null, (ListenableFuture.ListenerOptimizationStrategy)null);
        return resultFuture;
    }

    public static ListenableFuture<?> makeFailurePropagatingCompleteFuture(ListenableFuture<?> ... futures) {
        return FutureUtils.makeFailurePropagatingCompleteFuture(ArrayIterator.makeIterable(futures), null);
    }

    public static ListenableFuture<?> makeFailurePropagatingCompleteFuture(Iterable<? extends ListenableFuture<?>> futures) {
        return FutureUtils.makeFailurePropagatingCompleteFuture(futures, null);
    }

    public static <T> ListenableFuture<T> makeFailurePropagatingCompleteFuture(Iterable<? extends ListenableFuture<?>> futures, final T result) {
        if (futures == null) {
            return FutureUtils.immediateResultFuture(result);
        }
        Iterator<ListenableFuture<?>> it = futures.iterator();
        if (!it.hasNext()) {
            return FutureUtils.immediateResultFuture(result);
        }
        InternalFutureUtils.FailureFutureCollection ffc = new InternalFutureUtils.FailureFutureCollection(it);
        if (ffc.isDone()) {
            try {
                List failedFutures = (List)ffc.get();
                if (failedFutures.isEmpty()) {
                    return FutureUtils.immediateResultFuture(result);
                }
                return (ListenableFuture)failedFutures.get(0);
            }
            catch (ExecutionException e) {
                return FutureUtils.immediateFailureFuture(e.getCause());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        final InternalFutureUtils.CancelDelegateSettableListenableFuture resultFuture = new InternalFutureUtils.CancelDelegateSettableListenableFuture(ffc, null);
        ffc.callback(new FutureCallback<List<ListenableFuture<?>>>(){

            @Override
            public void handleResult(List<ListenableFuture<?>> failedFutures) {
                if (failedFutures.isEmpty()) {
                    resultFuture.setResult(result);
                } else {
                    ListenableFuture<?> f = failedFutures.get(0);
                    if (f.isCancelled()) {
                        resultFuture.cancel(false);
                    } else {
                        try {
                            resultFuture.setFailure(f.getFailure());
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }

            @Override
            public void handleFailure(Throwable t) {
                resultFuture.setFailure(t);
            }
        }, (Executor)null, (ListenableFuture.ListenerOptimizationStrategy)null);
        return resultFuture;
    }

    public static <T> ListenableFuture<List<ListenableFuture<? extends T>>> makeCompleteListFuture(Iterable<? extends ListenableFuture<? extends T>> futures) {
        if (futures == null) {
            return ImmediateResultListenableFuture.EMPTY_LIST_RESULT;
        }
        Iterator<ListenableFuture<T>> it = futures.iterator();
        if (!it.hasNext()) {
            return ImmediateResultListenableFuture.EMPTY_LIST_RESULT;
        }
        return new InternalFutureUtils.AllFutureCollection(it);
    }

    public static <T> ListenableFuture<List<ListenableFuture<? extends T>>> makeSuccessListFuture(Iterable<? extends ListenableFuture<? extends T>> futures) {
        if (futures == null) {
            return ImmediateResultListenableFuture.EMPTY_LIST_RESULT;
        }
        Iterator<ListenableFuture<T>> it = futures.iterator();
        if (!it.hasNext()) {
            return ImmediateResultListenableFuture.EMPTY_LIST_RESULT;
        }
        return new InternalFutureUtils.SuccessFutureCollection(it);
    }

    public static <T> ListenableFuture<List<ListenableFuture<? extends T>>> makeFailureListFuture(Iterable<? extends ListenableFuture<? extends T>> futures) {
        if (futures == null) {
            return ImmediateResultListenableFuture.EMPTY_LIST_RESULT;
        }
        Iterator<ListenableFuture<T>> it = futures.iterator();
        if (!it.hasNext()) {
            return ImmediateResultListenableFuture.EMPTY_LIST_RESULT;
        }
        return new InternalFutureUtils.FailureFutureCollection(it);
    }

    public static <T> ListenableFuture<List<T>> makeResultListFuture(Iterable<? extends ListenableFuture<? extends T>> futures, final boolean ignoreFailedFutures) {
        if (futures == null) {
            return ImmediateResultListenableFuture.EMPTY_LIST_RESULT;
        }
        Iterator<ListenableFuture<T>> it = futures.iterator();
        if (!it.hasNext()) {
            return ImmediateResultListenableFuture.EMPTY_LIST_RESULT;
        }
        InternalFutureUtils.AllFutureCollection completeFuture = new InternalFutureUtils.AllFutureCollection(it);
        final InternalFutureUtils.CancelDelegateSettableListenableFuture<List<T>> result = new InternalFutureUtils.CancelDelegateSettableListenableFuture<List<T>>(completeFuture, null);
        completeFuture.callback(new FutureCallback<List<ListenableFuture<? extends T>>>(){

            @Override
            public void handleResult(List<ListenableFuture<? extends T>> resultFutures) {
                boolean needToCancel = false;
                ArrayList results = new ArrayList(resultFutures.size());
                for (ListenableFuture f : resultFutures) {
                    if (f.isCancelled()) {
                        if (ignoreFailedFutures) continue;
                        needToCancel = true;
                        continue;
                    }
                    try {
                        Throwable failure = f.getFailure();
                        if (failure != null) {
                            if (ignoreFailedFutures) continue;
                            result.setFailure(failure);
                            return;
                        }
                        results.add(f.get());
                    }
                    catch (Exception e) {
                        result.setFailure(e);
                        return;
                    }
                }
                if (needToCancel) {
                    if (!result.cancel(true)) {
                        result.setFailure(new IllegalStateException("Failed to cancel after dependent future was canceled"));
                    }
                } else {
                    result.setResult(results);
                }
            }

            @Override
            public void handleFailure(Throwable t) {
                result.setFailure(t);
            }
        }, null, null);
        return result;
    }

    public static void cancelIncompleteFutures(Iterable<? extends Future<?>> futures, boolean interruptThread) {
        if (futures == null) {
            return;
        }
        for (Future<?> f : futures) {
            f.cancel(interruptThread);
        }
    }

    public static void cancelIncompleteFuturesIfAnyFail(boolean copy, Iterable<? extends ListenableFuture<?>> futures, boolean interruptThread) {
        Iterable<ListenableFuture<?>> callbackFutures;
        ArrayList futuresCopy;
        if (futures == null) {
            return;
        }
        if (copy) {
            futuresCopy = new ArrayList();
            callbackFutures = futuresCopy;
        } else {
            futuresCopy = null;
            callbackFutures = futures;
        }
        InternalFutureUtils.CancelOnErrorFutureCallback cancelingCallback = new InternalFutureUtils.CancelOnErrorFutureCallback(callbackFutures, interruptThread);
        for (ListenableFuture<?> f : futures) {
            if (copy) {
                futuresCopy.add(f);
            }
            f.failureCallback(cancelingCallback);
        }
    }

    public static <T> ListenableFuture<T> immediateResultFuture(T result) {
        if (result == null) {
            return ImmediateResultListenableFuture.NULL_RESULT;
        }
        if (result == Optional.empty()) {
            return ImmediateResultListenableFuture.EMPTY_OPTIONAL_RESULT;
        }
        if (result == Boolean.TRUE) {
            return ImmediateResultListenableFuture.BOOLEAN_TRUE_RESULT;
        }
        if (result == Boolean.FALSE) {
            return ImmediateResultListenableFuture.BOOLEAN_FALSE_RESULT;
        }
        if (result == "") {
            return ImmediateResultListenableFuture.EMPTY_STRING_RESULT;
        }
        return new ImmediateResultListenableFuture<T>(result);
    }

    public static <T> ListenableFuture<T> immediateFailureFuture(Throwable failure) {
        return new ImmediateFailureListenableFuture(failure);
    }

    public static ListenableFuture<?> scheduleWhile(SubmitterScheduler scheduler, long scheduleDelayMillis, boolean firstRunAsync, Runnable task, Supplier<Boolean> loopTest) {
        return FutureUtils.scheduleWhile(scheduler, scheduleDelayMillis, firstRunAsync, task, loopTest, -1L);
    }

    public static ListenableFuture<?> scheduleWhile(SubmitterScheduler scheduler, long scheduleDelayMillis, boolean firstRunAsync, Runnable task, Supplier<Boolean> loopTest, long timeoutMillis) {
        ArgumentVerifier.assertNotNull(task, "task");
        ArgumentVerifier.assertNotNull(loopTest, "loopTest");
        return FutureUtils.scheduleWhile(scheduler, scheduleDelayMillis, firstRunAsync, RunnableCallableAdapter.adapt(task, null), (? super T ignored) -> (Boolean)loopTest.get(), timeoutMillis, false);
    }

    public static <T> ListenableFuture<T> scheduleWhile(SubmitterScheduler scheduler, long scheduleDelayMillis, boolean firstRunAsync, Callable<? extends T> task, Predicate<? super T> loopTest) {
        return FutureUtils.scheduleWhile(scheduler, scheduleDelayMillis, firstRunAsync, task, loopTest, -1L, false);
    }

    public static <T> ListenableFuture<T> scheduleWhile(SubmitterScheduler scheduler, long scheduleDelayMillis, boolean firstRunAsync, Callable<? extends T> task, Predicate<? super T> loopTest, long timeoutMillis, boolean timeoutProvideLastValue) {
        return FutureUtils.scheduleWhile(scheduler, scheduleDelayMillis, (firstRunAsync ? scheduler : SameThreadSubmitterExecutor.instance()).submit(task), task, loopTest, timeoutMillis, timeoutProvideLastValue);
    }

    public static <T> ListenableFuture<T> scheduleWhile(SubmitterScheduler scheduler, long scheduleDelayMillis, ListenableFuture<? extends T> startingFuture, Callable<? extends T> task, Predicate<? super T> loopTest) {
        return FutureUtils.scheduleWhile(scheduler, scheduleDelayMillis, startingFuture, task, loopTest, -1L, false);
    }

    public static <T> ListenableFuture<T> scheduleWhile(final SubmitterScheduler scheduler, final long scheduleDelayMillis, ListenableFuture<? extends T> startingFuture, final Callable<? extends T> task, final Predicate<? super T> loopTest, final long timeoutMillis, final boolean timeoutProvideLastValue) {
        ArgumentVerifier.assertNotNull(scheduler, "scheduler");
        ArgumentVerifier.assertNotNegative(scheduleDelayMillis, "scheduleDelayMillis");
        ArgumentVerifier.assertNotNull(startingFuture, "startingFuture");
        ArgumentVerifier.assertNotNull(task, "task");
        ArgumentVerifier.assertNotNull(loopTest, "loopTest");
        ListenableFuture<? super T> alreadyDoneResult = FutureUtils.shortcutAsyncWhile(startingFuture, loopTest);
        if (alreadyDoneResult != null) {
            return alreadyDoneResult;
        }
        final long startTime = timeoutMillis > 0L ? Clock.accurateForwardProgressingMillis() : -1L;
        final InternalFutureUtils.CancelDelegateSettableListenableFuture resultFuture = new InternalFutureUtils.CancelDelegateSettableListenableFuture(startingFuture, (Executor)scheduler);
        final Callable cancelCheckingTask = new Callable<T>(){

            @Override
            public T call() throws Exception {
                resultFuture.setRunningThread(Thread.currentThread());
                try {
                    if (!resultFuture.isCancelled()) {
                        Object v = task.call();
                        return v;
                    }
                    throw InternalFutureUtils.FailurePropogatingFutureCallback.IGNORED_FAILURE;
                }
                finally {
                    resultFuture.setRunningThread(null);
                }
            }
        };
        startingFuture.callback(new InternalFutureUtils.FailurePropogatingFutureCallback<T>(resultFuture){

            @Override
            public void handleResult(T result) {
                try {
                    if (startTime > 0L && Clock.lastKnownForwardProgressingMillis() - startTime > timeoutMillis) {
                        if (timeoutProvideLastValue) {
                            resultFuture.setResult(result);
                        } else {
                            resultFuture.setFailure(new TimeoutException());
                        }
                    } else if (loopTest.test(result)) {
                        ListenableFuture lf = scheduler.submitScheduled(cancelCheckingTask, scheduleDelayMillis);
                        resultFuture.updateDelegateFuture(lf);
                        lf.callback(this);
                    } else {
                        resultFuture.setResult(result);
                    }
                }
                catch (Throwable t) {
                    ExceptionUtils.handleException(t);
                    resultFuture.setFailure(t);
                }
            }
        }, null, null);
        return resultFuture;
    }

    public static <T> ListenableFuture<T> executeWhile(Callable<? extends ListenableFuture<? extends T>> asyncTask, Predicate<? super T> loopTest) {
        return FutureUtils.executeWhile(asyncTask, loopTest, -1L, false);
    }

    public static <T> ListenableFuture<T> executeWhile(Callable<? extends ListenableFuture<? extends T>> asyncTask, Predicate<? super T> loopTest, long timeoutMillis, boolean timeoutProvideLastValue) {
        ArgumentVerifier.assertNotNull(asyncTask, "asyncTask");
        ArgumentVerifier.assertNotNull(loopTest, "loopTest");
        try {
            return FutureUtils.executeWhile(asyncTask.call(), asyncTask, loopTest, timeoutMillis, timeoutProvideLastValue);
        }
        catch (Exception e) {
            return FutureUtils.immediateFailureFuture(e);
        }
    }

    public static <T> ListenableFuture<T> executeWhile(ListenableFuture<? extends T> startingFuture, Callable<? extends ListenableFuture<? extends T>> asyncTask, Predicate<? super T> loopTest) {
        return FutureUtils.executeWhile(startingFuture, asyncTask, loopTest, -1L, false);
    }

    public static <T> ListenableFuture<T> executeWhile(ListenableFuture<? extends T> startingFuture, final Callable<? extends ListenableFuture<? extends T>> asyncTask, final Predicate<? super T> loopTest, final long timeoutMillis, final boolean lastValueOnTimeout) {
        ArgumentVerifier.assertNotNull(startingFuture, "startingFuture");
        ArgumentVerifier.assertNotNull(asyncTask, "asyncTask");
        ArgumentVerifier.assertNotNull(loopTest, "loopTest");
        ListenableFuture<? super T> alreadyDoneResult = FutureUtils.shortcutAsyncWhile(startingFuture, loopTest);
        if (alreadyDoneResult != null) {
            return alreadyDoneResult;
        }
        final long startTime = timeoutMillis > 0L ? Clock.accurateForwardProgressingMillis() : -1L;
        final InternalFutureUtils.CancelDelegateSettableListenableFuture resultFuture = new InternalFutureUtils.CancelDelegateSettableListenableFuture(startingFuture, null);
        startingFuture.callback(new InternalFutureUtils.FailurePropogatingFutureCallback<T>(resultFuture){

            @Override
            public void handleResult(T result) {
                resultFuture.setRunningThread(Thread.currentThread());
                try {
                    while (loopTest.test(result)) {
                        if (startTime > -1L && Clock.lastKnownForwardProgressingMillis() - startTime > timeoutMillis) {
                            if (lastValueOnTimeout) {
                                resultFuture.setResult(result);
                            } else {
                                resultFuture.setFailure(new TimeoutException());
                            }
                            return;
                        }
                        if (resultFuture.isCancelled()) {
                            return;
                        }
                        ListenableFuture lf = (ListenableFuture)asyncTask.call();
                        if (lf.isDone()) {
                            if (lf.isCompletedExceptionally()) {
                                resultFuture.setFailure(lf.getFailure());
                                return;
                            }
                            result = lf.get();
                            continue;
                        }
                        resultFuture.updateDelegateFuture(lf);
                        lf.callback(this, null, null);
                        return;
                    }
                    resultFuture.setResult(result);
                }
                catch (Throwable t) {
                    ExceptionUtils.handleException(t);
                    resultFuture.setFailure(t);
                }
                finally {
                    resultFuture.setRunningThread(null);
                }
            }
        }, null, null);
        return resultFuture;
    }

    private static <T> ListenableFuture<T> shortcutAsyncWhile(ListenableFuture<? extends T> startingFuture, Predicate<? super T> doneTest) {
        if (startingFuture.isDone()) {
            try {
                if (startingFuture.isCompletedExceptionally()) {
                    return startingFuture;
                }
                if (!doneTest.test(startingFuture.get())) {
                    return FutureUtils.immediateResultFuture(startingFuture.get());
                }
            }
            catch (Throwable t) {
                ExceptionUtils.handleException(t);
                return FutureUtils.immediateFailureFuture(t);
            }
        }
        return null;
    }
}

