/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.future.watchdog;

import java.util.Collection;
import java.util.Iterator;
import org.threadly.concurrent.ReschedulingOperation;
import org.threadly.concurrent.SubmitterScheduler;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.watchdog.AbstractWatchdog;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.Clock;

public class ConstantTimeWatchdog
extends AbstractWatchdog {
    protected final long timeoutInMillis;

    public ConstantTimeWatchdog(long timeoutInMillis, boolean sendInterruptOnFutureCancel) {
        this(ConstantTimeWatchdog.getStaticScheduler(), timeoutInMillis, sendInterruptOnFutureCancel);
    }

    public ConstantTimeWatchdog(SubmitterScheduler scheduler, long timeoutInMillis, boolean sendInterruptOnFutureCancel) {
        super(futures -> new CheckRunner(scheduler, timeoutInMillis, sendInterruptOnFutureCancel, (Collection<TimeoutFutureWrapper>)futures));
        ArgumentVerifier.assertGreaterThanZero(timeoutInMillis, "timeoutInMillis");
        this.timeoutInMillis = timeoutInMillis;
    }

    public long getTimeoutInMillis() {
        return this.timeoutInMillis;
    }

    public void watch(ListenableFuture<?> future) {
        if (future == null || future.isDone()) {
            return;
        }
        this.watchWrapper(new TimeoutFutureWrapper(future), future);
    }

    protected static class CheckRunner
    extends ReschedulingOperation {
        protected final long timeoutInMillis;
        protected final boolean sendInterruptToTrackedThreads;
        protected final Collection<TimeoutFutureWrapper> futures;

        public CheckRunner(SubmitterScheduler scheduler, long timeoutInMillis, boolean sendInterruptToTrackedThreads, Collection<TimeoutFutureWrapper> futures) {
            super(scheduler, timeoutInMillis);
            this.timeoutInMillis = timeoutInMillis;
            this.sendInterruptToTrackedThreads = sendInterruptToTrackedThreads;
            this.futures = futures;
        }

        @Override
        protected void run() {
            TimeoutFutureWrapper fw = null;
            Iterator<TimeoutFutureWrapper> it = this.futures.iterator();
            long now = -1L;
            while (it.hasNext()) {
                fw = it.next();
                if (now < fw.expireTime && (now = Clock.accurateForwardProgressingMillis()) < fw.expireTime) break;
                it.remove();
                fw.future.cancel(this.sendInterruptToTrackedThreads);
                fw = null;
            }
            if (fw != null) {
                this.setScheduleDelay(fw.expireTime - now);
                this.signalToRun();
            } else {
                this.setScheduleDelay(this.timeoutInMillis);
            }
        }
    }

    protected class TimeoutFutureWrapper {
        public final long expireTime;
        protected final ListenableFuture<?> future;

        public TimeoutFutureWrapper(ListenableFuture<?> future) {
            this.expireTime = Clock.accurateForwardProgressingMillis() + ConstantTimeWatchdog.this.timeoutInMillis;
            this.future = future;
        }
    }
}

