/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.processing;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import org.threadly.util.AbstractService;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.ExceptionHandler;
import org.threadly.util.ExceptionUtils;

public abstract class BlockingQueueConsumer<T>
extends AbstractService {
    protected final ThreadFactory threadFactory;
    protected final BlockingQueue<? extends T> queue;
    protected volatile Thread runningThread = null;

    public static <T> BlockingQueueConsumer<T> makeForHandlers(ThreadFactory threadFactory, BlockingQueue<? extends T> queue, final Consumer<T> consumer, ExceptionHandler exceptionHandler) {
        ArgumentVerifier.assertNotNull(consumer, "consumer");
        final ExceptionHandler fExceptionHandler = exceptionHandler == null ? ExceptionUtils::handleException : exceptionHandler;
        return new BlockingQueueConsumer<T>(threadFactory, queue){

            @Override
            protected void accept(T next) throws Exception {
                consumer.accept(next);
            }

            @Override
            protected void handleException(Throwable t) {
                fExceptionHandler.handleException(t);
            }
        };
    }

    public BlockingQueueConsumer(ThreadFactory threadFactory, BlockingQueue<? extends T> queue) {
        ArgumentVerifier.assertNotNull(threadFactory, "threadFactory");
        ArgumentVerifier.assertNotNull(queue, "queue");
        this.threadFactory = threadFactory;
        this.queue = queue;
    }

    @Override
    protected void startupService() {
        this.runningThread = this.threadFactory.newThread(new ConsumerRunnable());
        if (this.runningThread.isAlive()) {
            throw new IllegalThreadStateException();
        }
        this.runningThread.setDaemon(true);
        this.runningThread.start();
    }

    @Override
    protected void shutdownService() {
        Thread runningThread = this.runningThread;
        this.runningThread = null;
        runningThread.interrupt();
    }

    protected T getNext() throws InterruptedException {
        return this.queue.take();
    }

    protected abstract void accept(T var1) throws Exception;

    protected abstract void handleException(Throwable var1);

    protected final class ConsumerRunnable
    implements Runnable {
        protected ConsumerRunnable() {
        }

        @Override
        public void run() {
            while (BlockingQueueConsumer.this.runningThread != null) {
                try {
                    BlockingQueueConsumer.this.accept(BlockingQueueConsumer.this.getNext());
                }
                catch (InterruptedException e) {
                    BlockingQueueConsumer.this.stopIfRunning();
                }
                catch (Throwable t) {
                    BlockingQueueConsumer.this.handleException(t);
                }
            }
        }
    }
}

