/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper;

import java.util.concurrent.Executor;
import org.threadly.concurrent.AbstractSubmitterScheduler;
import org.threadly.concurrent.SubmitterScheduler;
import org.threadly.util.ArgumentVerifier;

public class SchedulerExecutorDelegator
extends AbstractSubmitterScheduler {
    protected final Executor parentExecutor;
    protected final SubmitterScheduler parentScheduler;

    public SchedulerExecutorDelegator(Executor parentExecutor, SubmitterScheduler parentScheduler) {
        ArgumentVerifier.assertNotNull(parentExecutor, "parentExecutor");
        ArgumentVerifier.assertNotNull(parentScheduler, "parentScheduler");
        this.parentExecutor = parentExecutor;
        this.parentScheduler = parentScheduler;
    }

    @Override
    public void scheduleWithFixedDelay(Runnable task, long initialDelay, long recurringDelay) {
        this.parentScheduler.scheduleWithFixedDelay(task, initialDelay, recurringDelay);
    }

    @Override
    public void scheduleAtFixedRate(Runnable task, long initialDelay, long period) {
        this.parentScheduler.scheduleAtFixedRate(task, initialDelay, period);
    }

    @Override
    protected void doSchedule(Runnable task, long delayInMillis) {
        if (delayInMillis > 0L) {
            this.parentScheduler.schedule(task, delayInMillis);
        } else {
            this.parentExecutor.execute(task);
        }
    }
}

