/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.compatibility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.threadly.concurrent.RunnableContainer;
import org.threadly.concurrent.SchedulerService;
import org.threadly.concurrent.future.FutureCallback;
import org.threadly.concurrent.future.FutureUtils;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.ListenableFutureTask;
import org.threadly.concurrent.wrapper.compatibility.ListenableScheduledFuture;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.Clock;
import org.threadly.util.ExceptionUtils;

abstract class AbstractExecutorServiceWrapper
implements ScheduledExecutorService {
    protected final SchedulerService scheduler;

    public AbstractExecutorServiceWrapper(SchedulerService scheduler) {
        ArgumentVerifier.assertNotNull(scheduler, "scheduler");
        this.scheduler = scheduler;
    }

    @Override
    public boolean isShutdown() {
        return this.scheduler.isShutdown();
    }

    public <T> ListenableFuture<T> submit(Callable<T> task) {
        return this.scheduler.submit(task);
    }

    public <T> ListenableFuture<T> submit(Runnable task, T result) {
        return this.scheduler.submit(task, result);
    }

    public ListenableFuture<?> submit(Runnable task) {
        return this.scheduler.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.invokeAll(tasks, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        long timeoutInMs = unit.toMillis(timeout);
        long startTime = timeoutInMs < Long.MAX_VALUE ? Clock.accurateForwardProgressingMillis() : -1L;
        ArrayList<Future<T>> resultList = new ArrayList<Future<T>>(tasks.size());
        for (Callable<T> c : tasks) {
            if (c == null) {
                throw new NullPointerException();
            }
            ListenableFuture<T> lf = this.scheduler.submit(c);
            resultList.add(lf);
        }
        if (timeoutInMs < Long.MAX_VALUE) {
            long remainingTime = timeoutInMs - (Clock.lastKnownForwardProgressingMillis() - startTime);
            try {
                FutureUtils.blockTillAllComplete(resultList, remainingTime);
            }
            catch (TimeoutException e) {
                FutureUtils.cancelIncompleteFutures(resultList, true);
            }
        } else {
            FutureUtils.blockTillAllComplete(resultList);
        }
        return resultList;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        try {
            return this.invokeAny(tasks, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw ExceptionUtils.makeRuntime(e);
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Future completedFuture;
        long remainingTime;
        if (tasks.size() < 1) {
            throw new IllegalArgumentException("Empty task list provided");
        }
        long startTime = Clock.accurateForwardProgressingMillis();
        long timeoutInMs = unit.toMillis(timeout);
        int failureCount = 0;
        ArrayList submittedFutures = new ArrayList(tasks.size() / 2 + 1);
        ExecutorCompletionService<T> ecs = new ExecutorCompletionService<T>(this);
        ExecutionException lastEE = null;
        Iterator<Callable<T>> it = tasks.iterator();
        submittedFutures.add(ecs.submit(it.next()));
        while (it.hasNext() && (remainingTime = timeoutInMs - (Clock.lastKnownForwardProgressingMillis() - startTime)) > 0L) {
            Object v;
            completedFuture = ecs.poll();
            if (completedFuture == null) {
                submittedFutures.add(ecs.submit(it.next()));
                continue;
            }
            try {
                v = completedFuture.get();
            }
            catch (ExecutionException e) {
                ++failureCount;
                lastEE = e;
                continue;
            }
            return (T)v;
        }
        while ((remainingTime = timeoutInMs - (Clock.lastKnownForwardProgressingMillis() - startTime)) > 0L && failureCount < submittedFutures.size()) {
            completedFuture = ecs.poll(remainingTime, TimeUnit.MILLISECONDS);
            if (completedFuture == null) {
                throw new TimeoutException();
            }
            try {
                Object e = completedFuture.get();
            }
            catch (ExecutionException e) {
                ++failureCount;
                lastEE = e;
                continue;
            }
            return (T)e;
        }
        if (remainingTime <= 0L) {
            throw new TimeoutException();
        }
        throw lastEE;
        finally {
            FutureUtils.cancelIncompleteFutures(submittedFutures, true);
        }
    }

    @Override
    public void execute(Runnable task) {
        this.scheduler.execute(task);
    }

    public ListenableScheduledFuture<?> schedule(Runnable task, long delay, TimeUnit unit) {
        if (task == null) {
            throw new NullPointerException("Must provide task");
        }
        if (delay < 0L) {
            delay = 0L;
        }
        return this.schedule(task, unit.toMillis(delay));
    }

    protected abstract ListenableScheduledFuture<?> schedule(Runnable var1, long var2);

    public <V> ListenableScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        if (callable == null) {
            throw new NullPointerException("Must provide task");
        }
        if (delay < 0L) {
            delay = 0L;
        }
        return this.schedule(callable, unit.toMillis(delay));
    }

    protected abstract <V> ListenableScheduledFuture<V> schedule(Callable<V> var1, long var2);

    public ListenableScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long initialDelay, long delay, TimeUnit unit) {
        if (task == null) {
            throw new NullPointerException("Must provide task");
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException();
        }
        if (initialDelay < 0L) {
            initialDelay = 0L;
        }
        long initialDelayInMs = unit.toMillis(initialDelay);
        long delayInMs = unit.toMillis(delay);
        return this.scheduleWithFixedDelay(task, initialDelayInMs, delayInMs);
    }

    protected abstract ListenableScheduledFuture<?> scheduleWithFixedDelay(Runnable var1, long var2, long var4);

    public ListenableScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        if (task == null) {
            throw new NullPointerException("Must provide task");
        }
        if (period <= 0L) {
            throw new IllegalArgumentException();
        }
        if (initialDelay < 0L) {
            initialDelay = 0L;
        }
        long initialDelayInMs = unit.toMillis(initialDelay);
        long periodInMs = unit.toMillis(period);
        return this.scheduleAtFixedRate(task, initialDelayInMs, periodInMs);
    }

    protected abstract ListenableScheduledFuture<?> scheduleAtFixedRate(Runnable var1, long var2, long var4);

    protected static final class CancelRemovingListenableFutureTask<T>
    extends ListenableFutureTask<T> {
        private final SchedulerService scheduler;
        private final boolean recurring;

        public CancelRemovingListenableFutureTask(SchedulerService scheduler, boolean recurring, Runnable task, Executor executingExecutor) {
            super(task, null, executingExecutor);
            this.scheduler = scheduler;
            this.recurring = recurring;
        }

        @Override
        protected boolean completeWithResult(T result) {
            if (this.recurring) {
                return false;
            }
            return super.completeWithResult(result);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (super.cancel(mayInterruptIfRunning)) {
                this.scheduler.remove(this.getContainedCallable());
                return true;
            }
            return false;
        }
    }

    protected static final class ThrowableHandlingRecurringRunnable
    implements RunnableContainer,
    Runnable {
        private final SchedulerService scheduler;
        private final Runnable task;

        protected ThrowableHandlingRecurringRunnable(SchedulerService scheduler, Runnable task) {
            this.scheduler = scheduler;
            this.task = task;
        }

        @Override
        public void run() {
            try {
                this.task.run();
            }
            catch (Throwable t) {
                this.scheduler.remove(this);
                ExceptionUtils.handleException(t);
            }
        }

        @Override
        public Runnable getContainedRunnable() {
            return this.task;
        }
    }

    protected static final class ScheduledFutureDelegate<T>
    implements ListenableScheduledFuture<T> {
        protected final ListenableFuture<? extends T> futureImp;
        protected final Delayed delayed;

        public ScheduledFutureDelegate(ListenableFuture<? extends T> futureImp, Delayed delayed) {
            this.futureImp = futureImp;
            this.delayed = delayed;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.delayed.getDelay(unit);
        }

        @Override
        public int compareTo(Delayed o) {
            return this.delayed.compareTo(o);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.futureImp.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.futureImp.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.futureImp.isDone();
        }

        @Override
        public boolean isCompletedExceptionally() {
            return this.futureImp.isCompletedExceptionally();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return (T)this.futureImp.get();
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return (T)this.futureImp.get(timeout, unit);
        }

        @Override
        public Throwable getFailure() throws InterruptedException {
            return this.futureImp.getFailure();
        }

        @Override
        public Throwable getFailure(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
            return this.futureImp.getFailure(timeout, unit);
        }

        @Override
        public ListenableFuture<T> listener(Runnable listener, Executor executor, ListenableFuture.ListenerOptimizationStrategy optimizeExecution) {
            this.futureImp.listener(listener, executor, optimizeExecution);
            return this;
        }

        @Override
        public ListenableFuture<T> callback(FutureCallback<? super T> callback, Executor executor, ListenableFuture.ListenerOptimizationStrategy optimizeExecution) {
            this.futureImp.callback(callback, executor, optimizeExecution);
            return this;
        }

        @Override
        public ListenableFuture<T> resultCallback(Consumer<? super T> callback, Executor executor, ListenableFuture.ListenerOptimizationStrategy optimizeExecution) {
            this.futureImp.resultCallback(callback, executor, optimizeExecution);
            return this;
        }

        @Override
        public ListenableFuture<T> failureCallback(Consumer<Throwable> callback, Executor executor, ListenableFuture.ListenerOptimizationStrategy optimizeExecution) {
            this.futureImp.failureCallback(callback, executor, optimizeExecution);
            return this;
        }

        @Override
        public StackTraceElement[] getRunningStackTrace() {
            return this.futureImp.getRunningStackTrace();
        }
    }
}

