/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.traceability;

import org.threadly.concurrent.RunnableContainer;
import org.threadly.util.ArgumentVerifier;

public class ThreadRenamingRunnable
implements Runnable,
RunnableContainer {
    protected final Runnable runnable;
    protected final String threadName;
    protected final boolean replace;

    public ThreadRenamingRunnable(Runnable runnable, String threadName, boolean replace) {
        ArgumentVerifier.assertNotNull(runnable, "runnable");
        this.runnable = runnable;
        this.threadName = threadName;
        this.replace = replace;
    }

    @Override
    public void run() {
        Thread t = Thread.currentThread();
        String originalName = t.getName();
        try {
            if (this.replace) {
                t.setName(this.threadName);
            } else {
                t.setName(this.threadName + "[" + originalName + "]");
            }
            this.runnable.run();
        }
        finally {
            t.setName(originalName);
        }
    }

    @Override
    public Runnable getContainedRunnable() {
        return this.runnable;
    }
}

