/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class Pair<L, R> {
    private static final short LEFT_PRIME = 13;
    private static final short RIGHT_PRIME = 31;
    protected L left;
    protected R right;

    public static <OL, NL, R> List<Pair<NL, R>> transformLeft(Collection<? extends Pair<? extends OL, ? extends R>> source, Function<? super OL, ? extends NL> transformer) {
        return Pair.transform(source, transformer, r -> r);
    }

    public static <L, OR, NR> List<Pair<L, NR>> transformRight(Collection<? extends Pair<? extends L, ? extends OR>> source, Function<? super OR, ? extends NR> transformer) {
        return Pair.transform(source, l -> l, transformer);
    }

    public static <OL, NL, OR, NR> List<Pair<NL, NR>> transform(Collection<? extends Pair<? extends OL, ? extends OR>> source, Function<? super OL, ? extends NL> leftTransformer, Function<? super OR, ? extends NR> rightTransformer) {
        if (source.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Pair<NL, NR>> result = new ArrayList<Pair<NL, NR>>(source.size());
        for (Pair<OL, OR> pair : source) {
            result.add(new Pair<NL, NR>(leftTransformer.apply(pair.left), rightTransformer.apply(pair.right)));
        }
        return result;
    }

    public static <L> void applyToLeft(Iterable<? extends Pair<? extends L, ?>> source, Consumer<? super L> consumer) {
        for (Pair<L, ?> pair : source) {
            consumer.accept(pair.left);
        }
    }

    public static <R> void applyToRight(Iterable<? extends Pair<?, ? extends R>> source, Consumer<? super R> consumer) {
        for (Pair<?, R> pair : source) {
            consumer.accept(pair.right);
        }
    }

    public static <L, R> List<Pair<L, R>> convertMap(Map<? extends L, ? extends R> map) {
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Pair<L, R>> result = new ArrayList<Pair<L, R>>(map.size());
        for (Map.Entry<L, R> e : map.entrySet()) {
            result.add(new Pair<L, R>(e.getKey(), e.getValue()));
        }
        return result;
    }

    public static <L, R> Pair<List<L>, List<R>> split(Collection<? extends Pair<? extends L, ? extends R>> source) {
        int estimatedCount = source.size();
        ArrayList<L> left = new ArrayList<L>(estimatedCount);
        ArrayList<R> right = new ArrayList<R>(estimatedCount);
        for (Pair<L, R> pair : source) {
            if (pair.left != null) {
                left.add(pair.left);
            }
            if (pair.right == null) continue;
            right.add(pair.right);
        }
        return new Pair<List<L>, List<R>>(left, right);
    }

    public static <T> Iterable<T> iterateLeft(final Iterable<? extends Pair<? extends T, ?>> i) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Pair.iterateLeft(i.iterator());
            }
        };
    }

    public static <T> Iterator<T> iterateLeft(final Iterator<? extends Pair<? extends T, ?>> i) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public T next() {
                return ((Pair)i.next()).left;
            }
        };
    }

    public static <T> Iterable<T> iterateRight(final Iterable<? extends Pair<?, ? extends T>> i) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Pair.iterateRight(i.iterator());
            }
        };
    }

    public static <T> Iterator<T> iterateRight(final Iterator<? extends Pair<?, ? extends T>> i) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public T next() {
                return ((Pair)i.next()).right;
            }
        };
    }

    public static <T> List<T> collectLeft(Collection<? extends Pair<? extends T, ?>> source) {
        if (source.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(source.size());
        for (Pair<T, ?> pair : source) {
            if (pair.left == null) continue;
            result.add(pair.left);
        }
        return result;
    }

    public static <T> List<T> collectRight(Collection<? extends Pair<?, ? extends T>> source) {
        if (source.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(source.size());
        for (Pair<?, T> pair : source) {
            if (pair.right == null) continue;
            result.add(pair.right);
        }
        return result;
    }

    public static boolean containsLeft(Iterable<? extends Pair<?, ?>> search, Object value) {
        for (Pair<?, ?> p : search) {
            if (!(p.left == null ? value == null : p.left.equals(value))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsRight(Iterable<? extends Pair<?, ?>> search, Object value) {
        for (Pair<?, ?> p : search) {
            if (!(p.right == null ? value == null : p.right.equals(value))) continue;
            return true;
        }
        return false;
    }

    public static <T> T getRightFromLeft(Iterable<? extends Pair<?, ? extends T>> search, Object left) {
        for (Pair<?, T> pair : search) {
            if (!(pair.left == null ? left == null : pair.left.equals(left))) continue;
            return (T)pair.right;
        }
        return null;
    }

    public static <T> T getLeftFromRight(Iterable<? extends Pair<? extends T, ?>> search, Object right) {
        for (Pair<T, ?> pair : search) {
            if (!(pair.right == null ? right == null : pair.right.equals(right))) continue;
            return (T)pair.left;
        }
        return null;
    }

    public Pair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public L getLeft() {
        return this.left;
    }

    public R getRight() {
        return this.right;
    }

    public String toString() {
        return Pair.class.getSimpleName() + "[" + this.left + "," + this.right + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Pair) {
            Pair p = (Pair)o;
            if (!(this.left == p.left || this.left != null && this.left.equals(p.left))) {
                return false;
            }
            return this.right == p.right || this.right != null && this.right.equals(p.right);
        }
        return false;
    }

    public int hashCode() {
        int leftHash = this.left == null ? 13 : this.left.hashCode();
        int rightHash = this.right == null ? 31 : this.right.hashCode();
        return leftHash ^ rightHash;
    }
}

