/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.util.debug;

import java.util.Arrays;

class ComparableTrace
implements Comparable<ComparableTrace> {
    protected final StackTraceElement[] elements;
    protected final int hash;

    public ComparableTrace(StackTraceElement[] elements) {
        this.elements = elements;
        int h = 0;
        for (StackTraceElement e : elements) {
            h ^= e.hashCode();
        }
        this.hash = h;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        try {
            ComparableTrace t = (ComparableTrace)o;
            if (t.hash != this.hash) {
                return false;
            }
            return Arrays.equals(t.elements, this.elements);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public int compareTo(ComparableTrace t) {
        return this.hash - t.hash;
    }
}

