/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.util.debug;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.ExceptionUtils;
import org.threadly.util.debug.Profiler;

public class FilteredStackProfiler
extends Profiler {
    protected final FilteredStackProfileStorage filteredThreadStore;

    public FilteredStackProfiler(String pattern) {
        this(100, FilteredStackProfiler.regexPredicate(pattern));
    }

    public FilteredStackProfiler(Predicate<StackTraceElement[]> filter) {
        this(100, filter);
    }

    public FilteredStackProfiler(int pollIntervalInMs, String pattern) {
        this(pollIntervalInMs, null, FilteredStackProfiler.regexPredicate(pattern));
    }

    public FilteredStackProfiler(int pollIntervalInMs, Predicate<StackTraceElement[]> filter) {
        this(pollIntervalInMs, null, filter);
    }

    public FilteredStackProfiler(int pollIntervalInMs, Function<? super Profiler, String> startFutureResultSupplier, String pattern) {
        this(pollIntervalInMs, startFutureResultSupplier, FilteredStackProfiler.regexPredicate(pattern));
    }

    public FilteredStackProfiler(int pollIntervalInMs, Function<? super Profiler, String> startFutureResultSupplier, Predicate<StackTraceElement[]> filter) {
        super(new FilteredStackProfileStorage(pollIntervalInMs, filter), startFutureResultSupplier);
        this.filteredThreadStore = (FilteredStackProfileStorage)this.pStore;
    }

    private static Predicate<StackTraceElement[]> regexPredicate(String pattern) {
        Pattern compiled = Pattern.compile(pattern);
        return stack -> {
            for (StackTraceElement element : stack) {
                if (!compiled.matcher(element.toString()).find()) continue;
                return true;
            }
            return false;
        };
    }

    private static class FilteredStackSampleIterator
    implements Iterator<Profiler.ThreadSample> {
        private final Iterator<? extends Profiler.ThreadSample> delegate;
        private final Predicate<StackTraceElement[]> filter;
        private Profiler.ThreadSample next;

        FilteredStackSampleIterator(Iterator<? extends Profiler.ThreadSample> delegate, Predicate<StackTraceElement[]> filter) {
            this.delegate = delegate;
            this.filter = filter;
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return null != this.next;
        }

        @Override
        public Profiler.ThreadSample next() {
            if (null == this.next) {
                throw new NoSuchElementException();
            }
            Profiler.ThreadSample toReturn = this.next;
            this.findNext();
            return toReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void findNext() {
            while (this.delegate.hasNext()) {
                this.next = this.delegate.next();
                try {
                    if (!this.filter.test(this.next.getStackTrace())) continue;
                    return;
                }
                catch (Throwable t) {
                    ExceptionUtils.handleException(t);
                    return;
                }
            }
            this.next = null;
        }
    }

    protected static class FilteredStackProfileStorage
    extends Profiler.ProfileStorage {
        protected final Predicate<StackTraceElement[]> filter;

        public FilteredStackProfileStorage(int pollIntervalInMs, Predicate<StackTraceElement[]> filter) {
            super(pollIntervalInMs);
            ArgumentVerifier.assertNotNull(filter, "filter");
            this.filter = filter;
        }

        @Override
        protected Iterator<? extends Profiler.ThreadSample> getProfileThreadsIterator() {
            return new FilteredStackSampleIterator(super.getProfileThreadsIterator(), this.filter);
        }
    }
}

