/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.yabn.elements;

import com.teamresourceful.yabn.elements.YabnElement;
import com.teamresourceful.yabn.elements.YabnPrimitive;
import com.teamresourceful.yabn.elements.YabnType;
import com.teamresourceful.yabn.utils.ByteArrayUtils;
import com.teamresourceful.yabn.utils.ByteUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record YabnArray(@NotNull @NotNull List<@NotNull YabnElement> elements) implements YabnElement
{
    public YabnArray() {
        this(new ArrayList<YabnElement>());
    }

    public YabnArray add(@Nullable YabnElement element) {
        this.elements.add(element == null ? YabnPrimitive.ofNull() : element);
        return this;
    }

    @Override
    public byte[] toData() {
        byte[] data;
        YabnType arrayType = this.getArrayType();
        if (arrayType != null) {
            byte[] byArray = new byte[1];
            v1 = byArray;
            byArray[0] = arrayType.id;
        } else {
            v1 = data = new byte[]{};
        }
        if (this.elements.isEmpty()) {
            return data;
        }
        if (arrayType != null && !arrayType.hasData) {
            data = ByteArrayUtils.add(data, ByteUtils.vIntToBytes(this.elements.size()));
        } else {
            if (arrayType != null) {
                data = ByteArrayUtils.add(data, ByteUtils.vIntToBytes(this.elements.size()));
            }
            for (YabnElement element : this.elements) {
                if (arrayType == null) {
                    data = ByteArrayUtils.add(data, element.getType().id);
                }
                data = ByteArrayUtils.add(data, element.toData());
            }
            if (arrayType == null) {
                data = ByteArrayUtils.add(data, 0);
            }
        }
        return data;
    }

    @Override
    public YabnType getType() {
        if (this.elements.isEmpty()) {
            return YabnType.EMPTY_ARRAY;
        }
        YabnType arrayType = this.getArrayType();
        if (arrayType == null) {
            return YabnType.ARRAY;
        }
        return arrayType.hasData ? YabnType.TYPED_ARRAY : YabnType.DATALESS_TYPED_ARRAY;
    }

    @Nullable
    private YabnType getArrayType() {
        if (this.elements.isEmpty()) {
            return null;
        }
        YabnType type = this.elements.get(0).getType();
        for (YabnElement element : this.elements) {
            if (element.getType() == type) continue;
            return null;
        }
        return type;
    }
}

