/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import net.kyrptonaught.customportalapi.CustomPortalsMod;
import net.kyrptonaught.customportalapi.portal.frame.PortalFrameTester;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class CustomPortalApiRegistry {
    protected static final ConcurrentHashMap<class_2248, PortalLink> portals = new ConcurrentHashMap();
    private static final ConcurrentHashMap<class_2960, PortalFrameTester.PortalFrameTesterFactory> PortalFrameTesters = new ConcurrentHashMap();

    public static PortalLink getPortalLinkFromBase(class_2248 baseBlock) {
        if (baseBlock == null) {
            return null;
        }
        if (portals.containsKey(baseBlock)) {
            return portals.get(baseBlock);
        }
        return null;
    }

    public static boolean isRegisteredFrameBlock(class_2680 blockState) {
        return portals.containsKey(blockState.method_26204());
    }

    public static Collection<PortalLink> getAllPortalLinks() {
        return portals.values();
    }

    public static void registerPortalFrameTester(class_2960 frameTesterID, PortalFrameTester.PortalFrameTesterFactory createPortalFrameTester) {
        PortalFrameTesters.put(frameTesterID, createPortalFrameTester);
    }

    public static PortalFrameTester.PortalFrameTesterFactory getPortalFrameTester(class_2960 frameTesterID) {
        return PortalFrameTesters.getOrDefault(frameTesterID, null);
    }

    public static void addPortal(class_2248 frameBlock, PortalLink link) {
        if (frameBlock == null) {
            CustomPortalsMod.logError("Frameblock is null");
        }
        if (link.getPortalBlock() == null) {
            CustomPortalsMod.logError("Portal block is null");
        }
        if (link.portalIgnitionSource == null) {
            CustomPortalsMod.logError("Portal ignition source is null");
        }
        if (link.dimID == null) {
            CustomPortalsMod.logError("Dimension is null");
        }
        if (CustomPortalsMod.getDefaultPortalBlock() == null) {
            CustomPortalsMod.logError("Built in CustomPortalBlock is null");
        }
        if (portals.containsKey(frameBlock) || frameBlock.equals(class_2246.field_10540)) {
            CustomPortalsMod.logError("A portal(or the nether portal) is already registered with a frame of: " + frameBlock);
        } else {
            CustomPortalApiRegistry.forceAddPortal(frameBlock, link);
        }
    }

    @Deprecated
    public static void forceAddPortal(class_2248 frameBlock, PortalLink link) {
        portals.put(frameBlock, link);
    }
}

