/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.api;

import java.util.function.Consumer;
import java.util.function.Function;
import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.CustomPortalBlock;
import net.kyrptonaught.customportalapi.CustomPortalsMod;
import net.kyrptonaught.customportalapi.event.CPASoundEventData;
import net.kyrptonaught.customportalapi.event.PortalIgniteEvent;
import net.kyrptonaught.customportalapi.event.PortalPreIgniteEvent;
import net.kyrptonaught.customportalapi.portal.PortalIgnitionSource;
import net.kyrptonaught.customportalapi.util.ColorUtil;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.kyrptonaught.customportalapi.util.SHOULDTP;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_7923;

public class CustomPortalBuilder {
    private final PortalLink portalLink;

    private CustomPortalBuilder(PortalLink portalLink) {
        this.portalLink = portalLink;
    }

    public static CustomPortalBuilder beginPortal() {
        return CustomPortalBuilder.beginPortal(new PortalLink());
    }

    public static CustomPortalBuilder beginPortal(PortalLink portalLink) {
        return new CustomPortalBuilder(portalLink);
    }

    public PortalLink registerPortal() {
        CustomPortalApiRegistry.addPortal((class_2248)class_7923.field_41175.method_10223(this.portalLink.block), this.portalLink);
        return this.portalLink;
    }

    @Deprecated
    public PortalLink registerPortalForced() {
        CustomPortalApiRegistry.forceAddPortal((class_2248)class_7923.field_41175.method_10223(this.portalLink.block), this.portalLink);
        return this.portalLink;
    }

    public CustomPortalBuilder frameBlock(class_2960 blockID) {
        this.portalLink.block = blockID;
        return this;
    }

    public CustomPortalBuilder frameBlock(class_2248 block) {
        this.portalLink.block = class_7923.field_41175.method_10221((Object)block);
        return this;
    }

    public CustomPortalBuilder destDimID(class_2960 dimID) {
        this.portalLink.dimID = dimID;
        return this;
    }

    public CustomPortalBuilder tintColor(int color) {
        this.portalLink.colorID = color;
        return this;
    }

    public CustomPortalBuilder tintColor(int r, int g, int b) {
        this.portalLink.colorID = ColorUtil.getColorFromRGB(r, g, b);
        return this;
    }

    public CustomPortalBuilder lightWithWater() {
        this.portalLink.portalIgnitionSource = PortalIgnitionSource.WATER;
        return this;
    }

    public CustomPortalBuilder lightWithItem(class_1792 item) {
        this.portalLink.portalIgnitionSource = PortalIgnitionSource.ItemUseSource(item);
        return this;
    }

    public CustomPortalBuilder lightWithFluid(class_3611 fluid) {
        this.portalLink.portalIgnitionSource = PortalIgnitionSource.FluidSource(fluid);
        return this;
    }

    public CustomPortalBuilder customIgnitionSource(class_2960 customSourceID) {
        this.portalLink.portalIgnitionSource = PortalIgnitionSource.CustomSource(customSourceID);
        return this;
    }

    public CustomPortalBuilder customIgnitionSource(PortalIgnitionSource ignitionSource) {
        this.portalLink.portalIgnitionSource = ignitionSource;
        return this;
    }

    public CustomPortalBuilder forcedSize(int width, int height) {
        this.portalLink.forcedWidth = width;
        this.portalLink.forcedHeight = height;
        return this;
    }

    public CustomPortalBuilder customPortalBlock(CustomPortalBlock portalBlock) {
        this.portalLink.setPortalBlock(portalBlock);
        return this;
    }

    public CustomPortalBuilder returnDim(class_2960 returnDimID, boolean onlyIgnitableInReturnDim) {
        this.portalLink.returnDimID = returnDimID;
        this.portalLink.onlyIgnitableInReturnDim = onlyIgnitableInReturnDim;
        return this;
    }

    public CustomPortalBuilder onlyLightInOverworld() {
        this.portalLink.onlyIgnitableInReturnDim = true;
        return this;
    }

    public CustomPortalBuilder flatPortal() {
        this.portalLink.portalFrameTester = CustomPortalsMod.FLATPORTAL_FRAMETESTER;
        return this;
    }

    public CustomPortalBuilder customFrameTester(class_2960 frameTester) {
        this.portalLink.portalFrameTester = frameTester;
        return this;
    }

    public CustomPortalBuilder registerBeforeTPEvent(Function<class_1297, SHOULDTP> event) {
        this.portalLink.getBeforeTPEvent().register(event);
        return this;
    }

    public CustomPortalBuilder registerInPortalAmbienceSound(Function<class_1657, CPASoundEventData> event) {
        this.portalLink.getInPortalAmbienceEvent().register(event);
        return this;
    }

    public CustomPortalBuilder registerPostTPPortalAmbience(Function<class_1657, CPASoundEventData> event) {
        this.portalLink.getPostTpPortalAmbienceEvent().register(event);
        return this;
    }

    public CustomPortalBuilder registerPostTPEvent(Consumer<class_1297> event) {
        this.portalLink.setPostTPEvent(event);
        return this;
    }

    public CustomPortalBuilder registerPreIgniteEvent(PortalPreIgniteEvent event) {
        this.portalLink.setPortalPreIgniteEvent(event);
        return this;
    }

    public CustomPortalBuilder registerIgniteEvent(PortalIgniteEvent event) {
        this.portalLink.setPortalIgniteEvent(event);
        return this;
    }

    public CustomPortalBuilder setPortalSearchYRange(int bottomY, int topY) {
        this.portalLink.portalSearchYBottom = bottomY;
        this.portalLink.portalSearchYTop = topY;
        return this;
    }

    public CustomPortalBuilder setReturnPortalSearchYRange(int bottomY, int topY) {
        this.portalLink.returnPortalSearchYBottom = bottomY;
        this.portalLink.returnPortalSearchYTop = topY;
        return this;
    }
}

