/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.mixin;

import net.kyrptonaught.customportalapi.interfaces.CustomTeleportingEntity;
import net.kyrptonaught.customportalapi.interfaces.EntityInCustomPortal;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_5454;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class})
public abstract class EntityMixin
implements EntityInCustomPortal,
CustomTeleportingEntity {
    @Unique
    boolean didTP = false;
    @Unique
    int timeInPortal = 0;
    @Unique
    int maxTimeInPortal = 80;
    @Unique
    int cooldown = 0;
    @Unique
    private class_2338 inPortalPos;
    private class_5454 customTPTarget;

    @Override
    @Unique
    public boolean didTeleport() {
        return this.didTP;
    }

    @Override
    @Unique
    public void setDidTP(boolean didTP) {
        this.didTP = didTP;
        if (didTP) {
            this.timeInPortal = this.maxTimeInPortal;
            this.cooldown = 10;
        } else {
            this.timeInPortal = 0;
            this.cooldown = 0;
        }
    }

    @Override
    @Unique
    public int getTimeInPortal() {
        return this.timeInPortal;
    }

    @Override
    @Unique
    public void tickInPortal(class_2338 portalPos) {
        this.cooldown = 10;
        this.inPortalPos = portalPos;
    }

    @Override
    @Unique
    public class_2338 getInPortalPos() {
        return this.inPortalPos;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void CPAinCustomPortal(CallbackInfo ci) {
        if (this.cooldown > 0) {
            --this.cooldown;
            this.timeInPortal = Math.min(this.timeInPortal + 1, this.maxTimeInPortal);
            if (this.cooldown <= 0) {
                this.setDidTP(false);
            }
        }
    }

    @Override
    @Unique
    public void setCustomTeleportTarget(class_5454 teleportTarget) {
        this.customTPTarget = teleportTarget;
    }

    @Override
    @Unique
    public class_5454 getCustomTeleportTarget() {
        return this.customTPTarget;
    }

    @Inject(method={"getTeleportTarget"}, at={@At(value="HEAD")}, cancellable=true)
    public void CPAgetCustomTPTarget(class_3218 destination, CallbackInfoReturnable<class_5454> cir) {
        if (this.didTeleport()) {
            cir.setReturnValue((Object)this.getCustomTeleportTarget());
        }
    }

    @Redirect(method={"moveToWorld"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;createEndSpawnPlatform(Lnet/minecraft/server/world/ServerWorld;)V"))
    public void CPAcancelEndPlatformSpawn(class_3218 world) {
        if (this.didTeleport()) {
            return;
        }
        class_3218.method_29200((class_3218)world);
    }

    @Inject(method={"readNbt"}, at={@At(value="TAIL")})
    public void CPAreadCustomPortalFromTag(class_2487 tag, CallbackInfo ci) {
        this.didTP = tag.method_10577("cpadidTP");
        this.cooldown = tag.method_10550("cpaCooldown");
    }

    @Inject(method={"writeNbt"}, at={@At(value="RETURN")})
    public void CPAwriteCustomPortalToTag(class_2487 tag, CallbackInfoReturnable<class_2487> cir) {
        ((class_2487)cir.getReturnValue()).method_10556("cpadidTP", this.didTP);
        ((class_2487)cir.getReturnValue()).method_10569("cpaCooldown", this.cooldown);
    }
}

