/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.networking;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.PerWorldPortals;
import net.kyrptonaught.customportalapi.networking.NetworkManager;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class PortalRegistrySync {
    public static void registerSyncOnPlayerJoin() {
        ServerPlayConnectionEvents.JOIN.register((serverPlayNetworkHandler, packetSender, minecraftServer) -> {
            for (PortalLink link : CustomPortalApiRegistry.getAllPortalLinks()) {
                packetSender.sendPacket(PortalRegistrySync.createPacket(link));
            }
        });
    }

    public static void syncLinkToAllPlayers(PortalLink link, MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            PortalRegistrySync.syncLinkToPlayer(link, player);
        }
    }

    public static void syncLinkToPlayer(PortalLink link, class_3222 player) {
        player.field_13987.method_14364(PortalRegistrySync.createPacket(link));
    }

    public static class_2596<?> createPacket(PortalLink link) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10812(link.block);
        buf.method_10812(link.dimID);
        buf.method_53002(link.colorID);
        return ServerPlayNetworking.createS2CPacket((class_2960)NetworkManager.SYNC_PORTALS, (class_2540)buf);
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerReceivePortalData() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkManager.SYNC_PORTALS, (client, handler, packet, sender) -> {
            class_2960 frameBlock = packet.method_10810();
            class_2960 dimID = packet.method_10810();
            int colorId = packet.readInt();
            PerWorldPortals.registerWorldPortal(new PortalLink(frameBlock, dimID, colorId));
        });
    }
}

