/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.portal;

import java.util.Optional;
import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.portal.PortalIgnitionSource;
import net.kyrptonaught.customportalapi.portal.frame.PortalFrameTester;
import net.kyrptonaught.customportalapi.util.CustomPortalHelper;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_3218;
import net.minecraft.class_5459;

public class PortalPlacer {
    public static boolean attemptPortalLight(class_1937 world, class_2338 portalPos, PortalIgnitionSource ignitionSource) {
        return PortalPlacer.attemptPortalLight(world, portalPos, CustomPortalHelper.getClosestFrameBlock(world, portalPos), ignitionSource);
    }

    public static boolean attemptPortalLight(class_1937 world, class_2338 portalPos, class_2338 framePos, PortalIgnitionSource ignitionSource) {
        class_2248 foundationBlock = world.method_8320(framePos).method_26204();
        PortalLink link = CustomPortalApiRegistry.getPortalLinkFromBase(foundationBlock);
        if (link == null || !link.doesIgnitionMatch(ignitionSource) || !link.canLightInDim(world.method_27983().method_29177())) {
            return false;
        }
        return PortalPlacer.createPortal(link, foundationBlock, world, portalPos, framePos, ignitionSource);
    }

    private static boolean createPortal(PortalLink link, class_2248 foundationBlock, class_1937 world, class_2338 portalPos, class_2338 framePos, PortalIgnitionSource ignitionSource) {
        Optional<PortalFrameTester> optional = link.getFrameTester().createInstanceOfPortalFrameTester().getNewPortal((class_1936)world, portalPos, class_2350.class_2351.field_11048, foundationBlock);
        if (optional.isPresent()) {
            if (optional.get().isRequestedSize(link.forcedWidth, link.forcedHeight) && link.getPortalPreIgniteEvent().attemptLight(ignitionSource.player, world, portalPos, framePos, ignitionSource)) {
                optional.get().lightPortal(foundationBlock);
                link.getPortalIgniteEvent().afterLight(ignitionSource.player, world, portalPos, framePos, ignitionSource);
            }
            return true;
        }
        return false;
    }

    public static Optional<class_5459.class_5460> createDestinationPortal(class_3218 world, class_2338 blockPos, class_2680 frameBlock, class_2350.class_2351 axis) {
        class_2784 worldBorder = world.method_8621();
        PortalLink link = CustomPortalApiRegistry.getPortalLinkFromBase(frameBlock.method_26204());
        PortalFrameTester portalFrameTester = link.getFrameTester().createInstanceOfPortalFrameTester();
        int topY = Math.min(world.method_31600(), world.method_31607() + world.method_32819()) - 5;
        int bottomY = world.method_31607() + 5;
        if (world.method_27983().method_29177().equals((Object)link.dimID)) {
            if (link.portalSearchYTop != null) {
                topY = link.portalSearchYTop;
            }
            if (link.portalSearchYBottom != null) {
                bottomY = link.portalSearchYBottom;
            }
        } else {
            if (link.returnPortalSearchYTop != null) {
                topY = link.returnPortalSearchYTop;
            }
            if (link.returnPortalSearchYBottom != null) {
                bottomY = link.returnPortalSearchYBottom;
            }
        }
        for (class_2338.class_2339 mutable : class_2338.method_30512((class_2338)blockPos, (int)32, (class_2350)class_2350.field_11039, (class_2350)class_2350.field_11035)) {
            class_2338 testingPos = mutable.method_10062();
            if (!worldBorder.method_11952(testingPos)) continue;
            for (int y = topY; y >= bottomY; --y) {
                class_2338 testRect;
                if (!PortalPlacer.canHoldPortal(world.method_8320(testingPos.method_33096(y))) || (testRect = portalFrameTester.doesPortalFitAt((class_1937)world, testingPos.method_33096(y + 1), axis)) == null) continue;
                portalFrameTester.createPortal((class_1937)world, testRect, frameBlock, axis);
                return Optional.of(portalFrameTester.getRectangle());
            }
        }
        portalFrameTester.createPortal((class_1937)world, blockPos, frameBlock, axis);
        return Optional.of(portalFrameTester.getRectangle());
    }

    private static boolean canHoldPortal(class_2680 state) {
        return state.method_51367();
    }
}

