/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.portal.frame;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.function.Predicate;
import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.CustomPortalsMod;
import net.kyrptonaught.customportalapi.portal.frame.PortalFrameTester;
import net.kyrptonaught.customportalapi.util.CustomPortalHelper;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.class_1297;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_5454;
import net.minecraft.class_5459;

public class FlatPortalAreaHelper
extends PortalFrameTester {
    protected int xSize = -1;
    protected int zSize = -1;
    protected final int maxXSize = 21;
    protected final int maxZSize = 21;

    @Override
    public FlatPortalAreaHelper init(class_1936 world, class_2338 blockPos, class_2350.class_2351 axis, class_2248 ... foundations) {
        this.VALID_FRAME = Sets.newHashSet((Object[])foundations);
        this.world = world;
        this.lowerCorner = this.getLowerCorner(blockPos, class_2350.class_2351.field_11048, class_2350.class_2351.field_11051);
        this.foundPortalBlocks = 0;
        if (this.lowerCorner == null) {
            this.lowerCorner = blockPos;
            this.zSize = 1;
            this.xSize = 1;
        } else {
            this.xSize = this.getSize(class_2350.class_2351.field_11048, 2, 21);
            if (this.xSize > 0) {
                this.zSize = this.getSize(class_2350.class_2351.field_11051, 2, 21);
                if (this.checkForValidFrame(class_2350.class_2351.field_11048, class_2350.class_2351.field_11051, this.xSize, this.zSize)) {
                    this.countExistingPortalBlocks(class_2350.class_2351.field_11048, class_2350.class_2351.field_11051, this.xSize, this.zSize);
                } else {
                    this.lowerCorner = null;
                    this.zSize = 1;
                    this.xSize = 1;
                }
            }
        }
        return this;
    }

    @Override
    public Optional<PortalFrameTester> getNewPortal(class_1936 worldAccess, class_2338 blockPos, class_2350.class_2351 axis, class_2248 ... foundations) {
        return this.getOrEmpty(worldAccess, blockPos, areaHelper -> areaHelper.isValidFrame() && areaHelper.foundPortalBlocks == 0, axis, foundations);
    }

    @Override
    public Optional<PortalFrameTester> getOrEmpty(class_1936 worldAccess, class_2338 blockPos, Predicate<PortalFrameTester> predicate, class_2350.class_2351 axis, class_2248 ... foundations) {
        return Optional.of(new FlatPortalAreaHelper().init(worldAccess, blockPos, axis, foundations)).filter(predicate);
    }

    @Override
    public boolean isAlreadyLitPortalFrame() {
        return this.isValidFrame() && this.foundPortalBlocks == this.xSize * this.zSize;
    }

    @Override
    public boolean isValidFrame() {
        return this.lowerCorner != null && this.xSize >= 2 && this.zSize >= 2 && this.xSize < 21 && this.zSize < 21;
    }

    @Override
    public void lightPortal(class_2248 frameBlock) {
        PortalLink link = CustomPortalApiRegistry.getPortalLinkFromBase(frameBlock);
        class_2680 blockState = CustomPortalHelper.blockWithAxis(link != null ? link.getPortalBlock().method_9564() : CustomPortalsMod.getDefaultPortalBlock().method_9564(), class_2350.class_2351.field_11052);
        class_2338.method_10097((class_2338)this.lowerCorner, (class_2338)this.lowerCorner.method_30513(class_2350.class_2351.field_11048, this.xSize - 1).method_30513(class_2350.class_2351.field_11051, this.zSize - 1)).forEach(blockPos -> this.world.method_8652(blockPos, blockState, 18));
    }

    @Override
    public void createPortal(class_1937 world, class_2338 pos, class_2680 frameBlock, class_2350.class_2351 axis) {
        int i;
        for (i = -1; i < 3; ++i) {
            world.method_8501(pos.method_30513(class_2350.class_2351.field_11048, i).method_30513(class_2350.class_2351.field_11051, -1), frameBlock);
            world.method_8501(pos.method_30513(class_2350.class_2351.field_11048, i).method_30513(class_2350.class_2351.field_11051, 2), frameBlock);
            world.method_8501(pos.method_30513(class_2350.class_2351.field_11051, i).method_30513(class_2350.class_2351.field_11048, -1), frameBlock);
            world.method_8501(pos.method_30513(class_2350.class_2351.field_11051, i).method_30513(class_2350.class_2351.field_11048, 2), frameBlock);
        }
        for (i = 0; i < 2; ++i) {
            this.placeLandingPad(world, pos.method_30513(class_2350.class_2351.field_11048, i).method_10074(), frameBlock);
            this.placeLandingPad(world, pos.method_30513(class_2350.class_2351.field_11048, i).method_30513(class_2350.class_2351.field_11051, 1).method_10074(), frameBlock);
            this.fillAirAroundPortal(world, pos.method_30513(class_2350.class_2351.field_11048, i).method_10084());
            this.fillAirAroundPortal(world, pos.method_30513(class_2350.class_2351.field_11048, i).method_30513(class_2350.class_2351.field_11051, 1).method_10084());
            this.fillAirAroundPortal(world, pos.method_30513(class_2350.class_2351.field_11048, i).method_10086(2));
            this.fillAirAroundPortal(world, pos.method_30513(class_2350.class_2351.field_11048, i).method_30513(class_2350.class_2351.field_11051, 1).method_10086(2));
        }
        this.lowerCorner = pos;
        this.zSize = 2;
        this.xSize = 2;
        this.world = world;
        this.foundPortalBlocks = 4;
        this.lightPortal(frameBlock.method_26204());
    }

    protected void fillAirAroundPortal(class_1937 world, class_2338 pos) {
        if (world.method_8320(pos).method_51367()) {
            world.method_8652(pos, class_2246.field_10124.method_9564(), 16);
        }
    }

    protected void placeLandingPad(class_1937 world, class_2338 pos, class_2680 frameBlock) {
        if (!world.method_8320(pos).method_51367()) {
            world.method_8501(pos, frameBlock);
        }
    }

    @Override
    public boolean isRequestedSize(int attemptWidth, int attemptHeight) {
        return (this.xSize == attemptWidth || attemptHeight == 0) && this.zSize == attemptHeight || attemptWidth == 0 || (this.xSize == attemptHeight || attemptHeight == 0) && (this.zSize == attemptWidth || attemptWidth == 0);
    }

    @Override
    public class_5459.class_5460 getRectangle() {
        return new class_5459.class_5460(this.lowerCorner, this.xSize, this.zSize);
    }

    @Override
    public class_2350.class_2351 getAxis1() {
        return class_2350.class_2351.field_11048;
    }

    @Override
    public class_2350.class_2351 getAxis2() {
        return class_2350.class_2351.field_11051;
    }

    @Override
    public class_2338 doesPortalFitAt(class_1937 world, class_2338 attemptPos, class_2350.class_2351 axis) {
        class_5459.class_5460 rect = class_5459.method_30574((class_2338)attemptPos.method_10084(), (class_2350.class_2351)class_2350.class_2351.field_11048, (int)4, (class_2350.class_2351)class_2350.class_2351.field_11051, (int)4, blockPos -> world.method_8320(blockPos).method_51367() && !world.method_8320(blockPos.method_10084()).method_51367() && !world.method_8320(blockPos.method_10084()).method_51176() && !world.method_8320(blockPos.method_10086(2)).method_51367() && !world.method_8320(blockPos.method_10086(2)).method_51176());
        return rect.field_25937 >= 4 && rect.field_25938 >= 4 ? rect.field_25936 : null;
    }

    @Override
    public class_243 getEntityOffsetInPortal(class_5459.class_5460 arg, class_1297 entity, class_2350.class_2351 portalAxis) {
        class_4048 entityDimensions = entity.method_18377(entity.method_18376());
        double xSize = (float)arg.field_25937 - entityDimensions.field_18067;
        double zSize = (float)arg.field_25938 - entityDimensions.field_18067;
        double deltaX = class_3532.method_15370((double)entity.method_23317(), (double)arg.field_25936.method_10263(), (double)((double)arg.field_25936.method_10263() + xSize));
        double deltaZ = class_3532.method_15370((double)entity.method_23321(), (double)arg.field_25936.method_10260(), (double)((double)arg.field_25936.method_10260() + zSize));
        return new class_243(deltaX, (double)arg.field_25936.method_10264(), deltaZ);
    }

    @Override
    public class_5454 getTPTargetInPortal(class_5459.class_5460 portalRect, class_2350.class_2351 portalAxis, class_243 prevOffset, class_1297 entity) {
        class_4048 entityDimensions = entity.method_18377(entity.method_18376());
        double xSize = (float)portalRect.field_25937 - entityDimensions.field_18067;
        double zSize = (float)portalRect.field_25938 - entityDimensions.field_18067;
        double x = class_3532.method_16436((double)prevOffset.field_1352, (double)portalRect.field_25936.method_10263(), (double)((double)portalRect.field_25936.method_10263() + xSize));
        double y = class_3532.method_16436((double)prevOffset.field_1351, (double)(portalRect.field_25936.method_10264() - 1), (double)(portalRect.field_25936.method_10264() + 1));
        double z = class_3532.method_16436((double)prevOffset.field_1350, (double)portalRect.field_25936.method_10260(), (double)((double)portalRect.field_25936.method_10260() + zSize));
        return new class_5454(new class_243(x, (double)(portalRect.field_25936.method_10264() + 1), z), entity.method_18798(), entity.method_36454(), entity.method_36455());
    }
}

