/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.portal.frame;

import java.util.HashSet;
import java.util.Optional;
import java.util.function.Predicate;
import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.portal.PortalIgnitionSource;
import net.kyrptonaught.customportalapi.util.CustomPortalHelper;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.class_1297;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_5454;
import net.minecraft.class_5459;
import net.minecraft.class_7923;

public abstract class PortalFrameTester {
    protected HashSet<class_2248> VALID_FRAME = null;
    protected int foundPortalBlocks;
    public class_2338 lowerCorner;
    protected class_1936 world;

    public abstract PortalFrameTester init(class_1936 var1, class_2338 var2, class_2350.class_2351 var3, class_2248 ... var4);

    public abstract Optional<PortalFrameTester> getNewPortal(class_1936 var1, class_2338 var2, class_2350.class_2351 var3, class_2248 ... var4);

    public abstract Optional<PortalFrameTester> getOrEmpty(class_1936 var1, class_2338 var2, Predicate<PortalFrameTester> var3, class_2350.class_2351 var4, class_2248 ... var5);

    public abstract boolean isAlreadyLitPortalFrame();

    public abstract boolean isValidFrame();

    public abstract void lightPortal(class_2248 var1);

    public abstract void createPortal(class_1937 var1, class_2338 var2, class_2680 var3, class_2350.class_2351 var4);

    public abstract boolean isRequestedSize(int var1, int var2);

    public abstract class_5459.class_5460 getRectangle();

    public abstract class_2350.class_2351 getAxis1();

    public abstract class_2350.class_2351 getAxis2();

    public abstract class_2338 doesPortalFitAt(class_1937 var1, class_2338 var2, class_2350.class_2351 var3);

    public abstract class_243 getEntityOffsetInPortal(class_5459.class_5460 var1, class_1297 var2, class_2350.class_2351 var3);

    public abstract class_5454 getTPTargetInPortal(class_5459.class_5460 var1, class_2350.class_2351 var2, class_243 var3, class_1297 var4);

    protected class_2338 getLowerCorner(class_2338 blockPos, class_2350.class_2351 axis1, class_2350.class_2351 axis2) {
        if (!PortalFrameTester.validStateInsidePortal(this.world.method_8320(blockPos), this.VALID_FRAME)) {
            return null;
        }
        return this.getLimitForAxis(this.getLimitForAxis(blockPos, axis1), axis2);
    }

    protected class_2338 getLimitForAxis(class_2338 blockPos, class_2350.class_2351 axis) {
        if (blockPos == null || axis == null) {
            return null;
        }
        int offset = 1;
        while (PortalFrameTester.validStateInsidePortal(this.world.method_8320(blockPos.method_30513(axis, -offset)), this.VALID_FRAME)) {
            if (++offset > 20) {
                return null;
            }
            if ((!axis.equals((Object)class_2350.class_2351.field_11052) || blockPos.method_10264() - offset >= this.world.method_31607()) && (axis.equals((Object)class_2350.class_2351.field_11052) || this.world.method_8621().method_11952(blockPos.method_30513(axis, -offset)))) continue;
            return null;
        }
        return blockPos.method_30513(axis, -(offset - 1));
    }

    protected int getSize(class_2350.class_2351 axis, int minSize, int maxSize) {
        for (int i = 1; i <= maxSize; ++i) {
            class_2680 blockState = this.world.method_8320(this.lowerCorner.method_30513(axis, i));
            if (PortalFrameTester.validStateInsidePortal(blockState, this.VALID_FRAME)) continue;
            if (!this.VALID_FRAME.contains(blockState.method_26204())) break;
            return i >= minSize ? i : 0;
        }
        return 0;
    }

    protected boolean checkForValidFrame(class_2350.class_2351 axis1, class_2350.class_2351 axis2, int size1, int size2) {
        int i;
        class_2338.class_2339 checkPos = this.lowerCorner.method_25503();
        for (i = 0; i < size1; ++i) {
            if (!this.VALID_FRAME.contains(this.world.method_8320(checkPos.method_30513(axis2, -1)).method_26204()) || !this.VALID_FRAME.contains(this.world.method_8320(checkPos.method_30513(axis2, size2)).method_26204())) {
                return false;
            }
            checkPos = checkPos.method_30513(axis1, 1);
        }
        checkPos = this.lowerCorner.method_25503();
        for (i = 0; i < size2; ++i) {
            if (!this.VALID_FRAME.contains(this.world.method_8320(checkPos.method_30513(axis1, -1)).method_26204()) || !this.VALID_FRAME.contains(this.world.method_8320(checkPos.method_30513(axis1, size1)).method_26204())) {
                return false;
            }
            checkPos = checkPos.method_30513(axis2, 1);
        }
        return true;
    }

    protected void countExistingPortalBlocks(class_2350.class_2351 axis1, class_2350.class_2351 axis2, int size1, int size2) {
        for (int i = 0; i < size1; ++i) {
            for (int j = 0; j < size2; ++j) {
                if (!CustomPortalHelper.isInstanceOfCustomPortal(this.world.method_8320(this.lowerCorner.method_30513(axis1, i).method_30513(axis2, j)))) continue;
                ++this.foundPortalBlocks;
            }
        }
    }

    public static boolean validStateInsidePortal(class_2680 blockState, HashSet<class_2248> foundations) {
        PortalIgnitionSource ignitionSource = PortalIgnitionSource.FIRE;
        for (class_2248 block : foundations) {
            PortalLink link = CustomPortalApiRegistry.getPortalLinkFromBase(block);
            if (link == null) continue;
            ignitionSource = link.portalIgnitionSource;
            break;
        }
        if (blockState.method_26215() || CustomPortalHelper.isInstanceOfCustomPortal(blockState)) {
            return true;
        }
        if (ignitionSource == PortalIgnitionSource.FIRE) {
            return blockState.method_26164(class_3481.field_21952);
        }
        if (ignitionSource.isWater()) {
            return blockState.method_26227().method_15767(class_3486.field_15517);
        }
        if (ignitionSource.isLava()) {
            return blockState.method_26227().method_15767(class_3486.field_15518);
        }
        if (ignitionSource.sourceType == PortalIgnitionSource.SourceType.FLUID) {
            return class_7923.field_41173.method_10221((Object)blockState.method_26227().method_15772()).equals((Object)ignitionSource.ignitionSourceID);
        }
        return false;
    }

    @FunctionalInterface
    public static interface PortalFrameTesterFactory {
        public PortalFrameTester createInstanceOfPortalFrameTester();
    }
}

