/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.portal.frame;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.function.Predicate;
import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.CustomPortalsMod;
import net.kyrptonaught.customportalapi.portal.frame.PortalFrameTester;
import net.kyrptonaught.customportalapi.util.CustomPortalHelper;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_5454;
import net.minecraft.class_5459;

public class VanillaPortalAreaHelper
extends PortalFrameTester {
    protected class_2350.class_2351 axis;
    protected int height;
    protected int width;
    protected final int maxWidth = 21;
    protected final int maxHeight = 21;

    @Override
    public PortalFrameTester init(class_1936 world, class_2338 blockPos, class_2350.class_2351 axis, class_2248 ... foundations) {
        this.VALID_FRAME = Sets.newHashSet((Object[])foundations);
        this.world = world;
        this.axis = axis;
        this.lowerCorner = this.getLowerCorner(blockPos, axis, class_2350.class_2351.field_11052);
        this.foundPortalBlocks = 0;
        if (this.lowerCorner == null) {
            this.lowerCorner = blockPos;
            this.height = 1;
            this.width = 1;
        } else {
            this.width = this.getSize(axis, 2, 21);
            if (this.width > 0) {
                this.height = this.getSize(class_2350.class_2351.field_11052, 3, 21);
                if (this.checkForValidFrame(axis, class_2350.class_2351.field_11052, this.width, this.height)) {
                    this.countExistingPortalBlocks(axis, class_2350.class_2351.field_11052, this.width, this.height);
                } else {
                    this.lowerCorner = null;
                    this.height = 1;
                    this.width = 1;
                }
            }
        }
        return this;
    }

    @Override
    public class_5459.class_5460 getRectangle() {
        return new class_5459.class_5460(this.lowerCorner, this.width, this.height);
    }

    @Override
    public class_2350.class_2351 getAxis1() {
        return this.axis;
    }

    @Override
    public class_2350.class_2351 getAxis2() {
        return class_2350.class_2351.field_11052;
    }

    @Override
    public Optional<PortalFrameTester> getNewPortal(class_1936 worldAccess, class_2338 blockPos, class_2350.class_2351 axis, class_2248 ... foundations) {
        return this.getOrEmpty(worldAccess, blockPos, customAreaHelper -> customAreaHelper.isValidFrame() && customAreaHelper.foundPortalBlocks == 0, axis, foundations);
    }

    @Override
    public Optional<PortalFrameTester> getOrEmpty(class_1936 worldAccess, class_2338 blockPos, Predicate<PortalFrameTester> predicate, class_2350.class_2351 axis, class_2248 ... foundations) {
        Optional<PortalFrameTester> optional = Optional.of(new VanillaPortalAreaHelper().init(worldAccess, blockPos, axis, foundations)).filter(predicate);
        if (optional.isPresent()) {
            return optional;
        }
        class_2350.class_2351 axis2 = axis == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        return Optional.of(new VanillaPortalAreaHelper().init(worldAccess, blockPos, axis2, foundations)).filter(predicate);
    }

    @Override
    public boolean isAlreadyLitPortalFrame() {
        return this.isValidFrame() && this.foundPortalBlocks == this.width * this.height;
    }

    @Override
    public boolean isValidFrame() {
        return this.lowerCorner != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    @Override
    public boolean isRequestedSize(int attemptWidth, int attemptHeight) {
        return !(attemptWidth != 0 && this.width != attemptWidth || attemptHeight != 0 && this.height != attemptHeight);
    }

    @Override
    public class_2338 doesPortalFitAt(class_1937 world, class_2338 attemptPos, class_2350.class_2351 axis) {
        if (this.isEmptySpace(world.method_8320(attemptPos)) && this.isEmptySpace(world.method_8320(attemptPos.method_30513(axis, 1))) && this.isEmptySpace(world.method_8320(attemptPos.method_10084())) && this.isEmptySpace(world.method_8320(attemptPos.method_30513(axis, 1).method_10084())) && this.isEmptySpace(world.method_8320(attemptPos.method_10086(2))) && this.isEmptySpace(world.method_8320(attemptPos.method_30513(axis, 1).method_10086(2))) && this.canHoldPortal(world, attemptPos.method_10074()) && this.canHoldPortal(world, attemptPos.method_30513(axis, 1).method_10074())) {
            return attemptPos;
        }
        return null;
    }

    protected boolean isEmptySpace(class_2680 blockState) {
        return blockState.method_45474() && blockState.method_26227().method_15769();
    }

    protected boolean canHoldPortal(class_1937 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        return blockState.method_51367() && blockState.method_26212((class_1922)world, pos) && !this.isEmptySpace(blockState);
    }

    @Override
    public class_243 getEntityOffsetInPortal(class_5459.class_5460 arg, class_1297 entity, class_2350.class_2351 portalAxis) {
        class_4048 entityDimensions = entity.method_18377(entity.method_18376());
        double width = (float)arg.field_25937 - entityDimensions.field_18067;
        double height = (float)arg.field_25938 - entityDimensions.field_18068;
        double deltaX = class_3532.method_15370((double)entity.method_23317(), (double)arg.field_25936.method_10263(), (double)((double)arg.field_25936.method_10263() + width));
        double deltaY = class_3532.method_15370((double)entity.method_23318(), (double)arg.field_25936.method_10264(), (double)((double)arg.field_25936.method_10264() + height));
        double deltaZ = class_3532.method_15370((double)entity.method_23321(), (double)arg.field_25936.method_10260(), (double)((double)arg.field_25936.method_10260() + width));
        return new class_243(deltaX, deltaY, deltaZ);
    }

    @Override
    public class_5454 getTPTargetInPortal(class_5459.class_5460 portalRect, class_2350.class_2351 portalAxis, class_243 prevOffset, class_1297 entity) {
        class_4048 entityDimensions = entity.method_18377(entity.method_18376());
        double width = (float)portalRect.field_25937 - entityDimensions.field_18067;
        double height = (float)portalRect.field_25938 - entityDimensions.field_18068;
        double x = class_3532.method_16436((double)prevOffset.field_1352, (double)portalRect.field_25936.method_10263(), (double)((double)portalRect.field_25936.method_10263() + width));
        double y = class_3532.method_16436((double)prevOffset.field_1351, (double)portalRect.field_25936.method_10264(), (double)((double)portalRect.field_25936.method_10264() + height));
        double z = class_3532.method_16436((double)prevOffset.field_1350, (double)portalRect.field_25936.method_10260(), (double)((double)portalRect.field_25936.method_10260() + width));
        if (portalAxis == class_2350.class_2351.field_11048) {
            z = (double)portalRect.field_25936.method_10260() + 0.5;
        } else if (portalAxis == class_2350.class_2351.field_11051) {
            x = (double)portalRect.field_25936.method_10263() + 0.5;
        }
        return new class_5454(new class_243(x, y, z), entity.method_18798(), entity.method_36454(), entity.method_36455());
    }

    @Override
    public void lightPortal(class_2248 frameBlock) {
        PortalLink link = CustomPortalApiRegistry.getPortalLinkFromBase(frameBlock);
        class_2680 blockState = CustomPortalHelper.blockWithAxis(link != null ? link.getPortalBlock().method_9564() : CustomPortalsMod.getDefaultPortalBlock().method_9564(), this.axis);
        class_2338.method_10097((class_2338)this.lowerCorner, (class_2338)this.lowerCorner.method_10079(class_2350.field_11036, this.height - 1).method_30513(this.axis, this.width - 1)).forEach(blockPos -> this.world.method_8652(blockPos, blockState, 18));
    }

    @Override
    public void createPortal(class_1937 world, class_2338 pos, class_2680 frameBlock, class_2350.class_2351 axis) {
        int i;
        class_2350.class_2351 rotatedAxis = axis == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        for (i = -1; i < 4; ++i) {
            world.method_8501(pos.method_10086(i).method_30513(axis, -1), frameBlock);
            world.method_8501(pos.method_10086(i).method_30513(axis, 2), frameBlock);
            if (i < 0) continue;
            this.fillAirAroundPortal(world, pos.method_10086(i).method_30513(axis, -1).method_30513(rotatedAxis, 1));
            this.fillAirAroundPortal(world, pos.method_10086(i).method_30513(axis, 2).method_30513(rotatedAxis, 1));
            this.fillAirAroundPortal(world, pos.method_10086(i).method_30513(axis, -1).method_30513(rotatedAxis, -1));
            this.fillAirAroundPortal(world, pos.method_10086(i).method_30513(axis, 2).method_30513(rotatedAxis, -1));
        }
        for (i = -1; i < 3; ++i) {
            world.method_8501(pos.method_10086(-1).method_30513(axis, i), frameBlock);
            world.method_8501(pos.method_10086(3).method_30513(axis, i), frameBlock);
            this.fillAirAroundPortal(world, pos.method_10086(3).method_30513(axis, i).method_30513(rotatedAxis, 1));
            this.fillAirAroundPortal(world, pos.method_10086(3).method_30513(axis, i).method_30513(rotatedAxis, -1));
        }
        this.placeLandingPad(world, pos.method_10074().method_30513(rotatedAxis, 1), frameBlock);
        this.placeLandingPad(world, pos.method_10074().method_30513(rotatedAxis, -1), frameBlock);
        this.placeLandingPad(world, pos.method_10074().method_30513(axis, 1).method_30513(rotatedAxis, 1), frameBlock);
        this.placeLandingPad(world, pos.method_10074().method_30513(axis, 1).method_30513(rotatedAxis, -1), frameBlock);
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.fillAirAroundPortal(world, pos.method_30513(axis, i).method_10086(j).method_30513(rotatedAxis, 1));
                this.fillAirAroundPortal(world, pos.method_30513(axis, i).method_10086(j).method_30513(rotatedAxis, -1));
            }
        }
        this.lowerCorner = pos;
        this.width = 2;
        this.height = 3;
        this.axis = axis;
        this.world = world;
        this.foundPortalBlocks = 6;
        this.lightPortal(frameBlock.method_26204());
    }

    protected void fillAirAroundPortal(class_1937 world, class_2338 pos) {
        if (world.method_8320(pos).method_51367() || world.method_8320(pos).method_26212((class_1922)world, pos)) {
            world.method_8652(pos, class_2246.field_10124.method_9564(), 16);
        }
    }

    protected void placeLandingPad(class_1937 world, class_2338 pos, class_2680 frameBlock) {
        if (!world.method_8320(pos).method_51367()) {
            world.method_8501(pos, frameBlock);
        }
    }
}

