/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.things.items.trinkets;

import com.glisco.things.Things;
import com.glisco.things.items.ThingsItems;
import com.glisco.things.mixin.ItemUsageContextAccessor;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Multimap;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketItem;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.client.TrinketRenderer;
import dev.emi.trinkets.api.client.TrinketRendererRegistry;
import io.wispforest.owo.network.ServerAccess;
import io.wispforest.owo.serialization.Endec;
import io.wispforest.owo.serialization.endec.BuiltInEndecs;
import io.wispforest.owo.serialization.endec.KeyedEndec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_583;
import org.jetbrains.annotations.Nullable;

public class AgglomerationItem
extends TrinketItem
implements TrinketRenderer {
    public static final KeyedEndec<Byte> SELECTED_TRINKET_KEY = Endec.BYTE.keyed("SelectedTrinket", (Object)0);
    public static final KeyedEndec<List<class_1799>> ITEMS_KEY = BuiltInEndecs.ITEM_STACK.listOf().keyed("Items", ArrayList::new);
    private static final LoadingCache<class_1799, StackData> CACHE = CacheBuilder.newBuilder().concurrencyLevel(1).maximumSize(200L).weakKeys().build(CacheLoader.from(StackData::new));

    public AgglomerationItem() {
        super(new class_1792.class_1793().method_7889(1).method_7894(class_1814.field_8907));
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        return this.getStackAndRun(stack, player, innerStack -> innerStack.method_31576(class_1799.field_8037, slot, clickType, player, cursorStackReference), () -> false);
    }

    public class_1269 method_7884(class_1838 context) {
        return this.getStackAndRun(context.method_8041(), context.method_8036(), innerStack -> innerStack.method_7981(new class_1838(context.method_8045(), context.method_8036(), context.method_20287(), innerStack, ((ItemUsageContextAccessor)context).things$getHitResult())), () -> class_1269.field_5814);
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        class_1657 player;
        return this.getStackAndRun(stack, user instanceof class_1657 ? (player = (class_1657)user) : null, innerStack -> innerStack.method_7910(world, user), () -> stack);
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player) {
        return this.getStackAndRun(stack, player, innerStack -> innerStack.method_31575(slot, clickType, player), () -> false);
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        class_1657 player;
        return this.getStackAndRun(stack, attacker instanceof class_1657 ? (player = (class_1657)attacker) : null, innerStack -> {
            innerStack.method_7979(target, (class_1657)attacker);
            return true;
        }, () -> false);
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        class_1657 player;
        return this.getStackAndRun(stack, miner instanceof class_1657 ? (player = (class_1657)miner) : null, innerStack -> {
            innerStack.method_7952(world, state, pos, (class_1657)miner);
            return true;
        }, () -> false);
    }

    public class_1269 method_7847(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        return this.getStackAndRun(stack, user, innerStack -> innerStack.method_7920(user, entity, hand), () -> class_1269.field_5814);
    }

    public boolean method_7838(class_1799 stack) {
        return this.getStackAndRun(stack, null, class_1799::method_7967, () -> false);
    }

    public <T> T getStackAndRun(class_1799 stack, class_1657 player, Function<class_1799, T> methodPassthru, Supplier<T> error) {
        StackData data = AgglomerationItem.getDataFor(stack);
        Byte selectedTrinket = (Byte)stack.get(SELECTED_TRINKET_KEY);
        if (selectedTrinket >= data.subStacks.size()) {
            return error.get();
        }
        T value = methodPassthru.apply(data.subStacks.get(selectedTrinket.byteValue()));
        data.updateStackIfNeeded(selectedTrinket.byteValue(), (class_1309)player);
        return value;
    }

    public static void scrollSelectedStack(class_1799 stack) {
        stack.put(SELECTED_TRINKET_KEY, (Object)((byte)(stack.has(SELECTED_TRINKET_KEY) && (Byte)stack.get(SELECTED_TRINKET_KEY) == 0 ? 1 : 0)));
    }

    private static StackData getDataFor(class_1799 stack) {
        StackData data = (StackData)CACHE.getUnchecked((Object)stack);
        if (data.isInvalid()) {
            CACHE.refresh((Object)stack);
            data = (StackData)CACHE.getUnchecked((Object)stack);
        }
        return data;
    }

    public static class_1799 createStack(class_1799 ... items) {
        class_1799 stack = new class_1799((class_1935)ThingsItems.AGGLOMERATION, 1);
        stack.put(ITEMS_KEY, Arrays.asList(items));
        stack.put(SELECTED_TRINKET_KEY, (Object)0);
        return stack;
    }

    public static List<class_1799> getStacks(class_1799 stack) {
        return AgglomerationItem.getDataFor((class_1799)stack).subStacks;
    }

    public static boolean hasStack(class_1799 stack, Predicate<class_1799> predicate) {
        StackData data = AgglomerationItem.getDataFor(stack);
        for (int i = 0; i < data.subStacks.size(); ++i) {
            class_1799 subStack = data.subStacks.get(i);
            if (predicate.test(subStack)) {
                return true;
            }
            if (!subStack.method_31574(ThingsItems.AGGLOMERATION) || !AgglomerationItem.hasStack(subStack, predicate)) continue;
            return true;
        }
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        StackData data = AgglomerationItem.getDataFor(user.method_5998(hand));
        for (class_1799 stack : data.subStacks) {
            if (!stack.method_7960()) continue;
            class_1799 cake = new class_1799((class_1935)class_1802.field_17534);
            cake.method_7977((class_2561)class_2561.method_43471((String)"item.things.consolation_cake"));
            user.method_31548().method_7398(cake);
            return class_1271.method_22427((Object)class_1799.field_8037);
        }
        return super.method_7836(world, user, hand);
    }

    public void onEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
        StackData data = AgglomerationItem.getDataFor(stack);
        for (int i = 0; i < data.subStacks.size(); ++i) {
            class_1799 subStack = data.subStacks.get(i);
            TrinketsApi.getTrinket((class_1792)subStack.method_7909()).onEquip(subStack, slot, entity);
            data.updateStackIfNeeded(i, entity);
        }
    }

    public void onUnequip(class_1799 stack, SlotReference slot, class_1309 entity) {
        StackData data = AgglomerationItem.getDataFor(stack);
        for (int i = 0; i < data.subStacks.size(); ++i) {
            class_1799 subStack = data.subStacks.get(i);
            TrinketsApi.getTrinket((class_1792)subStack.method_7909()).onUnequip(subStack, slot, entity);
            data.updateStackIfNeeded(i, entity);
        }
    }

    public void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
        super.tick(stack, slot, entity);
        StackData data = AgglomerationItem.getDataFor(stack);
        for (int i = 0; i < data.subStacks.size(); ++i) {
            class_1799 subStack = data.subStacks.get(i);
            TrinketsApi.getTrinket((class_1792)subStack.method_7909()).tick(subStack, slot, entity);
            data.updateStackIfNeeded(i, entity);
        }
    }

    public boolean canEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
        StackData data = AgglomerationItem.getDataFor(stack);
        for (int i = 0; i < data.subStacks.size(); ++i) {
            class_1799 subStack = data.subStacks.get(i);
            if (!TrinketsApi.evaluatePredicateSet((Set)slot.inventory().getSlotType().getValidatorPredicates(), (class_1799)subStack, (SlotReference)slot, (class_1309)entity)) {
                return false;
            }
            if (TrinketsApi.getTrinket((class_1792)subStack.method_7909()).canEquip(subStack, slot, entity)) continue;
            return false;
        }
        return super.canEquip(stack, slot, entity);
    }

    public boolean canUnequip(class_1799 stack, SlotReference slot, class_1309 entity) {
        StackData data = AgglomerationItem.getDataFor(stack);
        for (int i = 0; i < data.subStacks.size(); ++i) {
            class_1799 subStack = data.subStacks.get(i);
            if (TrinketsApi.getTrinket((class_1792)subStack.method_7909()).canUnequip(subStack, slot, entity)) continue;
            return false;
        }
        return super.canUnequip(stack, slot, entity);
    }

    public Multimap<class_1320, class_1322> getModifiers(class_1799 stack, SlotReference slot, class_1309 entity, UUID uuid) {
        Multimap modifiers = super.getModifiers(stack, slot, entity, uuid);
        StackData data = AgglomerationItem.getDataFor(stack);
        for (int i = 0; i < data.subStacks.size(); ++i) {
            class_1799 subStack = data.subStacks.get(i);
            modifiers.putAll(TrinketsApi.getTrinket((class_1792)subStack.method_7909()).getModifiers(subStack, slot, entity, uuid));
        }
        return modifiers;
    }

    @Environment(value=EnvType.CLIENT)
    public void render(class_1799 stack, SlotReference slotReference, class_583<? extends class_1309> contextModel, class_4587 matrices, class_4597 vertexConsumers, int light, class_1309 entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        if (!Things.CONFIG.renderAgglomerationTrinket()) {
            return;
        }
        StackData data = AgglomerationItem.getDataFor(stack);
        for (int i = 0; i < data.subStacks.size(); ++i) {
            class_1799 subStack = data.subStacks.get(i);
            TrinketRenderer renderer = TrinketRendererRegistry.getRenderer((class_1792)subStack.method_7909()).orElse(null);
            if (renderer == null) continue;
            matrices.method_22903();
            renderer.render(subStack, slotReference, contextModel, matrices, vertexConsumers, light, entity, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch);
            matrices.method_22909();
        }
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        StackData data = AgglomerationItem.getDataFor(stack);
        for (int i = 0; i < data.subStacks.size(); ++i) {
            List subTooltip = data.subStacks.get(i).method_7950(null, context);
            for (int j = 0; j < subTooltip.size(); ++j) {
                if (j == 0) {
                    tooltip.add((class_2561)class_2561.method_43470((String)(stack.method_7985() && (Byte)stack.get(SELECTED_TRINKET_KEY) == i ? "> " : "\u2022 ")).method_10852((class_2561)subTooltip.get(j)));
                    continue;
                }
                tooltip.add((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)subTooltip.get(j)));
            }
        }
        for (class_1799 subStack : data.subStacks) {
            if (!subStack.method_7960()) continue;
            tooltip.add((class_2561)class_2561.method_43473());
            tooltip.add((class_2561)class_2561.method_43471((String)"item.things.consolation_cake.hint"));
        }
    }

    private static class StackData {
        private final class_1799 stack;
        private final List<class_1799> subStacks = new ArrayList<class_1799>();
        private final List<class_1799> defensiveCopies = new ArrayList<class_1799>();
        private class_2487 defensiveNbtData;

        public StackData(class_1799 stack) {
            this.stack = stack;
            if (stack.method_7985()) {
                this.defensiveNbtData = stack.method_7969().method_10553();
                List items = (List)stack.get(ITEMS_KEY);
                for (class_1799 item : items) {
                    this.subStacks.add(item);
                    this.defensiveCopies.add(item.method_7972());
                }
            }
        }

        public boolean isInvalid() {
            return !Objects.equals(this.stack.method_7969(), this.defensiveNbtData);
        }

        public void updateStackIfNeeded(int idx, class_1309 entity) {
            if (class_1799.method_7973((class_1799)this.subStacks.get(idx), (class_1799)this.defensiveCopies.get(idx))) {
                return;
            }
            if (this.subStacks.get(idx).method_31574(class_1802.field_8162) && entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                Things.AN_AMAZINGLY_EXPENSIVE_MISTAKE_CRITERION.trigger(player);
            }
            this.defensiveCopies.set(idx, this.subStacks.get(idx).method_7972());
            List itemsTag = (List)this.stack.get(ITEMS_KEY);
            itemsTag.set(idx, this.subStacks.get(idx));
            this.defensiveNbtData = this.stack.method_7969().method_10553();
        }
    }

    public record ScrollStackFromSlotTrinket(boolean fromPlayerInv, int slotId) {
        public static void scrollItemStack(ScrollStackFromSlotTrinket message, ServerAccess access) {
            class_1799 stack;
            class_1799 class_17992 = stack = message.fromPlayerInv ? access.player().method_31548().method_5438(message.slotId) : access.player().field_7512.method_7611(message.slotId).method_7677();
            if (stack == null) {
                return;
            }
            AgglomerationItem.scrollSelectedStack(stack);
        }
    }

    public record ScrollHandStackTrinket(boolean mainHandStack) {
        public static void scrollItemStack(ScrollHandStackTrinket message, ServerAccess access) {
            class_1799 stack = message.mainHandStack ? access.player().method_6047() : access.player().method_6079();
            AgglomerationItem.scrollSelectedStack(stack);
            StackData data = AgglomerationItem.getDataFor(stack);
            access.player().method_43502((class_2561)class_2561.method_43470((String)"> ").method_10852((class_2561)class_2561.method_43471((String)data.subStacks.get(((Byte)stack.get(SELECTED_TRINKET_KEY)).byteValue()).method_7922())), true);
        }
    }
}

