/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.veinmining.platform;

import com.google.common.collect.ImmutableMap;
import com.illusivesoulworks.veinmining.VeinMiningFabricMod;
import com.illusivesoulworks.veinmining.common.config.VeinMiningConfig;
import com.illusivesoulworks.veinmining.common.platform.services.IPlatform;
import com.illusivesoulworks.veinmining.common.veinmining.VeinMiningPlayers;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_1934;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5552;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class FabricPlatform
implements IPlatform {
    @Override
    public Set<String> getBlocksFromTag(class_2960 resourceLocation) {
        HashSet<String> result = new HashSet<String>();
        class_7923.field_41175.method_40266(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)resourceLocation)).ifPresent(block -> {
            for (class_6880 blockHolder : block) {
                blockHolder.method_40230().ifPresent(key -> result.add(key.method_29177().toString()));
            }
        });
        return result;
    }

    @Override
    public class_1886 getEnchantmentCategory() {
        return class_1886.field_9069;
    }

    @Override
    public class_1887 getVeinMiningEnchantment() {
        return VeinMiningFabricMod.VEIN_MINING_ENCHANTMENT;
    }

    @Override
    public Optional<class_1887> getEnchantment(class_2960 resourceLocation) {
        return Optional.ofNullable((class_1887)class_7923.field_41176.method_10223(resourceLocation));
    }

    @Override
    public Optional<class_1792> getItem(class_2960 resourceLocation) {
        return Optional.of((class_1792)class_7923.field_41178.method_10223(resourceLocation));
    }

    @Override
    public Optional<class_2248> getBlock(class_2960 resourceLocation) {
        return Optional.of((class_2248)class_7923.field_41175.method_10223(resourceLocation));
    }

    @Override
    public Optional<class_2960> getResourceLocation(class_1887 enchantment) {
        return Optional.ofNullable(class_7923.field_41176.method_10221((Object)enchantment));
    }

    @Override
    public Optional<class_2960> getResourceLocation(class_1792 item) {
        return Optional.of(class_7923.field_41178.method_10221((Object)item));
    }

    @Override
    public Optional<class_2960> getResourceLocation(class_2248 block) {
        return Optional.of(class_7923.field_41175.method_10221((Object)block));
    }

    @Override
    public Map<String, Predicate<class_1799>> buildEnchantableItems() {
        return ImmutableMap.of();
    }

    @Override
    public boolean canHarvestDrops(class_3222 playerEntity, class_2680 state) {
        return playerEntity.method_7305(state);
    }

    @Override
    public boolean harvest(class_3222 player, class_2338 pos, class_2338 originPos) {
        class_1937 level = player.method_37908();
        class_2680 blockState = level.method_8320(pos);
        class_1934 gameModeForPlayer = player.field_13974.method_14257();
        if (!player.method_6047().method_7909().method_7885(blockState, level, pos, (class_1657)player)) {
            return false;
        }
        class_2586 blockEntity = level.method_8321(pos);
        class_2248 block = blockState.method_26204();
        if (block instanceof class_5552 && !player.method_7338()) {
            level.method_8413(pos, blockState, blockState, 3);
            return false;
        }
        if (player.method_21701(level, pos, gameModeForPlayer)) {
            return false;
        }
        boolean result = ((PlayerBlockBreakEvents.Before)PlayerBlockBreakEvents.BEFORE.invoker()).beforeBlockBreak(level, (class_1657)player, pos, blockState, blockEntity);
        if (!result) {
            ((PlayerBlockBreakEvents.Canceled)PlayerBlockBreakEvents.CANCELED.invoker()).onBlockBreakCanceled(level, (class_1657)player, pos, blockState, blockEntity);
            return false;
        }
        block.method_9576(level, pos, blockState, (class_1657)player);
        boolean bl = level.method_8650(pos, false);
        if (bl) {
            ((PlayerBlockBreakEvents.After)PlayerBlockBreakEvents.AFTER.invoker()).afterBlockBreak(level, (class_1657)player, pos, blockState, blockEntity);
            block.method_9585((class_1936)level, pos, blockState);
        }
        if (player.method_7337()) {
            return true;
        }
        class_1799 itemStack = player.method_6047();
        class_1799 itemStack2 = itemStack.method_7972();
        boolean bl2 = player.method_7305(blockState);
        itemStack.method_7952(level, blockState, pos, (class_1657)player);
        if (bl && bl2) {
            class_2338 spawnPos = (Boolean)VeinMiningConfig.SERVER.relocateDrops.get() != false ? originPos : pos;
            class_1702 foodData = player.method_7344();
            float currentExhaustion = foodData.method_35219();
            VeinMiningPlayers.addMiningBlock(level, pos, spawnPos);
            block.method_9556(level, (class_1657)player, pos, blockState, blockEntity, itemStack2);
            VeinMiningPlayers.removeMiningBlock(level, pos);
            if (((Boolean)VeinMiningConfig.SERVER.addExhaustion.get()).booleanValue()) {
                float diff = foodData.method_35219() - currentExhaustion;
                foodData.method_35218(currentExhaustion);
                foodData.method_7583((float)((double)diff * (Double)VeinMiningConfig.SERVER.exhaustionMultiplier.get()));
            } else {
                foodData.method_35218(currentExhaustion);
            }
        }
        return true;
    }

    @Override
    public Set<String> getItemsFromTag(class_2960 resourceLocation) {
        HashSet<String> result = new HashSet<String>();
        class_7923.field_41178.method_40266(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)resourceLocation)).ifPresent(item -> {
            for (class_6880 itemHolder : item) {
                itemHolder.method_40230().ifPresent(key -> result.add(key.method_29177().toString()));
            }
        });
        return result;
    }

    @Override
    public List<String> getDefaultItemsConfig() {
        return Arrays.asList("#c:axes", "#c:pickaxes", "#c:shovels", "#c:hoes");
    }

    @Override
    public List<String> getDefaultGroups() {
        return Arrays.asList("#c:adamantite_ores", "#c:aetherium_ores", "#c:aluminum_ores", "#c:amethyst_ores", "#c:antimony_ores", "#c:aquarium_ores", "#c:asterite_ores", "#c:banglum_ores", "#c:bauxite_ores", "#c:carmot_ores", "#c:certus_quartz_ores", "#c:cinnabar_ores", "#c:coal_ores", "#c:cobalt_ores", "#c:copper_ores", "#c:diamond_ores", "#c:emerald_ores", "#c:galaxium_ores", "#c:galena_ores", "#c:gold_ores,#minecraft:gold_ores", "#c:iridium_ores", "#c:iron_ores", "#c:kyber_ores", "#c:lapis_ores", "#c:lead_ores", "#c:lunum_ores", "#c:lutetium_ores", "#c:manganese_ores", "#c:metite_ores", "#c:mythril_ores", "#c:nickel_ores", "#c:orichalcum_ores", "#c:osmium_ores", "#c:palladium_ores", "#c:peridot_ores", "#c:platinum_ores", "#c:prometheum_ores", "#c:pyrite_ores", "#c:quadrillum_ores", "#c:quartz_ores", "#c:redstone_ores", "#c:ruby_ores", "#c:runite_ores", "#c:salt_ores", "#c:sapphire_ores", "#c:sheldonite_ores", "#c:silver_ores", "#c:sodalite_ores", "#c:sphalerite_ores", "#c:starrite_ores", "#c:stellum_ores", "#c:stormyx_ores", "#c:sulfur_ores", "#c:tantalite_ores", "#c:tin_ores", "#c:titanium_ores", "#c:topaz_ores", "#c:truesilver_ores", "#c:tungsten_ores", "#c:unobtainium_ores", "#c:ur_ores", "#c:uranium_ores", "#c:vermiculite_ores", "#c:zinc_ores");
    }
}

