/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.networking.v1;

import java.util.Objects;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.impl.networking.client.ClientNetworkingImpl;
import net.fabricmc.fabric.impl.networking.client.ClientPlayNetworkAddon;
import net.fabricmc.fabric.impl.networking.payload.ResolvablePayload;
import net.fabricmc.fabric.impl.networking.payload.TypedPayload;
import net.fabricmc.fabric.impl.networking.payload.UntypedPayload;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_746;
import net.minecraft.class_8706;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ClientPlayNetworking {
    public static boolean registerGlobalReceiver(class_2960 channelName, PlayChannelHandler channelHandler) {
        return ClientNetworkingImpl.PLAY.registerGlobalReceiver(channelName, ClientPlayNetworking.wrapUntyped(channelHandler));
    }

    public static <T extends FabricPacket> boolean registerGlobalReceiver(PacketType<T> type, PlayPacketHandler<T> handler) {
        return ClientNetworkingImpl.PLAY.registerGlobalReceiver(type.getId(), ClientPlayNetworking.wrapTyped(type, handler));
    }

    @Nullable
    public static PlayChannelHandler unregisterGlobalReceiver(class_2960 channelName) {
        return ClientPlayNetworking.unwrapUntyped(ClientNetworkingImpl.PLAY.unregisterGlobalReceiver(channelName));
    }

    @Nullable
    public static <T extends FabricPacket> PlayPacketHandler<T> unregisterGlobalReceiver(PacketType<T> type) {
        return ClientPlayNetworking.unwrapTyped(ClientNetworkingImpl.PLAY.unregisterGlobalReceiver(type.getId()));
    }

    public static Set<class_2960> getGlobalReceivers() {
        return ClientNetworkingImpl.PLAY.getChannels();
    }

    public static boolean registerReceiver(class_2960 channelName, PlayChannelHandler channelHandler) {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return addon.registerChannel(channelName, ClientPlayNetworking.wrapUntyped(channelHandler));
        }
        throw new IllegalStateException("Cannot register receiver while not in game!");
    }

    public static <T extends FabricPacket> boolean registerReceiver(PacketType<T> type, PlayPacketHandler<T> handler) {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return addon.registerChannel(type.getId(), ClientPlayNetworking.wrapTyped(type, handler));
        }
        throw new IllegalStateException("Cannot register receiver while not in game!");
    }

    @Nullable
    public static PlayChannelHandler unregisterReceiver(class_2960 channelName) throws IllegalStateException {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return ClientPlayNetworking.unwrapUntyped((ResolvablePayload.Handler)addon.unregisterChannel(channelName));
        }
        throw new IllegalStateException("Cannot unregister receiver while not in game!");
    }

    @Nullable
    public static <T extends FabricPacket> PlayPacketHandler<T> unregisterReceiver(PacketType<T> type) {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return ClientPlayNetworking.unwrapTyped((ResolvablePayload.Handler)addon.unregisterChannel(type.getId()));
        }
        throw new IllegalStateException("Cannot unregister receiver while not in game!");
    }

    public static Set<class_2960> getReceived() throws IllegalStateException {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return addon.getReceivableChannels();
        }
        throw new IllegalStateException("Cannot get a list of channels the client can receive packets on while not in game!");
    }

    public static Set<class_2960> getSendable() throws IllegalStateException {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return addon.getSendableChannels();
        }
        throw new IllegalStateException("Cannot get a list of channels the server can receive packets on while not in game!");
    }

    public static boolean canSend(class_2960 channelName) throws IllegalArgumentException {
        if (class_310.method_1551().method_1562() != null) {
            return ClientNetworkingImpl.getAddon(class_310.method_1551().method_1562()).getSendableChannels().contains(channelName);
        }
        return false;
    }

    public static boolean canSend(PacketType<?> type) {
        return ClientPlayNetworking.canSend(type.getId());
    }

    public static class_2596<class_8706> createC2SPacket(class_2960 channelName, class_2540 buf) {
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        Objects.requireNonNull(buf, "Buf cannot be null");
        return ClientNetworkingImpl.createC2SPacket(channelName, buf);
    }

    public static <T extends FabricPacket> class_2596<class_8706> createC2SPacket(T packet) {
        return ClientNetworkingImpl.createC2SPacket(packet);
    }

    public static PacketSender getSender() throws IllegalStateException {
        if (class_310.method_1551().method_1562() != null) {
            return ClientNetworkingImpl.getAddon(class_310.method_1551().method_1562());
        }
        throw new IllegalStateException("Cannot get packet sender when not in game!");
    }

    public static void send(class_2960 channelName, class_2540 buf) throws IllegalStateException {
        if (class_310.method_1551().method_1562() != null) {
            class_310.method_1551().method_1562().method_52787(ClientPlayNetworking.createC2SPacket(channelName, buf));
            return;
        }
        throw new IllegalStateException("Cannot send packets when not in game!");
    }

    public static <T extends FabricPacket> void send(T packet) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        Objects.requireNonNull(packet.getType(), "Packet#getType cannot return null");
        if (class_310.method_1551().method_1562() != null) {
            class_310.method_1551().method_1562().method_52787(ClientPlayNetworking.createC2SPacket(packet));
            return;
        }
        throw new IllegalStateException("Cannot send packets when not in game!");
    }

    private ClientPlayNetworking() {
    }

    private static ResolvablePayload.Handler<ClientPlayNetworkAddon.Handler> wrapUntyped(PlayChannelHandler actualHandler) {
        return new ResolvablePayload.Handler<ClientPlayNetworkAddon.Handler>(null, actualHandler, (client, handler, payload, responseSender) -> actualHandler.receive(client, handler, ((UntypedPayload)payload).buffer(), responseSender));
    }

    private static <T extends FabricPacket> ResolvablePayload.Handler<ClientPlayNetworkAddon.Handler> wrapTyped(PacketType<T> type, PlayPacketHandler<T> actualHandler) {
        return new ResolvablePayload.Handler<ClientPlayNetworkAddon.Handler>(type, actualHandler, (client, handler, payload, responseSender) -> {
            FabricPacket packet = ((TypedPayload)payload).packet();
            if (client.method_18854()) {
                actualHandler.receive(packet, client.field_1724, responseSender);
            } else {
                client.execute(() -> {
                    if (handler.method_48296().method_10758()) {
                        actualHandler.receive(packet, client.field_1724, responseSender);
                    }
                });
            }
        });
    }

    @Nullable
    private static PlayChannelHandler unwrapUntyped(@Nullable ResolvablePayload.Handler<ClientPlayNetworkAddon.Handler> handler) {
        if (handler == null) {
            return null;
        }
        Object object = handler.actual();
        if (object instanceof PlayChannelHandler) {
            PlayChannelHandler actual = (PlayChannelHandler)object;
            return actual;
        }
        return null;
    }

    @Nullable
    private static <T extends FabricPacket> PlayPacketHandler<T> unwrapTyped(@Nullable ResolvablePayload.Handler<ClientPlayNetworkAddon.Handler> handler) {
        if (handler == null) {
            return null;
        }
        Object object = handler.actual();
        if (object instanceof PlayPacketHandler) {
            PlayPacketHandler actual = (PlayPacketHandler)object;
            return actual;
        }
        return null;
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface PlayChannelHandler {
        public void receive(class_310 var1, class_634 var2, class_2540 var3, PacketSender var4);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface PlayPacketHandler<T extends FabricPacket> {
        public void receive(T var1, class_746 var2, PacketSender var3);
    }
}

