/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.networking.v1;

import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.impl.networking.payload.ResolvablePayload;
import net.fabricmc.fabric.impl.networking.payload.TypedPayload;
import net.fabricmc.fabric.impl.networking.payload.UntypedPayload;
import net.fabricmc.fabric.impl.networking.server.ServerConfigurationNetworkAddon;
import net.fabricmc.fabric.impl.networking.server.ServerNetworkingImpl;
import net.fabricmc.fabric.mixin.networking.accessor.ServerCommonNetworkHandlerAccessor;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_8610;
import net.minecraft.class_8705;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public final class ServerConfigurationNetworking {
    public static boolean registerGlobalReceiver(class_2960 channelName, ConfigurationChannelHandler channelHandler) {
        return ServerNetworkingImpl.CONFIGURATION.registerGlobalReceiver(channelName, ServerConfigurationNetworking.wrapUntyped(channelHandler));
    }

    public static <T extends FabricPacket> boolean registerGlobalReceiver(PacketType<T> type, ConfigurationPacketHandler<T> handler) {
        return ServerNetworkingImpl.CONFIGURATION.registerGlobalReceiver(type.getId(), ServerConfigurationNetworking.wrapTyped(type, handler));
    }

    @Nullable
    public static ConfigurationChannelHandler unregisterGlobalReceiver(class_2960 channelName) {
        return ServerConfigurationNetworking.unwrapUntyped(ServerNetworkingImpl.CONFIGURATION.unregisterGlobalReceiver(channelName));
    }

    @Nullable
    public static <T extends FabricPacket> ConfigurationPacketHandler<T> unregisterGlobalReceiver(PacketType<T> type) {
        return ServerConfigurationNetworking.unwrapTyped(ServerNetworkingImpl.CONFIGURATION.unregisterGlobalReceiver(type.getId()));
    }

    public static Set<class_2960> getGlobalReceivers() {
        return ServerNetworkingImpl.CONFIGURATION.getChannels();
    }

    public static boolean registerReceiver(class_8610 networkHandler, class_2960 channelName, ConfigurationChannelHandler channelHandler) {
        Objects.requireNonNull(networkHandler, "Network handler cannot be null");
        return ServerNetworkingImpl.getAddon(networkHandler).registerChannel(channelName, ServerConfigurationNetworking.wrapUntyped(channelHandler));
    }

    public static <T extends FabricPacket> boolean registerReceiver(class_8610 networkHandler, PacketType<T> type, ConfigurationPacketHandler<T> handler) {
        return ServerNetworkingImpl.getAddon(networkHandler).registerChannel(type.getId(), ServerConfigurationNetworking.wrapTyped(type, handler));
    }

    @Nullable
    public static ConfigurationChannelHandler unregisterReceiver(class_8610 networkHandler, class_2960 channelName) {
        Objects.requireNonNull(networkHandler, "Network handler cannot be null");
        return ServerConfigurationNetworking.unwrapUntyped((ResolvablePayload.Handler)ServerNetworkingImpl.getAddon(networkHandler).unregisterChannel(channelName));
    }

    @Nullable
    public static <T extends FabricPacket> ConfigurationPacketHandler<T> unregisterReceiver(class_8610 networkHandler, PacketType<T> type) {
        return ServerConfigurationNetworking.unwrapTyped((ResolvablePayload.Handler)ServerNetworkingImpl.getAddon(networkHandler).unregisterChannel(type.getId()));
    }

    public static Set<class_2960> getReceived(class_8610 handler) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getReceivableChannels();
    }

    public static Set<class_2960> getSendable(class_8610 handler) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels();
    }

    public static boolean canSend(class_8610 handler, class_2960 channelName) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels().contains(channelName);
    }

    public static boolean canSend(class_8610 handler, PacketType<?> type) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        Objects.requireNonNull(type, "Packet type cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels().contains(type.getId());
    }

    public static class_2596<class_8705> createS2CPacket(class_2960 channelName, class_2540 buf) {
        Objects.requireNonNull(channelName, "Channel cannot be null");
        Objects.requireNonNull(buf, "Buf cannot be null");
        return ServerNetworkingImpl.createS2CPacket(channelName, buf);
    }

    public static <T extends FabricPacket> class_2596<class_8705> createS2CPacket(T packet) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        Objects.requireNonNull(packet.getType(), "Packet#getType cannot return null");
        return ServerNetworkingImpl.createS2CPacket(packet);
    }

    public static PacketSender getSender(class_8610 handler) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler);
    }

    public static void send(class_8610 handler, class_2960 channelName, class_2540 buf) {
        Objects.requireNonNull(handler, "Server configuration entity cannot be null");
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        Objects.requireNonNull(buf, "Packet byte buf cannot be null");
        handler.method_14364(ServerConfigurationNetworking.createS2CPacket(channelName, buf));
    }

    public static <T extends FabricPacket> void send(class_8610 handler, T packet) {
        Objects.requireNonNull(handler, "Server configuration handler cannot be null");
        Objects.requireNonNull(packet, "Packet cannot be null");
        Objects.requireNonNull(packet.getType(), "Packet#getType cannot return null");
        handler.method_14364(ServerConfigurationNetworking.createS2CPacket(packet));
    }

    public static MinecraftServer getServer(class_8610 handler) {
        Objects.requireNonNull(handler, "Network handler cannot be null");
        return ((ServerCommonNetworkHandlerAccessor)handler).getServer();
    }

    private ServerConfigurationNetworking() {
    }

    private static ResolvablePayload.Handler<ServerConfigurationNetworkAddon.Handler> wrapUntyped(ConfigurationChannelHandler actualHandler) {
        return new ResolvablePayload.Handler<ServerConfigurationNetworkAddon.Handler>(null, actualHandler, (server, handler, payload, responseSender) -> actualHandler.receive(server, handler, ((UntypedPayload)payload).buffer(), responseSender));
    }

    private static <T extends FabricPacket> ResolvablePayload.Handler<ServerConfigurationNetworkAddon.Handler> wrapTyped(PacketType<T> type, ConfigurationPacketHandler<T> actualHandler) {
        return new ResolvablePayload.Handler<ServerConfigurationNetworkAddon.Handler>(type, actualHandler, (server, handler, payload, responseSender) -> {
            FabricPacket packet = ((TypedPayload)payload).packet();
            actualHandler.receive(packet, handler, responseSender);
        });
    }

    @Nullable
    private static ConfigurationChannelHandler unwrapUntyped(@Nullable ResolvablePayload.Handler<ServerConfigurationNetworkAddon.Handler> handler) {
        if (handler == null) {
            return null;
        }
        Object object = handler.actual();
        if (object instanceof ConfigurationChannelHandler) {
            ConfigurationChannelHandler actual = (ConfigurationChannelHandler)object;
            return actual;
        }
        return null;
    }

    @Nullable
    private static <T extends FabricPacket> ConfigurationPacketHandler<T> unwrapTyped(@Nullable ResolvablePayload.Handler<ServerConfigurationNetworkAddon.Handler> handler) {
        if (handler == null) {
            return null;
        }
        Object object = handler.actual();
        if (object instanceof ConfigurationPacketHandler) {
            ConfigurationPacketHandler actual = (ConfigurationPacketHandler)object;
            return actual;
        }
        return null;
    }

    @FunctionalInterface
    public static interface ConfigurationChannelHandler {
        public void receive(MinecraftServer var1, class_8610 var2, class_2540 var3, PacketSender var4);
    }

    @FunctionalInterface
    public static interface ConfigurationPacketHandler<T extends FabricPacket> {
        public void receive(T var1, class_8610 var2, PacketSender var3);
    }
}

