/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking.client;

import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.C2SConfigurationChannelEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.impl.networking.AbstractChanneledNetworkAddon;
import net.fabricmc.fabric.impl.networking.ChannelInfoHolder;
import net.fabricmc.fabric.impl.networking.NetworkingImpl;
import net.fabricmc.fabric.impl.networking.client.ClientNetworkingImpl;
import net.fabricmc.fabric.impl.networking.payload.ResolvablePayload;
import net.fabricmc.fabric.impl.networking.payload.ResolvedPayload;
import net.fabricmc.fabric.mixin.networking.client.accessor.ClientCommonNetworkHandlerAccessor;
import net.fabricmc.fabric.mixin.networking.client.accessor.ClientConfigurationNetworkHandlerAccessor;
import net.minecraft.class_2539;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8674;

@Environment(value=EnvType.CLIENT)
public final class ClientConfigurationNetworkAddon
extends AbstractChanneledNetworkAddon<Handler> {
    private final class_8674 handler;
    private final class_310 client;
    private boolean sentInitialRegisterPacket;

    public ClientConfigurationNetworkAddon(class_8674 handler, class_310 client) {
        super(ClientNetworkingImpl.CONFIGURATION, ((ClientCommonNetworkHandlerAccessor)handler).getConnection(), "ClientPlayNetworkAddon for " + ((ClientConfigurationNetworkHandlerAccessor)handler).getProfile().getName());
        this.handler = handler;
        this.client = client;
        this.registerPendingChannels((ChannelInfoHolder)this.connection, class_2539.field_45671);
    }

    @Override
    protected void invokeInitEvent() {
        ((ClientConfigurationConnectionEvents.Init)ClientConfigurationConnectionEvents.INIT.invoker()).onConfigurationInit(this.handler, this.client);
    }

    public void onServerReady() {
    }

    @Override
    protected void receiveRegistration(boolean register, ResolvablePayload resolvable) {
        super.receiveRegistration(register, resolvable);
        if (register && !this.sentInitialRegisterPacket) {
            this.sendInitialChannelRegistrationPacket();
            this.sentInitialRegisterPacket = true;
        }
    }

    @Override
    protected void receive(Handler handler, ResolvedPayload payload) {
        handler.receive(this.client, this.handler, payload, this);
    }

    @Override
    protected void schedule(Runnable task) {
        class_310.method_1551().execute(task);
    }

    @Override
    public class_2596<?> createPacket(class_2960 channelName, class_2540 buf) {
        return ClientPlayNetworking.createC2SPacket(channelName, buf);
    }

    @Override
    public class_2596<?> createPacket(FabricPacket packet) {
        return ClientPlayNetworking.createC2SPacket(packet);
    }

    @Override
    protected void invokeRegisterEvent(List<class_2960> ids) {
        ((C2SConfigurationChannelEvents.Register)C2SConfigurationChannelEvents.REGISTER.invoker()).onChannelRegister(this.handler, this, this.client, ids);
    }

    @Override
    protected void invokeUnregisterEvent(List<class_2960> ids) {
        ((C2SConfigurationChannelEvents.Unregister)C2SConfigurationChannelEvents.UNREGISTER.invoker()).onChannelUnregister(this.handler, this, this.client, ids);
    }

    @Override
    protected void handleRegistration(class_2960 channelName) {
        class_2540 buf;
        if (this.sentInitialRegisterPacket && (buf = this.createRegistrationPacket(Collections.singleton(channelName))) != null) {
            this.sendPacket(NetworkingImpl.REGISTER_CHANNEL, buf);
        }
    }

    @Override
    protected void handleUnregistration(class_2960 channelName) {
        class_2540 buf;
        if (this.sentInitialRegisterPacket && (buf = this.createRegistrationPacket(Collections.singleton(channelName))) != null) {
            this.sendPacket(NetworkingImpl.UNREGISTER_CHANNEL, buf);
        }
    }

    public void handleReady() {
        ((ClientConfigurationConnectionEvents.Ready)ClientConfigurationConnectionEvents.READY.invoker()).onConfigurationReady(this.handler, this.client);
        ClientNetworkingImpl.setClientConfigurationAddon(null);
    }

    @Override
    protected void invokeDisconnectEvent() {
        ((ClientConfigurationConnectionEvents.Disconnect)ClientConfigurationConnectionEvents.DISCONNECT.invoker()).onConfigurationDisconnect(this.handler, this.client);
    }

    @Override
    protected boolean isReservedChannel(class_2960 channelName) {
        return NetworkingImpl.isReservedCommonChannel(channelName);
    }

    public ChannelInfoHolder getChannelInfoHolder() {
        return (ChannelInfoHolder)((ClientCommonNetworkHandlerAccessor)this.handler).getConnection();
    }

    @Environment(value=EnvType.CLIENT)
    public static interface Handler {
        public void receive(class_310 var1, class_8674 var2, ResolvedPayload var3, PacketSender var4);
    }
}

