/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.easy_item_list.api;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.justahuman.easy_item_list.EasyItemList;
import me.justahuman.easy_item_list.mixin.TransformRecipeAccessor;
import me.justahuman.easy_item_list.mixin.TrimRecipeAccessor;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_7923;

public abstract class Hook {
    public static final class_5455 MANAGER = class_5455.method_40302((class_2378)class_7923.field_41167);
    protected static final List<class_1799> ITEM_STACKS = new ArrayList<class_1799>();
    protected static final Map<class_1799, String> NAMESPACES = new HashMap<class_1799, String>();

    public abstract boolean alreadyAdded(class_1799 var1);

    public abstract void addItemStacks();

    public void load() {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null || world.method_8433() == null) {
            return;
        }
        world.method_8433().method_8126().forEach(entry -> {
            if (entry.comp_1932().method_12836().equals("minecraft") || !(entry.comp_1933() instanceof class_1860)) {
                return;
            }
            class_1860 recipe = entry.comp_1933();
            String namespace = entry.comp_1932().method_12836();
            if (recipe instanceof TransformRecipeAccessor) {
                TransformRecipeAccessor transformRecipe = (TransformRecipeAccessor)recipe;
                this.handleIngredients(namespace, transformRecipe.getBase(), transformRecipe.getTemplate(), transformRecipe.getAddition());
                this.handleItem(transformRecipe.getResult().method_46651(1), namespace);
                return;
            }
            if (recipe instanceof TrimRecipeAccessor) {
                TrimRecipeAccessor trimRecipe = (TrimRecipeAccessor)recipe;
                this.handleIngredients(namespace, trimRecipe.getBase(), trimRecipe.getTemplate(), trimRecipe.getAddition());
            } else {
                this.handleIngredients(namespace, (class_1856[])recipe.method_8117().toArray(class_1856[]::new));
            }
            try {
                this.handleItem(recipe.method_8110(MANAGER).method_46651(1), namespace);
            }
            catch (Exception e) {
                EasyItemList.LOGGER.error("Unexpected error getting the output of recipe " + String.valueOf(entry.comp_1932()), (Throwable)e);
            }
        });
        if (!ITEM_STACKS.isEmpty()) {
            ITEM_STACKS.sort(Comparator.comparing(stack -> stack.method_7964().getString()));
            ITEM_STACKS.sort(Comparator.comparing(NAMESPACES::get));
            this.addItemStacks();
        }
    }

    public void handleIngredients(String namespace, class_1856 ... ingredients) {
        for (class_1856 ingredient : ingredients) {
            for (class_1799 itemStack : ingredient.method_8105()) {
                this.handleItem(itemStack.method_46651(1), namespace);
            }
        }
    }

    public void handleItem(class_1799 itemStack, String namespace) {
        if (itemStack == null || !this.isCustom(itemStack) || this.alreadyAdded(itemStack)) {
            return;
        }
        ITEM_STACKS.add(itemStack);
        NAMESPACES.put(itemStack, namespace);
    }

    public boolean isCustom(class_1799 itemStack) {
        class_2487 defaultNbt;
        class_2487 nbt = Hook.removeUseless(itemStack);
        return !Objects.equals(nbt, defaultNbt = Hook.removeUseless(itemStack.method_7909().method_7854()));
    }

    private static class_2487 removeUseless(class_1799 itemStack) {
        class_2487 display;
        class_2487 nbt = itemStack.method_7969();
        if (nbt == null || nbt.method_33133()) {
            return new class_2487();
        }
        nbt = nbt.method_10553();
        nbt.method_10551("Damage");
        nbt.method_10551("Enchantments");
        nbt.method_10551("Patterns");
        nbt.method_10551("Trim");
        nbt.method_10551("StoredEnchantments");
        nbt.method_10551("EntityTag");
        nbt.method_10551("Fireworks");
        nbt.method_10551("pages");
        nbt.method_10551("author");
        nbt.method_10551("generation");
        nbt.method_10551("title");
        class_2487 class_24872 = display = nbt.method_10573("display", 10) ? nbt.method_10562("display") : null;
        if (display != null) {
            display.method_10551("color");
        }
        return nbt;
    }
}

