/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra;

import com.teamresourceful.resourcefulconfig.api.loader.Configurator;
import com.teamresourceful.resourcefullib.common.network.Packet;
import earth.terrarium.adastra.api.systems.GravityApi;
import earth.terrarium.adastra.api.systems.OxygenApi;
import earth.terrarium.adastra.api.systems.PlanetData;
import earth.terrarium.adastra.api.systems.TemperatureApi;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.network.NetworkHandler;
import earth.terrarium.adastra.common.network.messages.ClientboundSyncLocalPlanetDataPacket;
import earth.terrarium.adastra.common.network.messages.ClientboundSyncPlanetsPacket;
import earth.terrarium.adastra.common.planets.AdAstraData;
import earth.terrarium.adastra.common.registry.ModBiomeSources;
import earth.terrarium.adastra.common.registry.ModBlockEntityTypes;
import earth.terrarium.adastra.common.registry.ModBlocks;
import earth.terrarium.adastra.common.registry.ModCreativeTab;
import earth.terrarium.adastra.common.registry.ModDensityFunctionTypes;
import earth.terrarium.adastra.common.registry.ModEntityTypes;
import earth.terrarium.adastra.common.registry.ModFeatures;
import earth.terrarium.adastra.common.registry.ModFluidProperties;
import earth.terrarium.adastra.common.registry.ModFluids;
import earth.terrarium.adastra.common.registry.ModItems;
import earth.terrarium.adastra.common.registry.ModMenus;
import earth.terrarium.adastra.common.registry.ModPaintingVariants;
import earth.terrarium.adastra.common.registry.ModParticleTypes;
import earth.terrarium.adastra.common.registry.ModRecipeSerializers;
import earth.terrarium.adastra.common.registry.ModRecipeTypes;
import earth.terrarium.adastra.common.registry.ModSoundEvents;
import earth.terrarium.adastra.common.registry.ModStructures;
import earth.terrarium.adastra.common.registry.ModWorldCarvers;
import earth.terrarium.adastra.common.utils.radio.StationLoader;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3302;
import net.minecraft.class_5455;
import net.minecraft.class_5620;
import net.minecraft.server.MinecraftServer;

public class AdAstra {
    public static final String MOD_ID = "ad_astra";
    public static final Configurator CONFIGURATOR = new Configurator("ad_astra");
    private static Supplier<class_5455> registryAccessSupplier;

    public static void init() {
        CONFIGURATOR.register(AdAstraConfig.class);
        NetworkHandler.init();
        StationLoader.init();
        ModFluidProperties.FLUID_PROPERTIES.initialize();
        ModFluids.FLUIDS.init();
        ModBlocks.BLOCKS.init();
        ModItems.ITEMS.init();
        ModCreativeTab.init();
        ModEntityTypes.ENTITY_TYPES.init();
        ModBlockEntityTypes.BLOCK_ENTITY_TYPES.init();
        ModMenus.MENUS.init();
        ModRecipeTypes.RECIPE_TYPES.init();
        ModRecipeSerializers.RECIPE_SERIALIZERS.init();
        ModParticleTypes.PARTICLE_TYPES.init();
        ModPaintingVariants.PAINTING_VARIANTS.init();
        ModSoundEvents.SOUND_EVENTS.init();
        ModStructures.STRUCTURE_TYPES.init();
        ModStructures.STRUCTURE_PROCESSORS.init();
        ModFeatures.FEATURES.init();
        ModWorldCarvers.WORLD_CARVERS.init();
        ModBiomeSources.BIOME_SOURCES.init();
        ModDensityFunctionTypes.DENSITY_FUNCTION_TYPES.init();
    }

    public static void postInit() {
        Map map = class_5620.field_27776.comp_1982();
        map.put((class_1792)ModItems.SPACE_HELMET.get(), class_5620.field_27782);
        map.put((class_1792)ModItems.SPACE_SUIT.get(), class_5620.field_27782);
        map.put((class_1792)ModItems.SPACE_PANTS.get(), class_5620.field_27782);
        map.put((class_1792)ModItems.SPACE_BOOTS.get(), class_5620.field_27782);
        ModEntityTypes.registerSpawnPlacements();
    }

    public static void onAddReloadListener(BiConsumer<class_2960, class_3302> registry) {
        registry.accept(new class_2960(MOD_ID, "planets"), (class_3302)new AdAstraData());
    }

    public static void onDatapackSync(class_3222 player) {
        NetworkHandler.CHANNEL.sendToPlayer((Packet)new ClientboundSyncPlanetsPacket(AdAstraData.planets()), player);
    }

    public static void onServerTick(MinecraftServer server) {
        server.method_3760().method_14571().forEach(player -> {
            if (player.field_6012 % 5 == 0) {
                boolean oxygen = OxygenApi.API.hasOxygen((class_1297)player);
                short temperature = TemperatureApi.API.getTemperature((class_1297)player);
                float gravity = GravityApi.API.getGravity((class_1297)player);
                NetworkHandler.CHANNEL.sendToPlayer((Packet)new ClientboundSyncLocalPlanetDataPacket(new PlanetData(oxygen, temperature, gravity)), player);
            }
        });
    }

    public static void onServerStarted(MinecraftServer server) {
        AdAstra.setRegistryAccess(() -> ((MinecraftServer)server).method_30611());
    }

    public static void setRegistryAccess(Supplier<class_5455> supplier) {
        registryAccessSupplier = supplier;
    }

    public static class_5455 getRegistryAccess() {
        return registryAccessSupplier.get();
    }
}

