/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.components.machines;

import com.mojang.blaze3d.systems.RenderSystem;
import com.teamresourceful.resourcefullib.client.components.CursorWidget;
import com.teamresourceful.resourcefullib.client.scissor.ClosingScissorBox;
import com.teamresourceful.resourcefullib.client.screens.CursorScreen;
import com.teamresourceful.resourcefullib.client.utils.RenderUtils;
import com.teamresourceful.resourcefullib.common.network.Packet;
import earth.terrarium.adastra.client.components.base.TickableWidget;
import earth.terrarium.adastra.client.components.machines.ConfigurationWidget;
import earth.terrarium.adastra.client.screens.base.ConfigurationScreen;
import earth.terrarium.adastra.client.utils.GuiUtils;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.menus.configuration.FluidConfiguration;
import earth.terrarium.adastra.common.network.NetworkHandler;
import earth.terrarium.adastra.common.network.messages.ServerboundClearFluidTankPacket;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.utils.ClientFluidHooks;
import net.minecraft.class_1058;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5253;
import net.minecraft.class_7919;

public class FluidBarWidget
extends ConfigurationWidget
implements CursorWidget,
TickableWidget {
    protected final class_2338 tankPos;
    protected final int tank;
    protected final FluidContainer container;
    protected long lastFluidAmount;
    protected long difference;

    public FluidBarWidget(class_2338 tankPos, FluidConfiguration configuration) {
        super(configuration, 12, 46);
        this.tankPos = tankPos;
        this.tank = configuration.tank();
        this.container = configuration.container();
    }

    @Override
    public void tick() {
        FluidHolder holder = (FluidHolder)this.container.getFluids().get(this.tank);
        this.difference = holder.getFluidAmount() - this.lastFluidAmount;
        this.lastFluidAmount = holder.getFluidAmount();
    }

    @Override
    protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_48579(graphics, mouseX, mouseY, partialTick);
        FluidHolder holder = (FluidHolder)this.container.getFluids().get(this.tank);
        long capacity = this.container.getTankCapacity(this.tank);
        long amount = holder.getFluidAmount();
        float ratio = (float)amount / (float)capacity;
        int x = this.method_46426();
        int y = this.method_46427();
        if (!holder.isEmpty()) {
            class_1058 sprite = ClientFluidHooks.getFluidSprite((FluidHolder)holder);
            int color = ClientFluidHooks.getFluidColor((FluidHolder)holder);
            float r = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
            float g = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
            float b = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
            try (ClosingScissorBox ignored = RenderUtils.createScissorBox((class_310)class_310.method_1551(), (class_4587)graphics.method_51448(), (int)x, (int)(y + 46 - (int)(46.0f * ratio)), (int)12, (int)46);){
                for (int i = 1; i < 5; ++i) {
                    graphics.method_48465(x, y + 46 - i * 16, 0, 16, 16, sprite, r, g, b, 1.0f);
                }
            }
        }
        RenderSystem.enableBlend();
        graphics.method_52706(GuiUtils.FLUID_BAR, x, y, 12, 46);
        RenderSystem.disableBlend();
        if (this.method_25367()) {
            if (holder.isEmpty()) {
                this.method_47400(class_7919.method_47407((class_2561)class_5244.method_37110((class_2561[])new class_2561[]{TooltipUtils.getFluidComponent(holder, capacity), TooltipUtils.getFluidDifferenceComponent(this.difference)})));
            } else {
                this.method_47400(class_7919.method_47407((class_2561)class_5244.method_37110((class_2561[])new class_2561[]{TooltipUtils.getFluidComponent(holder, capacity), TooltipUtils.getFluidDifferenceComponent(this.difference), ConstantComponents.CLEAR_FLUID_TANK})));
            }
            this.method_47402(-1);
        }
    }

    @Override
    protected boolean method_25351(int button) {
        return super.method_25351(button) || button == 1 && class_437.method_25442();
    }

    @Override
    public void method_25348(double mouseX, double mouseY) {
        if (ConfigurationScreen.isConfigurable()) {
            super.method_25348(mouseX, mouseY);
        } else {
            NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundClearFluidTankPacket(this.tankPos, this.tank));
        }
    }

    public CursorScreen.Cursor getCursor() {
        return class_437.method_25442() ? CursorScreen.Cursor.POINTER : CursorScreen.Cursor.DEFAULT;
    }
}

