/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.machines;

import earth.terrarium.adastra.common.blockentities.base.ContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.RedstoneControl;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.menus.machines.NasaWorkbenchMenu;
import earth.terrarium.adastra.common.recipes.machines.NasaWorkbenchRecipe;
import earth.terrarium.adastra.common.registry.ModRecipeTypes;
import earth.terrarium.adastra.common.utils.ModUtils;
import earth.terrarium.adastra.common.utils.TransferUtils;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3956;
import net.minecraft.class_8144;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NasaWorkbenchBlockEntity
extends ContainerMachineBlockEntity {
    public static final List<ConfigurationEntry> SIDE_CONFIG = List.of(new ConfigurationEntry(ConfigurationType.SLOT, Configuration.NONE, ConstantComponents.SIDE_CONFIG_INPUT_SLOTS));
    private static final int[] INPUT_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
    protected final class_1863.class_7266<class_1263, NasaWorkbenchRecipe> quickCheck = class_1863.method_42302((class_3956)((class_3956)ModRecipeTypes.NASA_WORKBENCH.get()));
    @Nullable
    protected NasaWorkbenchRecipe recipe;

    public NasaWorkbenchBlockEntity(class_2338 pos, class_2680 state) {
        super(pos, state, 15);
        this.setRedstoneControl(RedstoneControl.NEVER_ON);
    }

    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return new NasaWorkbenchMenu(id, inventory, this);
    }

    @Override
    public void serverTick(class_3218 level, long time, class_2680 state, class_2338 pos) {
        for (int i = 0; i < 14; ++i) {
            if (this.method_5438(i).method_7960()) continue;
            this.spawnWorkingParticles(level, pos);
            break;
        }
        if (this.recipe != null && this.canCraft()) {
            this.method_5447(14, this.recipe.result());
        } else {
            this.method_5447(14, class_1799.field_8037);
        }
        if (time % 30L == 0L && this.canFunction() && this.canCraft()) {
            this.craft();
        }
    }

    @Override
    public void tickSideInteractions(class_2338 pos, Predicate<class_2350> filter, List<ConfigurationEntry> sideConfig) {
        TransferUtils.pushItemsNearby(this, pos, INPUT_SLOTS, sideConfig.get(0), filter);
        TransferUtils.pullItemsNearby(this, pos, INPUT_SLOTS, sideConfig.get(0), filter);
    }

    @Override
    public void update() {
        if (this.level().method_8608()) {
            return;
        }
        this.recipe = (NasaWorkbenchRecipe)class_8144.method_49077((Object)this.quickCheck.method_42303((class_1263)this, this.level()).orElse(null), class_8786::comp_1933);
    }

    public boolean canCraft() {
        return this.recipe != null && this.recipe.method_8115(this, this.level());
    }

    public void craft() {
        if (this.recipe == null) {
            return;
        }
        this.spawnResultParticles();
        class_1264.method_5449((class_1937)this.level(), (double)this.method_11016().method_10263(), (double)(this.method_11016().method_10264() + 1), (double)this.method_11016().method_10260(), (class_1799)this.method_5438(14).method_7972());
        this.method_5447(14, class_1799.field_8037);
        for (int i = 0; i < 14; ++i) {
            this.method_5438(i).method_7934(1);
        }
        this.recipe = null;
    }

    public void spawnWorkingParticles(class_3218 level, class_2338 pos) {
        ModUtils.sendParticles(level, class_2398.field_29644, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.5, (double)pos.method_10260() + 0.5, 3, 0.12, 0.12, 0.12, 0.15);
    }

    public void spawnResultParticles() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_2338 pos = this.method_11016();
            ModUtils.sendParticles(serverLevel, class_2398.field_11220, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.5, (double)pos.method_10260() + 0.5, 100, 0.1, 0.1, 0.1, 0.7);
            serverLevel.method_8396(null, pos, class_3417.field_14931, class_3419.field_15254, 1.0f, 1.0f);
        }
    }

    @Override
    public List<ConfigurationEntry> getDefaultConfig() {
        return SIDE_CONFIG;
    }

    public int @NotNull [] method_5494(@NotNull class_2350 side) {
        return INPUT_SLOTS;
    }
}

