/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.menus;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import com.teamresourceful.resourcefullib.common.network.Packet;
import earth.terrarium.adastra.api.planets.Planet;
import earth.terrarium.adastra.common.compat.argonauts.ArgonautsIntegration;
import earth.terrarium.adastra.common.entities.vehicles.Rocket;
import earth.terrarium.adastra.common.handlers.base.SpaceStation;
import earth.terrarium.adastra.common.menus.base.PlanetsMenuProvider;
import earth.terrarium.adastra.common.network.NetworkHandler;
import earth.terrarium.adastra.common.network.messages.ServerboundConstructSpaceStationPacket;
import earth.terrarium.adastra.common.planets.AdAstraData;
import earth.terrarium.adastra.common.recipes.SpaceStationRecipe;
import earth.terrarium.adastra.common.recipes.base.IngredientHolder;
import earth.terrarium.adastra.common.registry.ModMenus;
import earth.terrarium.adastra.common.registry.ModRecipeTypes;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_8786;

public class PlanetsMenu
extends class_1703 {
    protected final int tier;
    protected final class_1661 inventory;
    protected final class_1657 player;
    protected final class_1937 level;
    protected final Set<class_2960> disabledPlanets;
    protected final Map<class_5321<class_1937>, Map<UUID, Set<SpaceStation>>> spaceStations;
    protected final Map<class_5321<class_1937>, List<Pair<class_1799, Integer>>> ingredients;
    protected final Object2BooleanMap<class_5321<class_1937>> claimedChunks = new Object2BooleanOpenHashMap();
    protected final Set<class_4208> spawnLocations;

    public PlanetsMenu(int containerId, class_1661 inventory, class_2540 buf) {
        this(containerId, inventory, PlanetsMenuProvider.createDisabledPlanetsFromBuf(buf), PlanetsMenuProvider.createSpaceStationsFromBuf(buf), PlanetsMenuProvider.createClaimedChunksFromBuf(buf), PlanetsMenuProvider.createSpawnLocationsFromBuf(buf));
    }

    public PlanetsMenu(int containerId, class_1661 inventory, Set<class_2960> disabledPlanets, Map<class_5321<class_1937>, Map<UUID, Set<SpaceStation>>> spaceStations, Object2BooleanMap<class_5321<class_1937>> claimedChunks, Set<class_4208> spawnLocations) {
        super((class_3917)ModMenus.PLANETS.get(), containerId);
        int n;
        this.inventory = inventory;
        this.player = inventory.field_7546;
        this.level = this.player.method_37908();
        class_1297 class_12972 = this.player.method_5854();
        if (class_12972 instanceof Rocket) {
            Rocket vehicle = (Rocket)class_12972;
            n = vehicle.tier();
        } else {
            n = 100;
        }
        this.tier = n;
        this.disabledPlanets = disabledPlanets;
        this.spaceStations = spaceStations;
        this.ingredients = this.getSpaceStationRecipes();
        this.spawnLocations = spawnLocations;
        this.claimedChunks.putAll(claimedChunks);
    }

    public class_1799 method_7601(class_1657 player, int index) {
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public int tier() {
        return this.tier;
    }

    public class_1657 player() {
        return this.player;
    }

    public Set<class_2960> disabledPlanets() {
        return this.disabledPlanets;
    }

    public Map<class_5321<class_1937>, List<Pair<class_1799, Integer>>> ingredients() {
        return this.ingredients;
    }

    public boolean isClaimed(class_5321<class_1937> dimension) {
        return this.claimedChunks.getBoolean(dimension);
    }

    public boolean canConstruct(class_5321<class_1937> dimension) {
        if (this.isClaimed(dimension)) {
            return false;
        }
        class_8786 recipe = SpaceStationRecipe.getSpaceStation(this.level, dimension).orElse(null);
        if (recipe == null) {
            return false;
        }
        return SpaceStationRecipe.hasIngredients(this.player, this.level, (SpaceStationRecipe)recipe.comp_1933());
    }

    private Map<class_5321<class_1937>, List<Pair<class_1799, Integer>>> getSpaceStationRecipes() {
        List<SpaceStationRecipe> spaceStationRecipes = this.level.method_8433().method_30027((class_3956)ModRecipeTypes.SPACE_STATION_RECIPE.get()).stream().map(class_8786::comp_1933).toList();
        HashMap<class_5321<class_1937>, List<Pair<class_1799, Integer>>> recipes = new HashMap<class_5321<class_1937>, List<Pair<class_1799, Integer>>>(spaceStationRecipes.size());
        for (SpaceStationRecipe recipe : spaceStationRecipes) {
            for (IngredientHolder holder : recipe.ingredients()) {
                int count = 0;
                for (int i = 0; i < this.inventory.method_5439(); ++i) {
                    class_1799 stack = this.inventory.method_5438(i);
                    if (!holder.ingredient().method_8093(stack)) continue;
                    count += stack.method_7947();
                }
                recipes.computeIfAbsent(recipe.dimension(), k -> new ArrayList()).add(new Pair((Object)holder.ingredient().method_8105()[0].method_46651(holder.count()), (Object)count));
            }
        }
        return recipes;
    }

    public boolean isInSpaceStation(class_5321<class_1937> dimension) {
        class_1923 pos = this.player.method_31476();
        Map<UUID, Set<SpaceStation>> allStations = this.spaceStations.get(dimension);
        if (allStations == null) {
            return false;
        }
        for (Set<SpaceStation> stations : allStations.values()) {
            for (SpaceStation station : stations) {
                if (station.position().method_24022(pos) > 2) continue;
                return true;
            }
        }
        return false;
    }

    public List<Pair<String, SpaceStation>> getOwnedSpaceStations(class_5321<class_1937> dimension, GameProfile player) {
        Map<UUID, Set<SpaceStation>> allStations = this.spaceStations.get(dimension);
        if (allStations == null) {
            return List.of();
        }
        Set<SpaceStation> stations = allStations.get(player.getId());
        if (stations == null) {
            return List.of();
        }
        return stations.stream().sorted(Comparator.comparing(station -> station.name().getString())).map(station -> new Pair((Object)player.getName(), station)).toList();
    }

    public List<Pair<String, SpaceStation>> getOwnedAndTeamSpaceStations(class_5321<class_1937> dimension) {
        ArrayList<Pair<String, SpaceStation>> stations = new ArrayList<Pair<String, SpaceStation>>(this.getOwnedSpaceStations(dimension, this.player.method_7334()));
        if (!ArgonautsIntegration.argonautsLoaded()) {
            return stations;
        }
        for (GameProfile member : ArgonautsIntegration.getClientPartyMembers(this.player.method_5667())) {
            if (member.equals((Object)this.player.method_7334())) continue;
            stations.addAll(this.getOwnedSpaceStations(dimension, member));
        }
        for (GameProfile member : ArgonautsIntegration.getClientGuildMembers(this.player.method_5667())) {
            if (member.equals((Object)this.player.method_7334())) continue;
            stations.addAll(this.getOwnedSpaceStations(dimension, member));
        }
        return stations;
    }

    public void constructSpaceStation(class_5321<class_1937> dimension, class_2561 name) {
        NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundConstructSpaceStationPacket(dimension, name));
    }

    public class_2338 getLandingPos(class_5321<class_1937> dimension, boolean tryPreviousLocation) {
        boolean landingNormally;
        boolean bl = landingNormally = tryPreviousLocation && this.player.method_5854() instanceof Rocket;
        if (!landingNormally) {
            this.player.method_24515();
        }
        for (class_4208 pos : this.spawnLocations) {
            if (!pos.method_19442().equals(dimension)) continue;
            return pos.method_19446();
        }
        return this.player.method_24515();
    }

    public class_2561 getPlanetName(class_5321<class_1937> dimension) {
        return class_2561.method_43471((String)"planet.%s.%s".formatted(dimension.method_29177().method_12836(), dimension.method_29177().method_12832()));
    }

    public List<Planet> getSortedPlanets() {
        return AdAstraData.planets().values().stream().filter(planet -> !this.disabledPlanets().contains(planet.dimension().method_29177())).filter(planet -> this.tier() >= planet.tier()).sorted(Comparator.comparingInt(Planet::tier).thenComparing(p -> this.getPlanetName(p.dimension()).getString())).toList();
    }
}

