/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.utils;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.teamresourceful.bytecodecs.base.ByteCodec;
import com.teamresourceful.bytecodecs.utils.ByteBufUtils;
import com.teamresourceful.resourcefullib.common.codecs.yabn.YabnOps;
import com.teamresourceful.yabn.YabnParser;
import com.teamresourceful.yabn.reader.ArrayByteReader;
import com.teamresourceful.yabn.reader.ByteReader;
import earth.terrarium.adastra.AdAstra;
import earth.terrarium.adastra.api.planets.Planet;
import earth.terrarium.adastra.common.blockentities.base.ContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blocks.base.MachineBlock;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.container.VehicleContainer;
import earth.terrarium.adastra.common.entities.vehicles.Lander;
import earth.terrarium.adastra.common.entities.vehicles.Rocket;
import earth.terrarium.adastra.common.menus.PlanetsMenu;
import earth.terrarium.adastra.common.menus.base.BaseContainerMenu;
import earth.terrarium.adastra.common.registry.ModEntityTypes;
import earth.terrarium.adastra.common.utils.PlatformUtils;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5454;
import net.minecraft.class_6903;
import net.minecraft.class_7225;

public final class ModUtils {
    public static <T extends class_2394> void sendParticles(class_3218 level, T particle, double x, double y, double z, int count, double deltaX, double deltaY, double deltaZ, double speed) {
        for (class_3222 player : level.method_18456()) {
            level.method_14166(player, particle, true, x, y, z, count, deltaX, deltaY, deltaZ, speed);
        }
    }

    public static Optional<ContainerMachineBlockEntity> getMachineFromMenuPacket(class_2338 pos, class_1657 player, class_1937 level) {
        if (!(player.field_7512 instanceof BaseContainerMenu)) {
            return Optional.empty();
        }
        if (player.method_5707(pos.method_46558()) > 64.0) {
            return Optional.empty();
        }
        class_2586 blockEntity = level.method_8321(pos);
        if (!(blockEntity instanceof ContainerMachineBlockEntity)) {
            return Optional.empty();
        }
        ContainerMachineBlockEntity container = (ContainerMachineBlockEntity)blockEntity;
        return Optional.of(container);
    }

    public static boolean canTeleportToPlanet(class_1657 player, Planet targetPlanet) {
        String[] planets;
        if (!(player.field_7512 instanceof PlanetsMenu)) {
            return false;
        }
        if (player.method_7337() || player.method_7325() || player.method_5687(2)) {
            return true;
        }
        for (String planet : planets = AdAstraConfig.disabledPlanets.split(",")) {
            if (!planet.equals(targetPlanet.dimension().method_29177().toString())) continue;
            return false;
        }
        class_1297 class_12972 = player.method_5854();
        if (!(class_12972 instanceof Rocket)) {
            return false;
        }
        Rocket rocket = (Rocket)class_12972;
        if (rocket.method_23318() < (double)AdAstraConfig.atmosphereLeave) {
            return false;
        }
        return rocket.tier() >= targetPlanet.tier();
    }

    public static <T extends Enum<T>> Codec<T> createEnumCodec(Class<T> enumClass) {
        return Codec.STRING.xmap(s -> Enum.valueOf(enumClass, s.toUpperCase(Locale.ROOT)), Enum::name);
    }

    public static class_2350 relative(class_2586 from, class_2350 to) {
        return ModUtils.relative((class_2350)from.method_11010().method_11654((class_2769)MachineBlock.FACING), to);
    }

    public static class_2350 relative(class_2350 from, class_2350 to) {
        if (to.method_10166().method_10178()) {
            return to;
        }
        return switch (from) {
            case class_2350.field_11034 -> to.method_10170();
            case class_2350.field_11035 -> to.method_10153();
            case class_2350.field_11039 -> to.method_10160();
            default -> to;
        };
    }

    public static class_1297 teleportToDimension(class_1297 entity, class_3218 level) {
        class_5454 target = new class_5454(entity.method_19538(), entity.method_18798(), entity.method_36454(), entity.method_36455());
        return PlatformUtils.teleportToDimension(entity, level, target);
    }

    public static void land(class_3222 player, class_3218 targetLevel, class_243 pos) {
        class_1297 vehicle = player.method_5854();
        player.method_5848();
        player.method_29495(pos);
        class_1297 teleportedPlayer = ModUtils.teleportToDimension((class_1297)player, targetLevel);
        if (!(vehicle instanceof Rocket)) {
            return;
        }
        Rocket rocket = (Rocket)vehicle;
        Lander lander = (Lander)((class_1299)ModEntityTypes.LANDER.get()).method_5883((class_1937)targetLevel);
        if (lander == null) {
            return;
        }
        lander.method_33574(pos);
        targetLevel.method_8649((class_1297)lander);
        teleportedPlayer.method_5804((class_1297)lander);
        VehicleContainer rocketInventory = rocket.inventory();
        VehicleContainer landerInventory = lander.inventory();
        for (int i = 0; i < rocketInventory.method_5439(); ++i) {
            landerInventory.method_5447(i + 1, rocketInventory.method_5438(i));
        }
        landerInventory.method_5447(0, rocket.getDropStack());
        rocket.method_31472();
    }

    public static <B> ByteCodec<B> toByteCodec(Codec<B> codec) {
        return ModUtils.toByteCodec(codec, "Failed to find element", "Failed to parse element");
    }

    public static <B> ByteCodec<B> toByteCodec(Codec<B> codec, String notFound, String failedToParse) {
        return ByteCodec.passthrough((buf, item) -> {
            DataResult result = codec.encodeStart((DynamicOps)class_6903.method_46632((DynamicOps)YabnOps.COMPRESSED, (class_7225.class_7874)AdAstra.getRegistryAccess()), item);
            Optional optional = result.result();
            optional.ifPresentOrElse(element -> {
                byte[] bytes = element.toFullData();
                buf.writeBoolean(true);
                ByteBufUtils.writeVarInt((ByteBuf)buf, (int)bytes.length);
                buf.writeBytes(bytes);
            }, () -> buf.writeBoolean(false));
        }, buf -> {
            if (buf.readBoolean()) {
                int length = ByteBufUtils.readVarInt((ByteBuf)buf);
                byte[] bytes = new byte[length];
                buf.readBytes(bytes);
                return codec.parse((DynamicOps)class_6903.method_46632((DynamicOps)YabnOps.COMPRESSED, (class_7225.class_7874)AdAstra.getRegistryAccess()), (Object)YabnParser.parse((ByteReader)new ArrayByteReader(bytes))).result().orElseThrow(() -> new RuntimeException(failedToParse));
            }
            throw new RuntimeException(notFound);
        });
    }
}

