/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.codecs.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.common.codecs.predicates.NbtPredicate;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_2040;
import net.minecraft.class_2048;
import net.minecraft.class_2090;
import net.minecraft.class_2102;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_5699;
import net.minecraft.class_7923;

public record RestrictedEntityPredicate(class_1299<?> entityType, Optional<class_2090> location, Optional<class_2102> effects, Optional<NbtPredicate> nbt, Optional<class_2040> flags, Optional<class_2048> targetedEntity) {
    public static final Codec<RestrictedEntityPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41177.method_39673().fieldOf("type").forGetter(RestrictedEntityPredicate::entityType), (App)class_5699.method_53048((Codec)class_2090.field_45760, (String)"location").forGetter(RestrictedEntityPredicate::location), (App)class_5699.method_53048((Codec)class_2102.field_45764, (String)"effects").forGetter(RestrictedEntityPredicate::effects), (App)class_5699.method_53048(NbtPredicate.CODEC, (String)"nbt").forGetter(RestrictedEntityPredicate::nbt), (App)class_5699.method_53048((Codec)class_2040.field_45745, (String)"flags").forGetter(RestrictedEntityPredicate::flags), (App)class_5699.method_53048((Codec)class_2048.field_45746, (String)"target").forGetter(RestrictedEntityPredicate::targetedEntity)).apply((Applicative)instance, RestrictedEntityPredicate::new));

    public Optional<class_2487> getTag() {
        return this.nbt().map(NbtPredicate::tag);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(class_3218 level, class_1297 entity) {
        class_1309 class_13092;
        if (this.entityType == null) {
            return false;
        }
        if (this.entityType != entity.method_5864()) {
            return false;
        }
        if (this.location.isPresent() && !this.location.get().method_9018(level, entity.method_23317(), entity.method_23318(), entity.method_23321())) {
            return false;
        }
        if (this.effects.isPresent() && !this.effects.get().method_9062(entity)) {
            return false;
        }
        if (this.nbt.isPresent() && !this.nbt.get().matches(entity)) {
            return false;
        }
        if (this.flags.isPresent() && !this.flags.get().method_8892(entity)) {
            return false;
        }
        if (this.targetedEntity.isEmpty()) return true;
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            class_13092 = mob.method_5968();
        } else {
            class_13092 = null;
        }
        if (!this.targetedEntity.get().method_8909(level, null, class_13092)) return false;
        return true;
    }
}

