/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.threading.worldgen.common;

import com.google.common.base.Preconditions;
import com.ishland.c2me.base.common.scheduler.AbstractPosAwarePrioritizedTask;
import com.ishland.c2me.base.common.scheduler.LockTokenImpl;
import com.ishland.c2me.base.common.scheduler.ScheduledTask;
import com.ishland.c2me.base.common.scheduler.SchedulingManager;
import com.ishland.c2me.threading.worldgen.common.Config;
import com.ishland.flowsched.executor.LockToken;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.class_1923;
import net.minecraft.class_2806;
import net.minecraft.class_3193;
import net.minecraft.class_8563;

public class ChunkStatusUtils {
    public static final BooleanSupplier FALSE_SUPPLIER = () -> false;

    public static ChunkStatusThreadingType getThreadingType(class_2806 status) {
        if (status.equals(class_2806.field_16423) || status.equals(class_2806.field_16422) || status.equals(class_2806.field_12794) || status.equals(class_2806.field_12804) || status.equals(class_2806.field_12786) || status.equals(class_2806.field_12796) || status.equals(class_2806.field_12801)) {
            return ChunkStatusThreadingType.PARALLELIZED;
        }
        if (status.equals(class_2806.field_12795)) {
            return Config.allowThreadedFeatures ? ChunkStatusThreadingType.PARALLELIZED : ChunkStatusThreadingType.SINGLE_THREADED;
        }
        if (status.equals(class_2806.field_44633) || status.equals(class_2806.field_12805)) {
            return ChunkStatusThreadingType.PARALLELIZED;
        }
        return ChunkStatusThreadingType.PARALLELIZED;
    }

    public static <T> CompletableFuture<T> runChunkGenWithLock(class_1923 target, class_2806 status, int radius, SchedulingManager schedulingManager, ChunkStatusThreadingType threadingType, Supplier<CompletableFuture<T>> action) {
        Preconditions.checkNotNull((Object)status);
        ObjectArrayList lockTargets = new ObjectArrayList((2 * radius + 1) * (2 * radius + 1) + 1);
        for (int x = target.field_9181 - radius; x <= target.field_9181 + radius; ++x) {
            for (int z = target.field_9180 - radius; z <= target.field_9180 + radius; ++z) {
                lockTargets.add((Object)new LockTokenImpl(schedulingManager.getId(), class_1923.method_8331((int)x, (int)z), LockTokenImpl.Usage.WORLDGEN));
            }
        }
        if (threadingType == ChunkStatusThreadingType.SINGLE_THREADED) {
            lockTargets.add((Object)new LockTokenImpl(schedulingManager.getId(), class_1923.field_17348, LockTokenImpl.Usage.WORLDGEN));
        }
        ScheduledTask task = new ScheduledTask(target.method_8324(), action, (LockToken[])lockTargets.toArray(LockToken[]::new));
        schedulingManager.enqueue((AbstractPosAwarePrioritizedTask)task);
        return task.getFuture();
    }

    public static boolean isCancelled(class_3193 holder, class_2806 targetStatus) {
        return class_8563.method_51827((int)holder.method_14005()).method_16559() < targetStatus.method_16559();
    }

    public static enum ChunkStatusThreadingType {
        PARALLELIZED,
        SINGLE_THREADED,
        AS_IS;

    }
}

