/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.blocks.PileOfPollen;
import com.telepathicgrunt.the_bumblezone.blocks.StateReturningBrushableBlock;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.StateFocusedBrushableBlockEntity;
import com.telepathicgrunt.the_bumblezone.items.HoneyBeeLeggings;
import com.telepathicgrunt.the_bumblezone.mixin.entities.EntityCollisionContextAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import java.util.Arrays;
import net.minecraft.class_10;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1440;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.class_8162;
import net.minecraft.class_8170;
import net.minecraft.class_8174;
import org.jetbrains.annotations.Nullable;

public class PileOfPollenSuspicious
extends class_8170
implements StateReturningBrushableBlock {
    protected static final class_265 SHAPE = class_259.method_1077();
    private class_1792 item;
    public static final MapCodec<? extends PileOfPollenSuspicious> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41175.method_39673().fieldOf("turns_into").forGetter(PileOfPollenSuspicious::method_49810), (App)class_7923.field_41172.method_39673().fieldOf("brush_sound").forGetter(class_8170::method_49811), (App)class_7923.field_41172.method_39673().fieldOf("brush_comleted_sound").forGetter(class_8170::method_49812), (App)PileOfPollenSuspicious.method_54096()).apply((Applicative)instance, PileOfPollenSuspicious::new));

    public PileOfPollenSuspicious() {
        this(null, class_3417.field_43156, class_3417.field_43158, class_4970.class_2251.method_9637().method_31710(class_3620.field_16010).method_26245((blockState, world, blockPos) -> true).method_26243((blockState, blockGetter, blockPos) -> false).method_22488().method_9634().method_9632(0.1f).method_50012(class_3619.field_15971).method_9626(class_2498.field_11548));
    }

    public PileOfPollenSuspicious(class_2248 block, class_3414 soundEvent1, class_3414 soundEvent2, class_4970.class_2251 properties) {
        super(block, soundEvent1, soundEvent2, properties);
    }

    public MapCodec<class_8170> method_53969() {
        return CODEC;
    }

    @Nullable
    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return new StateFocusedBrushableBlockEntity(blockPos, blockState);
    }

    public class_2248 method_49810() {
        return BzBlocks.PILE_OF_POLLEN.get();
    }

    @Override
    public class_2680 getTurnsIntoState() {
        return (class_2680)BzBlocks.PILE_OF_POLLEN.get().method_9564().method_11657((class_2769)PileOfPollen.LAYERS, (Comparable)Integer.valueOf(8));
    }

    public class_1799 method_9574(class_4538 world, class_2338 blockPos, class_2680 blockState) {
        return new class_1799((class_1935)BzItems.POLLEN_PUFF.get());
    }

    public class_1792 method_8389() {
        if (this.item == null) {
            this.item = BzItems.POLLEN_PUFF.get();
        }
        return this.item;
    }

    public boolean method_9516(class_2680 blockState, class_1922 world, class_2338 blockPos, class_10 pathType) {
        return true;
    }

    public class_265 method_9530(class_2680 blockState, class_1922 world, class_2338 blockPos, class_3726 selectionContext) {
        return SHAPE;
    }

    public class_265 method_9549(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        class_3727 ctx;
        class_1297 entity;
        if (context instanceof class_3727 && (entity = (ctx = (class_3727)context).method_32480()) != null && entity.method_5864() != BzEntities.POLLEN_PUFF_ENTITY.get()) {
            StackTraceElement[] stackTrace;
            boolean found;
            context.method_17785(class_1802.field_8162);
            class_1799 heldItem = ((EntityCollisionContextAccessor)ctx).getHeldItem();
            if (heldItem != null && !heldItem.method_7960() && (PlatformHooks.isToolAction(heldItem, class_8162.class, "brush_brush") || heldItem.method_31573(BzTags.SUSPICIOUS_PILE_OF_POLLEN_ADDITIONAL_BRUSHES)) && (found = Arrays.stream(stackTrace = Thread.currentThread().getStackTrace()).map(StackTraceElement::getClassName).anyMatch(c -> c.equals(class_1802.field_42716.getClass().getName()) || c.equals(heldItem.method_7909().getClass().getName())))) {
                return this.method_9530(state, worldIn, pos, context);
            }
            return class_259.method_1073();
        }
        return this.method_9530(state, worldIn, pos, context);
    }

    public class_265 method_25959(class_2680 blockState, class_1922 world, class_2338 blockPos) {
        return SHAPE;
    }

    public class_265 method_26159(class_2680 blockState, class_1922 world, class_2338 blockPos, class_3726 selectionContext) {
        return SHAPE;
    }

    public boolean method_9526(class_2680 blockState) {
        return true;
    }

    public boolean method_9558(class_2680 blockState, class_4538 world, class_2338 blockPos) {
        class_2680 blockstate = world.method_8320(blockPos.method_10074());
        if (blockstate.method_26164(class_3481.field_39104) || !world.method_8320(blockPos).method_26227().method_15769()) {
            return false;
        }
        if (blockstate.method_26215() || blockstate.method_26164(BzTags.POLLEN_BLOCKS) || blockstate.method_26164(class_3481.field_39105)) {
            return true;
        }
        return class_2248.method_9501((class_265)blockstate.method_26220((class_1922)world, blockPos.method_10074()), (class_2350)class_2350.field_11036);
    }

    public void method_9588(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        class_2680 belowState;
        class_2586 blockEntity = serverLevel.method_8321(blockPos);
        if (blockEntity instanceof class_8174) {
            class_8174 brushableBlockEntity = (class_8174)blockEntity;
            brushableBlockEntity.method_49219();
        }
        if (!class_2346.method_10128((class_2680)(belowState = serverLevel.method_8320(blockPos.method_10074()))) || belowState.method_27852(BzBlocks.PILE_OF_POLLEN.get()) && (Integer)belowState.method_11654((class_2769)PileOfPollen.LAYERS) == 8 || blockPos.method_10264() < serverLevel.method_31607()) {
            return;
        }
        class_1540 fallingBlockEntity = class_1540.method_40005((class_1937)serverLevel, (class_2338)blockPos, (class_2680)blockState);
        fallingBlockEntity.method_49181();
    }

    public class_2680 method_9559(class_2680 oldBlockState, class_2350 direction, class_2680 newBlockState, class_1936 world, class_2338 blockPos, class_2338 blockPos1) {
        return !oldBlockState.method_26184((class_4538)world, blockPos) ? class_2246.field_10124.method_9564() : super.method_9559(oldBlockState, direction, newBlockState, world, blockPos, blockPos1);
    }

    public void method_9585(class_1936 world, class_2338 blockPos, class_2680 blockState) {
        if (world.method_8608()) {
            for (int i = 0; i < 50; ++i) {
                PileOfPollenSuspicious.spawnParticles(blockState, world, blockPos, world.method_8409(), true);
                PileOfPollenSuspicious.spawnParticles(world, class_243.method_24953((class_2382)blockPos), world.method_8409(), 0.055, 0.0075, 0.0);
            }
        }
    }

    public void method_9548(class_2680 blockState, class_1937 world, class_2338 blockPos, class_1297 entity) {
        if (!blockState.method_27852(BzBlocks.PILE_OF_POLLEN_SUSPICIOUS.get())) {
            return;
        }
        if (!(entity instanceof class_1303)) {
            class_1309 livingEntity;
            double entitySpeed;
            int layerValueMinusOne = 7;
            double speedReduction = entity instanceof class_1676 ? 0.85 : 1.0 - (double)layerValueMinusOne * 0.1;
            double chance = 0.22 + (double)layerValueMinusOne * 0.09;
            class_1799 beeLeggings = HoneyBeeLeggings.getEntityBeeLegging(entity);
            if (!beeLeggings.method_7960()) {
                speedReduction = Math.max(0.9, speedReduction);
            }
            class_243 deltaMovement = entity.method_18798();
            double newYDelta = deltaMovement.field_1351;
            if (entity instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)entity;
                if (entity.field_6017 > 18.0f && newYDelta < -0.9) {
                    BzCriterias.FALLING_ON_POLLEN_BLOCK_TRIGGER.get().trigger(serverPlayer);
                }
            }
            if (!entity.method_5864().method_20210(BzTags.PILE_OF_POLLEN_CANNOT_SLOW)) {
                newYDelta = deltaMovement.field_1351 > 0.0 ? (newYDelta *= 1.0 - (double)layerValueMinusOne * 0.01) : (newYDelta *= 0.84 - (double)layerValueMinusOne * 0.03);
                entity.method_18799(new class_243(deltaMovement.field_1352 * speedReduction, newYDelta, deltaMovement.field_1350 * speedReduction));
            }
            if ((entitySpeed = entity.method_18798().method_1033()) > 1.0E-5 && (double)world.field_9229.method_43057() < chance) {
                int particleStrength;
                int particleNumber = (int)(entitySpeed / 0.0045);
                int n = particleStrength = entity instanceof class_1542 ? Math.min(10, particleNumber / 3) : Math.min(20, particleNumber);
                if (world.method_8608()) {
                    for (int i = 0; i < particleNumber; ++i) {
                        if (particleNumber > 5) {
                            PileOfPollenSuspicious.spawnParticles(blockState, (class_1936)world, blockPos, world.field_9229, true);
                        }
                        PileOfPollenSuspicious.spawnParticles((class_1936)world, entity.method_19538().method_1019(entity.method_18798().method_18805(2.0, 2.0, 2.0)).method_1031(0.0, 0.75, 0.0), world.field_9229, 0.006 * (double)particleStrength, 7.5E-4 * (double)particleStrength, 0.006 * (double)particleStrength);
                    }
                } else if (!(entity instanceof class_1657) && !(entity instanceof class_1542)) {
                    PileOfPollenSuspicious.spawnParticlesServer((class_1936)world, entity.method_19538().method_1019(entity.method_18798().method_18805(2.0, 2.0, 2.0)).method_1031(0.0, 0.75, 0.0), world.field_9229, 0.006 * (double)particleStrength, 7.5E-4 * (double)particleStrength, 0.006 * (double)particleStrength, particleNumber);
                }
            }
            if (entity instanceof class_1440) {
                class_1440 pandaEntity = (class_1440)entity;
                PileOfPollenSuspicious.pandaSneezing(pandaEntity);
            }
            if (entity instanceof class_1309 && !(livingEntity = (class_1309)entity).method_6059(BzEffects.HIDDEN.get())) {
                PileOfPollen.applyHiddenEffectIfBuried(livingEntity, blockState, blockPos);
            }
        }
    }

    public static void pandaSneezing(class_1440 pandaEntity) {
        if (!pandaEntity.method_37908().method_8608() && pandaEntity.method_6051().method_43057() < 0.005f && pandaEntity.method_37908().method_8320(pandaEntity.method_24515()).method_27852(BzBlocks.PILE_OF_POLLEN.get())) {
            pandaEntity.method_6546(true);
        }
    }

    public void method_9496(class_2680 blockState, class_1937 world, class_2338 blockPos, class_5819 random) {
        double chance = 0.08f;
        if ((double)random.method_43057() < chance) {
            PileOfPollenSuspicious.spawnParticles(blockState, (class_1936)world, blockPos, random, false);
        }
    }

    public static void spawnParticles(class_2680 blockState, class_1936 world, class_2338 blockPos, class_5819 random, boolean disturbed) {
        for (class_2350 direction : class_2350.values()) {
            class_2338 blockpos = blockPos.method_10093(direction);
            if (world.method_8320(blockpos).method_26216((class_1922)world, blockpos)) continue;
            double speedYModifier = disturbed ? 0.05 : 0.005;
            double speedXZModifier = disturbed ? 0.03 : 0.005;
            class_265 currentShape = SHAPE;
            double yHeight = currentShape.method_1105(class_2350.class_2351.field_11052) - currentShape.method_1091(class_2350.class_2351.field_11052);
            class_2350.class_2351 directionAxis = direction.method_10166();
            double xOffset = directionAxis == class_2350.class_2351.field_11048 ? 0.5 + 0.5625 * (double)direction.method_10148() : (double)random.method_43057();
            double yOffset = directionAxis == class_2350.class_2351.field_11052 ? yHeight * (double)direction.method_10164() : (double)random.method_43057() * yHeight;
            double zOffset = directionAxis == class_2350.class_2351.field_11051 ? 0.5 + 0.5625 * (double)direction.method_10165() : (double)random.method_43057();
            world.method_8406((class_2394)BzParticles.POLLEN_PARTICLE.get(), (double)blockPos.method_10263() + xOffset, (double)blockPos.method_10264() + yOffset, (double)blockPos.method_10260() + zOffset, random.method_43059() * speedXZModifier, random.method_43059() * speedYModifier + (disturbed ? 0.01 : 0.0), random.method_43059() * speedXZModifier);
            return;
        }
    }

    public static void spawnParticles(class_1936 world, class_243 location, class_5819 random, double speedXZModifier, double speedYModifier, double initYSpeed) {
        double xOffset = (double)random.method_43057() * 0.3 - 0.15;
        double yOffset = (double)random.method_43057() * 0.3 - 0.15;
        double zOffset = (double)random.method_43057() * 0.3 - 0.15;
        world.method_8406((class_2394)BzParticles.POLLEN_PARTICLE.get(), location.method_10216() + xOffset, location.method_10214() + yOffset, location.method_10215() + zOffset, random.method_43059() * speedXZModifier, random.method_43059() * speedYModifier + initYSpeed, random.method_43059() * speedXZModifier);
    }

    public static void spawnParticlesServer(class_1936 world, class_243 location, class_5819 random, double speedXZModifier, double speedYModifier, double initYSpeed, int numberOfParticles) {
        if (world.method_8608()) {
            return;
        }
        double xOffset = (double)random.method_43057() * 0.3 - 0.15;
        double yOffset = (double)random.method_43057() * 0.3 - 0.15;
        double zOffset = (double)random.method_43057() * 0.3 - 0.15;
        ((class_3218)world).method_14199((class_2394)BzParticles.POLLEN_PARTICLE.get(), location.method_10216() + xOffset, location.method_10214() + yOffset, location.method_10215() + zOffset, numberOfParticles, random.method_43059() * speedXZModifier, random.method_43059() * speedYModifier + initYSpeed, random.method_43059() * speedXZModifier, (double)0.02f);
    }
}

