/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.essence;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.items.essence.AbilityEssenceItem;
import com.telepathicgrunt.the_bumblezone.mixin.blocks.StemBlockAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2421;
import net.minecraft.class_243;
import net.minecraft.class_2513;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3830;
import net.minecraft.class_4076;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public class LifeEssence
extends AbilityEssenceItem {
    private static final Supplier<Integer> cooldownLengthInTicks = () -> BzGeneralConfigs.lifeEssenceCooldown;
    private static final Supplier<Integer> abilityUseAmount = () -> BzGeneralConfigs.lifeEssenceAbilityUse;

    public LifeEssence(class_1792.class_1793 properties) {
        super(properties, cooldownLengthInTicks, abilityUseAmount);
    }

    @Override
    public int getColor() {
        return 5104939;
    }

    @Override
    void addDescriptionComponents(List<class_2561> components) {
        components.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.essence_life_description_1").method_27692(class_124.field_1060).method_27692(class_124.field_1056));
        components.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.essence_life_description_2").method_27692(class_124.field_1060).method_27692(class_124.field_1056));
    }

    public void decrementAbilityUseRemaining(class_1799 stack, class_3222 serverPlayer, int amount) {
        int getRemainingUse = this.getAbilityUseRemaining(stack) - amount;
        this.setAbilityUseRemaining(stack, getRemainingUse);
        if (getRemainingUse == 0) {
            this.setDepleted(stack, serverPlayer, false);
        }
    }

    @Override
    public void applyAbilityEffects(class_1799 stack, class_1937 level, class_3222 serverPlayer) {
        if (((long)serverPlayer.field_6012 + serverPlayer.method_5667().getLeastSignificantBits()) % 10L == 0L && level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (LifeEssence.getIsActive(stack)) {
                int radius = 16;
                this.healFriendlyNearby(stack, (class_1937)serverLevel, serverPlayer, radius);
                this.growNearbyPlants(stack, serverLevel, serverPlayer, radius);
                this.cureEntityOfEffects(stack, serverPlayer, (class_1309)serverPlayer);
            }
        }
    }

    private void healFriendlyNearby(class_1799 stack, class_1937 level, class_3222 serverPlayer, int radius) {
        List entities = level.method_8335((class_1297)serverPlayer, new class_238(serverPlayer.method_23317() - (double)radius, serverPlayer.method_23318() - (double)radius, serverPlayer.method_23321() - (double)radius, serverPlayer.method_23317() + (double)radius, serverPlayer.method_23318() + (double)radius, serverPlayer.method_23321() + (double)radius));
        for (class_1297 entity : entities) {
            this.healFriendlyEntity(stack, serverPlayer, entity);
            if (!LifeEssence.getForcedCooldown(stack)) continue;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void healFriendlyEntity(class_1799 stack, class_3222 serverPlayer, class_1297 entity) {
        class_1321 tamableAnimal;
        if (entity instanceof class_1321 && (tamableAnimal = (class_1321)entity).method_6171((class_1309)serverPlayer)) {
            this.healHealth(stack, serverPlayer, (class_1309)tamableAnimal);
            this.cureEntityOfEffects(stack, serverPlayer, (class_1309)tamableAnimal);
            return;
        }
        if (entity instanceof class_3222) {
            class_3222 serverPlayer2 = (class_3222)entity;
            if (!serverPlayer.method_51469().method_8503().method_3852()) {
                this.healHealth(stack, serverPlayer, (class_1309)serverPlayer2);
                this.cureEntityOfEffects(stack, serverPlayer, (class_1309)serverPlayer2);
                return;
            }
        }
        if (!(entity instanceof class_1309)) return;
        class_1309 livingEntity = (class_1309)entity;
        if (!entity.method_5722((class_1297)serverPlayer)) return;
        this.healHealth(stack, serverPlayer, livingEntity);
        this.cureEntityOfEffects(stack, serverPlayer, livingEntity);
    }

    private void cureEntityOfEffects(class_1799 stack, class_3222 serverPlayer, class_1309 livingEntity) {
        for (class_1293 effect : new ArrayList(livingEntity.method_6026())) {
            if (!GeneralUtils.isInTag(class_7923.field_41174, BzTags.LIFE_CURE_EFFECTS, effect.method_5579())) continue;
            livingEntity.method_6016(effect.method_5579());
            this.decrementAbilityUseRemaining(stack, serverPlayer, 1);
        }
    }

    private void healHealth(class_1799 stack, class_3222 serverPlayer, class_1309 livingEntity) {
        if (livingEntity.method_6032() < livingEntity.method_6063() && !livingEntity.method_29504()) {
            livingEntity.method_6025(1.0f);
            LifeEssence.spawnParticles(serverPlayer.method_51469(), serverPlayer.method_19538(), serverPlayer.method_6051());
            this.decrementAbilityUseRemaining(stack, serverPlayer, 1);
        }
    }

    private void growNearbyPlants(class_1799 stack, class_3218 level, class_3222 serverPlayer, int radius) {
        if (LifeEssence.getForcedCooldown(stack)) {
            return;
        }
        class_2338 playerPos = serverPlayer.method_24515();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        class_1923 currentCachedChunkPos = new class_1923(playerPos);
        class_2818 cachedChunk = null;
        int minX = playerPos.method_10263() - radius;
        int maxX = playerPos.method_10263() + radius;
        int minY = Math.max(level.method_31607(), playerPos.method_10264() - radius);
        int maxY = Math.min(level.method_31600() - 1, playerPos.method_10264() + radius);
        int minZ = playerPos.method_10260() - radius;
        int maxZ = playerPos.method_10260() + radius;
        for (int x = minX; x <= maxX; ++x) {
            boolean foundValidXChunkSection = false;
            for (int z = minZ; z <= maxZ; ++z) {
                if (cachedChunk == null || currentCachedChunkPos.field_9181 != class_4076.method_18675((int)x) || currentCachedChunkPos.field_9180 != class_4076.method_18675((int)z)) {
                    currentCachedChunkPos = new class_1923(class_4076.method_18675((int)x), class_4076.method_18675((int)z));
                    cachedChunk = level.method_8497(currentCachedChunkPos.field_9181, currentCachedChunkPos.field_9180);
                }
                boolean foundValidZChunkSection = false;
                for (int y = maxY; y >= minY; --y) {
                    if (cachedChunk.method_38259(cachedChunk.method_31602(y)).method_19523(a -> a.method_26164(BzTags.LIFE_GROW_PLANTS) && !a.method_26164(BzTags.LIFE_FORCE_DISALLOWED_GROW_PLANT))) {
                        foundValidZChunkSection = true;
                        foundValidXChunkSection = true;
                        mutableBlockPos.method_10103(x, y, z);
                        class_2680 state = cachedChunk.method_8320((class_2338)mutableBlockPos);
                        this.growPlantBlock(stack, level, serverPlayer, (class_2338)mutableBlockPos, state);
                        if (!LifeEssence.getForcedCooldown(stack)) continue;
                        return;
                    }
                    if (y == minY) continue;
                    y = Math.max(minY, class_4076.method_18688((int)class_4076.method_18675((int)y)));
                }
                if (foundValidZChunkSection || z == maxZ) continue;
                z = Math.min(maxZ, class_4076.method_18688((int)(class_4076.method_18675((int)z) + 1)));
            }
            if (foundValidXChunkSection || x == maxX) continue;
            x = Math.min(maxX, class_4076.method_18688((int)(class_4076.method_18675((int)x) + 1)));
        }
    }

    private void growPlantBlock(class_1799 stack, class_3218 level, class_3222 serverPlayer, class_2338 blockPos, class_2680 state) {
        if (state.method_26164(BzTags.LIFE_GROW_PLANTS) && !state.method_26164(BzTags.LIFE_FORCE_DISALLOWED_GROW_PLANT)) {
            class_2256 bonemealableBlock;
            class_2248 block = state.method_26204();
            boolean grewBlock = false;
            if (!GeneralUtils.isPermissionAllowedAtSpot((class_1937)level, (class_1297)serverPlayer, blockPos, true)) {
                return;
            }
            if (state.method_26164(BzTags.LIFE_IS_DEAD_BUSH)) {
                List saplings = GeneralUtils.convertHoldersetToList(class_7923.field_41175.method_40266(BzTags.LIFE_DEAD_BUSH_REVIVES_TO));
                saplings.removeIf(sapling -> GeneralUtils.isInTag(class_7923.field_41175, BzTags.LIFE_FORCE_DISALLOWED_DEAD_BUSH_REVIVES_TO, sapling));
                if (saplings.size() > 0) {
                    class_2248 chosenSapling = (class_2248)saplings.get(level.field_9229.method_43048(saplings.size()));
                    level.method_8652(blockPos, class_2246.field_10124.method_9564(), 2);
                    if (chosenSapling.method_9564().method_26184((class_4538)level, blockPos)) {
                        level.method_8652(blockPos, chosenSapling.method_9564(), 3);
                        grewBlock = true;
                    } else {
                        level.method_8652(blockPos, state, 2);
                    }
                }
            } else if (block instanceof class_2302) {
                class_2302 cropBlock = (class_2302)block;
                if (!cropBlock.method_9825(state)) {
                    class_2680 newState = cropBlock.method_9828(cropBlock.method_9829(state) + 1);
                    level.method_8652(blockPos, newState, 3);
                    grewBlock = true;
                }
            } else if (block instanceof class_2513) {
                class_2513 stemBlock = (class_2513)block;
                int age = (Integer)state.method_11654((class_2769)class_2513.field_11584);
                if (age < 7) {
                    class_2680 newState = (class_2680)state.method_11657((class_2769)class_2513.field_11584, (Comparable)Integer.valueOf(age + 1));
                    level.method_8652(blockPos, newState, 3);
                    grewBlock = true;
                } else if (age == 7 && this.doesNotHaveFruitNearby(level, stemBlock, blockPos)) {
                    block.method_9514(state, level, blockPos, level.method_8409());
                    grewBlock = true;
                }
            } else if (block instanceof class_2421) {
                int age = (Integer)state.method_11654((class_2769)class_2421.field_11306);
                if (age < 3) {
                    class_2680 newState = (class_2680)state.method_11657((class_2769)class_2421.field_11306, (Comparable)Integer.valueOf(age + 1));
                    level.method_8652(blockPos, newState, 3);
                    grewBlock = true;
                }
            } else if (state.method_27852(class_2246.field_16999)) {
                int age = (Integer)state.method_11654((class_2769)class_3830.field_17000);
                if (age < 3) {
                    class_2680 newState = (class_2680)state.method_11657((class_2769)class_3830.field_17000, (Comparable)Integer.valueOf(age + 1));
                    level.method_8652(blockPos, newState, 3);
                    grewBlock = true;
                }
            } else if (block instanceof class_2256 && (bonemealableBlock = (class_2256)block).method_9651((class_4538)level, blockPos, state)) {
                bonemealableBlock.method_9652(level, level.method_8409(), blockPos, state);
                grewBlock = true;
            } else if (!state.method_26164(BzTags.LIFE_THREE_HIGH_PILLAR_PLANT) || !level.method_8320(blockPos.method_10084()).method_27852(state.method_26204())) {
                Optional<class_2769> optionalProperty = state.method_28501().stream().filter(p -> p.method_11899().equalsIgnoreCase("age")).findAny();
                if (optionalProperty.isPresent()) {
                    class_2769 property = optionalProperty.get();
                    if (property.method_11902() == Integer.class && property.method_11898().stream().max(Comparable::compareTo).orElse(null) != state.method_11654(property)) {
                        class_2680 newState = (class_2680)state.method_11657(property, (Comparable)Integer.valueOf((Integer)state.method_11654(property) + 1));
                        level.method_8652(blockPos, newState, 3);
                        grewBlock = true;
                    } else if (state.method_26164(BzTags.LIFE_THREE_HIGH_PILLAR_PLANT)) {
                        grewBlock = LifeEssence.growUpOneToThreeHighLimit(level, blockPos, state);
                    }
                } else if (state.method_26164(BzTags.LIFE_THREE_HIGH_PILLAR_PLANT)) {
                    grewBlock = LifeEssence.growUpOneToThreeHighLimit(level, blockPos, state);
                }
            }
            if (grewBlock) {
                LifeEssence.spawnParticles(serverPlayer.method_51469(), serverPlayer.method_19538(), serverPlayer.method_6051());
                if (level.method_8409().method_43057() < 0.4f) {
                    this.decrementAbilityUseRemaining(stack, serverPlayer, 1);
                }
            }
        }
    }

    private static boolean growUpOneToThreeHighLimit(class_3218 level, class_2338 blockPos, class_2680 state) {
        int aboveOffset;
        int currentHeight = 1;
        for (aboveOffset = 1; level.method_8320(blockPos.method_10086(aboveOffset)).method_27852(state.method_26204()) && aboveOffset <= 3 && currentHeight <= 3; ++aboveOffset, ++currentHeight) {
        }
        for (int belowOffset = 1; level.method_8320(blockPos.method_10087(belowOffset)).method_27852(state.method_26204()) && belowOffset <= 3 && currentHeight <= 3; ++belowOffset, ++currentHeight) {
        }
        if (currentHeight < 3 && level.method_8320(blockPos.method_10086(aboveOffset)).method_26215()) {
            level.method_8652(blockPos.method_10086(aboveOffset), state.method_26204().method_9564(), 3);
            return true;
        }
        return false;
    }

    private boolean doesNotHaveFruitNearby(class_3218 level, class_2513 stemblock, class_2338 blockPos) {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2680 neighborState = level.method_8320(blockPos.method_10093(direction));
            if (!neighborState.method_54097(((StemBlockAccessor)stemblock).getFruit())) continue;
            return false;
        }
        return true;
    }

    public static void spawnParticles(class_3218 world, class_243 location, class_5819 random) {
        world.method_14199((class_2394)class_2398.field_11211, location.method_10216(), location.method_10214() + 1.0, location.method_10215(), 2, random.method_43059() * 0.2, random.method_43059() * 0.25 + 0.1, random.method_43059() * 0.2, (double)random.method_43057() * 0.2 + (double)0.1f);
    }
}

