/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modules.fabric;

import com.telepathicgrunt.the_bumblezone.modules.base.Module;
import com.telepathicgrunt.the_bumblezone.modules.base.ModuleHolder;
import com.telepathicgrunt.the_bumblezone.modules.base.fabric.FabricModuleHolder;
import com.telepathicgrunt.the_bumblezone.modules.fabric.ModuleComponent;
import com.telepathicgrunt.the_bumblezone.modules.registry.ModuleRegistrar;
import com.telepathicgrunt.the_bumblezone.modules.registry.ModuleRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentInitializer;
import dev.onyxstudios.cca.api.v3.entity.PlayerCopyCallback;
import dev.onyxstudios.cca.api.v3.entity.RespawnCopyStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class ComponentInitializer
implements EntityComponentInitializer {
    private static final List<FabricModuleHolder<?>> MODULES = new ArrayList();

    public void registerEntityComponentFactories(final @NotNull EntityComponentFactoryRegistry registry) {
        ModuleRegistry.register(new ModuleRegistrar(){

            @Override
            public <T extends Module<T>> void registerPlayerModule(ModuleHolder<T> holder, Supplier<T> factory, boolean unused) {
                if (holder instanceof FabricModuleHolder) {
                    FabricModuleHolder fabricHolder = (FabricModuleHolder)holder;
                    registry.registerForPlayers(fabricHolder.key(), player -> ModuleComponent.create(factory), RespawnCopyStrategy.NEVER_COPY);
                    MODULES.add(fabricHolder);
                }
            }

            @Override
            public <T extends Module<T>> void registerLivingEntityModule(ModuleHolder<T> holder, Supplier<T> factory, boolean unused) {
                if (holder instanceof FabricModuleHolder) {
                    FabricModuleHolder fabricHolder = (FabricModuleHolder)holder;
                    registry.registerFor(class_1309.class, fabricHolder.key(), entity -> ModuleComponent.create(factory));
                    MODULES.add(fabricHolder);
                }
            }
        });
        PlayerCopyCallback.EVENT.register((oldPlayer, newPlayer, loseless) -> {
            for (FabricModuleHolder<?> holder : MODULES) {
                ComponentInitializer.copy(oldPlayer, newPlayer, holder, loseless);
            }
        });
    }

    private static <T extends Module<T>> void copy(class_3222 oldPlayer, class_3222 newPlayer, FabricModuleHolder<T> serializer, boolean isPersistent) {
        ModuleComponent oldModule = (ModuleComponent)serializer.key().getNullable((Object)oldPlayer);
        ModuleComponent newModule = (ModuleComponent)serializer.key().getNullable((Object)newPlayer);
        if (oldModule != null && newModule != null) {
            oldModule.module().serializer().onPlayerCopy(oldModule.module(), newModule.module(), newPlayer, isPersistent);
        }
    }
}

