/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.packets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.QueensTradeManager;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.WeightedTradeResult;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.DatapackSyncEvent;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.MainTradeRowInput;
import com.telepathicgrunt.the_bumblezone.packets.MessageHandler;
import com.telepathicgrunt.the_bumblezone.packets.networking.base.Packet;
import com.telepathicgrunt.the_bumblezone.packets.networking.base.PacketContext;
import com.telepathicgrunt.the_bumblezone.packets.networking.base.PacketHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_6012;

public record QueenMainTradesSyncPacket(List<Pair<MainTradeRowInput, class_6012<WeightedTradeResult>>> recipeViewerMainTrades) implements Packet<QueenMainTradesSyncPacket>
{
    public static Gson gson = new GsonBuilder().create();
    public static final class_2960 ID = new class_2960("the_bumblezone", "queen_main_trades_sync_packet");
    public static final Handler HANDLER = new Handler();

    public static void sendToClient(DatapackSyncEvent event) {
        MessageHandler.DEFAULT_CHANNEL.sendToPlayer(new QueenMainTradesSyncPacket(QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades), (class_1657)event.player());
    }

    @Override
    public class_2960 getID() {
        return ID;
    }

    @Override
    public PacketHandler<QueenMainTradesSyncPacket> getHandler() {
        return HANDLER;
    }

    public static class Handler
    implements PacketHandler<QueenMainTradesSyncPacket> {
        @Override
        public PacketContext handle(QueenMainTradesSyncPacket pkt) {
            return (player, level) -> {
                QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades = pkt.recipeViewerMainTrades();
            };
        }

        @Override
        public QueenMainTradesSyncPacket decode(class_2540 buf) {
            ArrayList<Pair<MainTradeRowInput, class_6012<WeightedTradeResult>>> parsedData = new ArrayList<Pair<MainTradeRowInput, class_6012<WeightedTradeResult>>>();
            class_2487 data = buf.method_10798();
            if (data == null) {
                Bumblezone.LOGGER.error("Queen Main Trade packet is empty??? Wtf???");
                return new QueenMainTradesSyncPacket(parsedData);
            }
            class_2499 tagList = data.method_10554("main_trades", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                class_2487 tradeCompound = tagList.method_10602(i);
                class_2487 firstHalf = tradeCompound.method_10562("input");
                class_2499 secondHalf = tradeCompound.method_10554("output", 10);
                DataResult dataResult1 = MainTradeRowInput.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)firstHalf);
                dataResult1.error().ifPresent(e -> Bumblezone.LOGGER.error("Failed to parse Queen Main Trade packet entry (first half): {}", e));
                DataResult dataResult2 = class_6012.method_34991(WeightedTradeResult.CODEC).parse((DynamicOps)class_2509.field_11560, (Object)secondHalf);
                dataResult2.error().ifPresent(e -> Bumblezone.LOGGER.error("Failed to parse Queen Main Trade packet entry (second half): {}", e));
                dataResult1.result().ifPresent(input -> dataResult2.result().ifPresent(output -> parsedData.add(Pair.of((Object)input, (Object)output))));
            }
            return new QueenMainTradesSyncPacket(parsedData);
        }

        @Override
        public void encode(QueenMainTradesSyncPacket pkt, class_2540 buf) {
            class_2487 data = new class_2487();
            class_2499 listTag = new class_2499();
            for (Pair<MainTradeRowInput, class_6012<WeightedTradeResult>> tradeRow : pkt.recipeViewerMainTrades()) {
                class_2487 pairData = new class_2487();
                DataResult dataResult1 = MainTradeRowInput.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)((MainTradeRowInput)tradeRow.getFirst()));
                dataResult1.error().ifPresent(e -> Bumblezone.LOGGER.error("Failed to encode Queen Main Trade packet entry (first half): {}", e));
                dataResult1.result().ifPresent(r -> pairData.method_10566("input", r));
                DataResult dataResult = class_6012.method_34991(WeightedTradeResult.CODEC).encodeStart((DynamicOps)class_2509.field_11560, (Object)((class_6012)tradeRow.getSecond()));
                dataResult.error().ifPresent(e -> Bumblezone.LOGGER.error("Failed to encode Queen Main Trade packet entry (second half): {}", e));
                dataResult.result().ifPresent(r -> pairData.method_10566("output", r));
                listTag.add((Object)pairData);
            }
            data.method_10566("main_trades", (class_2520)listTag);
            buf.method_10794((class_2520)data);
        }
    }
}

