/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.mixin.world.StructureTemplateAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2402;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_244;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_251;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3468;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3730;
import net.minecraft.class_3748;
import net.minecraft.class_3829;
import net.minecraft.class_3853;
import net.minecraft.class_4076;
import net.minecraft.class_4466;
import net.minecraft.class_4538;
import net.minecraft.class_4966;
import net.minecraft.class_5000;
import net.minecraft.class_5425;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7138;
import org.jetbrains.annotations.Nullable;

public class GeneralUtils {
    private static int ACTIVE_ENTITIES = 0;
    private static final Set<class_4466> BEE_SET = new HashSet<class_4466>();
    public static final List<class_2680> VANILLA_CANDLES = ImmutableList.of((Object)class_2246.field_27099.method_9564(), (Object)class_2246.field_27109.method_9564(), (Object)class_2246.field_27141.method_9564(), (Object)class_2246.field_27111.method_9564(), (Object)class_2246.field_27112.method_9564(), (Object)class_2246.field_27107.method_9564(), (Object)class_2246.field_27113.method_9564(), (Object)class_2246.field_27103.method_9564(), (Object)class_2246.field_27108.method_9564(), (Object)class_2246.field_27105.method_9564(), (Object)class_2246.field_27102.method_9564(), (Object)class_2246.field_27101.method_9564(), (Object[])new class_2680[]{class_2246.field_27106.method_9564(), class_2246.field_27110.method_9564(), class_2246.field_27140.method_9564(), class_2246.field_27100.method_9564(), class_2246.field_27104.method_9564()});

    public static void updateEntityCount(class_3218 world) {
        BEE_SET.clear();
        int counter = 0;
        for (class_1297 entity : world.method_27909()) {
            if (entity.method_5805() && entity instanceof class_1309) {
                ++counter;
            }
            if (!(entity instanceof class_4466)) continue;
            BEE_SET.add((class_4466)entity);
        }
        ACTIVE_ENTITIES = counter;
        BEE_SET.removeIf(bee -> bee.method_5947() || bee.method_21791() || bee.method_16914() || bee.method_5934() || bee.method_5782() || bee.method_5987());
    }

    public static int getNearbyActiveEntitiesInDimension(class_3218 level, class_2338 position) {
        if (level.method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            return ACTIVE_ENTITIES;
        }
        return level.method_18467(class_4466.class, new class_238(class_243.method_24954((class_2382)position.method_10069(-16, -16, -16)), class_243.method_24954((class_2382)position.method_10069(16, 16, 16)))).size();
    }

    public static void adjustEntityCountInBz(int adjust) {
        ACTIVE_ENTITIES += adjust;
    }

    public static Set<class_4466> getAllWildBees() {
        return BEE_SET;
    }

    public static <T> T getRandomEntry(List<Pair<T, Integer>> rlList, class_5819 random) {
        int index;
        double totalWeight = 0.0;
        for (Pair<T, Integer> pair : rlList) {
            totalWeight += (double)((Integer)pair.getSecond()).intValue();
        }
        double randomWeightPicked = (double)random.method_43057() * totalWeight;
        for (index = 0; index < rlList.size() - 1 && !((randomWeightPicked -= (double)((Integer)rlList.get(index).getSecond()).intValue()) <= 0.0); ++index) {
        }
        return (T)rlList.get(index).getFirst();
    }

    public static class_2338 getRandomBlockposWithinRange(class_1309 entity, int maxRadius, int minRadius) {
        class_2338 newBeePos = class_2338.method_49637((double)(entity.method_23317() + (double)((entity.method_6051().method_43048(maxRadius) + minRadius) * (entity.method_6051().method_43056() ? 1 : -1))), (double)Doubles.constrainToRange((double)(entity.method_23318() + (double)((entity.method_6051().method_43048(maxRadius) + minRadius) * (entity.method_6051().method_43056() ? 1 : -1))), (double)1.0, (double)254.0), (double)(entity.method_23321() + (double)((entity.method_6051().method_43048(maxRadius) + minRadius) * (entity.method_6051().method_43056() ? 1 : -1))));
        return newBeePos;
    }

    public static void givePlayerItem(class_1657 playerEntity, class_1268 hand, class_1799 itemstackToGive, boolean giveContainerItem, boolean shrinkCurrentItem) {
        if (playerEntity.method_37908().method_8608()) {
            return;
        }
        class_1799 playerItem = playerEntity.method_5998(hand);
        class_1799 copiedPlayerItem = playerItem.method_7972();
        boolean instabuild = playerEntity.method_31549().field_7477;
        if (!playerItem.method_7960()) {
            playerEntity.method_7259(class_3468.field_15372.method_14956((Object)playerItem.method_7909()));
        }
        if (!instabuild && shrinkCurrentItem) {
            playerItem.method_7934(1);
        }
        if (!itemstackToGive.method_7960()) {
            if (playerItem.method_7960()) {
                playerEntity.method_6122(hand, itemstackToGive);
            } else if (instabuild) {
                if (!playerEntity.method_31548().method_7379(itemstackToGive)) {
                    playerEntity.method_31548().method_7394(itemstackToGive);
                }
            } else if (!playerEntity.method_31548().method_7394(itemstackToGive)) {
                playerEntity.method_7328(itemstackToGive, false);
            }
        }
        if (giveContainerItem && PlatformHooks.hasCraftingRemainder(copiedPlayerItem)) {
            class_1799 containerItem = PlatformHooks.getCraftingRemainder(copiedPlayerItem);
            if (playerItem.method_7960()) {
                playerEntity.method_6122(hand, containerItem);
            } else if (instabuild) {
                if (!playerEntity.method_31548().method_7379(containerItem)) {
                    playerEntity.method_31548().method_7394(containerItem);
                }
            } else if (!playerEntity.method_31548().method_7394(containerItem)) {
                playerEntity.method_7328(containerItem, false);
            }
        }
    }

    public static boolean canJigsawsAttach(class_3499.class_3501 jigsaw1, class_3499.class_3501 jigsaw2) {
        class_5000 prop1 = (class_5000)jigsaw1.comp_1342().method_11654((class_2769)class_3748.field_23262);
        class_5000 prop2 = (class_5000)jigsaw2.comp_1342().method_11654((class_2769)class_3748.field_23262);
        String joint = jigsaw1.comp_1343().method_10558("joint");
        if (joint.isEmpty()) {
            joint = prop1.method_26426().method_10166().method_10179() ? "aligned" : "rollable";
        }
        boolean isRollable = joint.equals("rollable");
        return prop1.method_26426() == prop2.method_26426().method_10153() && (isRollable || prop1.method_26428() == prop2.method_26428()) && jigsaw1.comp_1343().method_10558("target").equals(jigsaw2.comp_1343().method_10558("name"));
    }

    public static int getFirstLandYFromPos(class_4538 worldView, class_2338 pos) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        mutable.method_10101((class_2382)pos);
        class_2791 currentChunk = worldView.method_22350((class_2338)mutable);
        class_2680 currentState = currentChunk.method_8320((class_2338)mutable);
        while (mutable.method_10264() >= worldView.method_31607() && GeneralUtils.isReplaceableByStructures(currentState)) {
            mutable.method_10098(class_2350.field_11033);
            currentState = currentChunk.method_8320((class_2338)mutable);
        }
        return mutable.method_10264();
    }

    private static boolean isReplaceableByStructures(class_2680 blockState) {
        return blockState.method_26215() || !blockState.method_26227().method_15769() || blockState.method_45474() || blockState.method_27852(BzBlocks.HONEY_CRYSTAL.get());
    }

    public static class_2338 getLowestLand(class_2794 chunkGenerator, class_7138 randomState, class_2338 centerPos, class_5539 heightLimitView, boolean canBeOnLiquid, boolean canBeInLiquid) {
        class_2680 currentBlockstate;
        class_2338.class_2339 mutable = new class_2338.class_2339().method_10103(centerPos.method_10263(), 1, centerPos.method_10260());
        class_4966 blockView = chunkGenerator.method_26261(mutable.method_10263(), mutable.method_10260(), heightLimitView, randomState);
        class_2680 pastBlockstate = currentBlockstate = blockView.method_32892(mutable.method_10264());
        while (mutable.method_10264() <= GeneralUtils.getMaxTerrainLimit(chunkGenerator)) {
            if (canBeInLiquid && !currentBlockstate.method_26227().method_15769()) {
                mutable.method_10098(class_2350.field_11036);
                return mutable;
            }
            if ((canBeOnLiquid || !pastBlockstate.method_26227().method_15769()) && currentBlockstate.method_26215()) {
                mutable.method_10098(class_2350.field_11036);
                return mutable;
            }
            mutable.method_10098(class_2350.field_11036);
            pastBlockstate = currentBlockstate;
            currentBlockstate = blockView.method_32892(mutable.method_10264());
        }
        return mutable;
    }

    public static int getMaxTerrainLimit(class_2794 chunkGenerator) {
        return chunkGenerator.method_33730() + chunkGenerator.method_12104();
    }

    public static void spawnItemEntity(class_3218 serverLevel, class_2338 blockPos, class_1799 itemToSpawn, double randomXZSpeed, double ySpeed) {
        if (!itemToSpawn.method_7960()) {
            class_1542 itemEntity = new class_1542((class_1937)serverLevel, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 1.0, (double)blockPos.method_10260() + 0.5, itemToSpawn);
            itemEntity.method_18799(new class_243(serverLevel.field_9229.method_43059() * randomXZSpeed, ySpeed, serverLevel.field_9229.method_43059() * randomXZSpeed));
            itemEntity.method_6988();
            serverLevel.method_8649((class_1297)itemEntity);
        }
    }

    public static void centerAllPieces(class_2338 targetPos, List<? extends class_3443> pieces) {
        if (pieces.isEmpty()) {
            return;
        }
        class_2338 structureCenter = pieces.get(0).method_14935().method_22874();
        int xOffset = targetPos.method_10263() - structureCenter.method_10263();
        int zOffset = targetPos.method_10260() - structureCenter.method_10260();
        for (class_3443 class_34432 : pieces) {
            class_34432.method_14922(xOffset, 0, zOffset);
        }
    }

    public static <T> List<T> convertHoldersetToList(Optional<class_6885.class_6888<T>> blockTagResult) {
        return blockTagResult.map(holders -> holders.method_40239().map(class_6880::comp_349).collect(Collectors.toCollection(ArrayList::new))).orElseGet(ArrayList::new);
    }

    public static <B, T extends B> boolean isInTag(class_2378<B> registry, class_6862<B> key, T value) {
        return ((class_6880.class_6883)registry.method_40265(registry.method_10206(value)).orElseThrow()).method_40220(key);
    }

    public static <T> boolean listMatches(List<T> list, List<? extends Predicate<T>> predicates) {
        if (list.size() != predicates.size()) {
            return false;
        }
        ArrayList<Predicate<T>> copiedPredicates = new ArrayList<Predicate<T>>(predicates);
        for (int i = copiedPredicates.size() - 1; i >= 0; --i) {
            block4: {
                for (int k = list.size() - 1; k >= 0; --k) {
                    if (!((Predicate)copiedPredicates.get(i)).test(list.get(k))) {
                        continue;
                    }
                    break block4;
                }
                return false;
            }
            copiedPredicates.remove(i);
        }
        return copiedPredicates.isEmpty();
    }

    public static int split(int value, boolean upper) {
        return upper ? value >> 16 : value & 0xFFFF;
    }

    public static int merge(int upper, int lower) {
        return (upper << 16) + (lower & 0xFFFF);
    }

    public static boolean isBlockAllowedForSugarWaterWaterlogging(class_2680 blockState) {
        return blockState.method_26164(BzTags.WATERLOGGABLE_BLOCKS_WHEN_PLACED_IN_FLUID) && !blockState.method_26164(BzTags.FORCED_DISALLOW_WATERLOGGING_BLOCKS_WHEN_PLACED_IN_FLUID);
    }

    public static boolean isPermissionAllowedAtSpot(class_1937 level, class_1297 entity, class_2338 pos, boolean placingBlock) {
        class_1657 player;
        if (entity instanceof class_1657 && !(player = (class_1657)entity).method_36971(level, pos)) {
            return false;
        }
        return PlatformHooks.isPermissionAllowedAtSpot(level, entity, pos, placingBlock);
    }

    public static <T extends Comparable<T>> class_2680 getStateWithProperty(class_2680 state, class_2680 stateToCopy, class_2769<T> property) {
        return (class_2680)state.method_11657(property, stateToCopy.method_11654(property));
    }

    public static void placeInWorldWithoutNeighborUpdate(class_5425 serverLevelAccessor, class_3499 structureTemplate, class_2338 blockPos, class_2338 blockPos2, class_3492 structurePlaceSettings, class_5819 randomSource, int i) {
        if (((StructureTemplateAccessor)structureTemplate).getBlocks().isEmpty()) {
            return;
        }
        List list = structurePlaceSettings.method_15121(((StructureTemplateAccessor)structureTemplate).getBlocks(), blockPos).method_27125();
        if (list.isEmpty() && structurePlaceSettings.method_15135() || structureTemplate.method_15160().method_10263() < 1 || structureTemplate.method_15160().method_10264() < 1 || structureTemplate.method_15160().method_10260() < 1) {
            return;
        }
        class_3341 boundingBox = structurePlaceSettings.method_15124();
        ArrayList list2 = Lists.newArrayListWithCapacity((int)(structurePlaceSettings.method_15120() ? list.size() : 0));
        ArrayList list3 = Lists.newArrayListWithCapacity((int)(structurePlaceSettings.method_15120() ? list.size() : 0));
        ArrayList list4 = Lists.newArrayListWithCapacity((int)list.size());
        int j = Integer.MAX_VALUE;
        int k = Integer.MAX_VALUE;
        int l = Integer.MAX_VALUE;
        int m = Integer.MIN_VALUE;
        int n = Integer.MIN_VALUE;
        int o = Integer.MIN_VALUE;
        List list5 = class_3499.method_16446((class_5425)serverLevelAccessor, (class_2338)blockPos, (class_2338)blockPos2, (class_3492)structurePlaceSettings, (List)list);
        for (class_3499.class_3501 structureBlockInfo : list5) {
            class_2586 blockEntity;
            class_2338 blockPos3 = structureBlockInfo.comp_1341();
            if (boundingBox != null && !boundingBox.method_14662((class_2382)blockPos3)) continue;
            class_3610 fluidState = structurePlaceSettings.method_15120() ? serverLevelAccessor.method_8316(blockPos3) : null;
            class_2680 blockState = structureBlockInfo.comp_1342().method_26185(structurePlaceSettings.method_15114()).method_26186(structurePlaceSettings.method_15113());
            if (structureBlockInfo.comp_1343() != null) {
                blockEntity = serverLevelAccessor.method_8321(blockPos3);
                class_3829.method_16825((Object)blockEntity);
                serverLevelAccessor.method_8652(blockPos3, class_2246.field_10499.method_9564(), 20);
            }
            if (!serverLevelAccessor.method_8652(blockPos3, blockState, i)) continue;
            j = Math.min(j, blockPos3.method_10263());
            k = Math.min(k, blockPos3.method_10264());
            l = Math.min(l, blockPos3.method_10260());
            m = Math.max(m, blockPos3.method_10263());
            n = Math.max(n, blockPos3.method_10264());
            o = Math.max(o, blockPos3.method_10260());
            list4.add(Pair.of((Object)blockPos3, (Object)structureBlockInfo.comp_1343()));
            if (structureBlockInfo.comp_1343() != null && (blockEntity = serverLevelAccessor.method_8321(blockPos3)) != null) {
                if (blockEntity instanceof class_2621) {
                    structureBlockInfo.comp_1343().method_10544("LootTableSeed", randomSource.method_43055());
                }
                blockEntity.method_11014(structureBlockInfo.comp_1343());
            }
            if (fluidState == null) continue;
            if (blockState.method_26227().method_15771()) {
                list3.add(blockPos3);
                continue;
            }
            if (!(blockState.method_26204() instanceof class_2402)) continue;
            ((class_2402)blockState.method_26204()).method_10311((class_1936)serverLevelAccessor, blockPos3, blockState, fluidState);
            if (fluidState.method_15771()) continue;
            list2.add(blockPos3);
        }
        boolean bl = true;
        class_2350[] directions = new class_2350[]{class_2350.field_11036, class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};
        while (bl && !list2.isEmpty()) {
            bl = false;
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                class_2680 blockState2;
                class_2248 block;
                class_2338 blockPos3 = (class_2338)iterator.next();
                class_3610 fluidState2 = serverLevelAccessor.method_8316(blockPos3);
                for (int p = 0; p < directions.length && !fluidState2.method_15771(); ++p) {
                    class_2338 blockPos5 = blockPos3.method_10093(directions[p]);
                    class_3610 fluidState = serverLevelAccessor.method_8316(blockPos5);
                    if (!fluidState.method_15771() || list3.contains(blockPos5)) continue;
                    fluidState2 = fluidState;
                }
                if (!fluidState2.method_15771() || !((block = (blockState2 = serverLevelAccessor.method_8320(blockPos3)).method_26204()) instanceof class_2402)) continue;
                ((class_2402)block).method_10311((class_1936)serverLevelAccessor, blockPos3, blockState2, fluidState2);
                bl = true;
                iterator.remove();
            }
        }
        if (j <= m) {
            if (!structurePlaceSettings.method_16444()) {
                class_244 discreteVoxelShape = new class_244(m - j + 1, n - k + 1, o - l + 1);
                for (Pair pair : list4) {
                    class_2338 blockPos6 = (class_2338)pair.getFirst();
                    discreteVoxelShape.method_1049(blockPos6.method_10263() - j, blockPos6.method_10264() - k, blockPos6.method_10260() - l);
                }
                class_3499.method_20532((class_1936)serverLevelAccessor, (int)i, (class_251)discreteVoxelShape, (int)j, (int)k, (int)l);
            }
            for (Pair pair : list4) {
                class_2586 blockEntity;
                class_2338 blockPos7 = (class_2338)pair.getFirst();
                if (!structurePlaceSettings.method_16444()) {
                    class_2680 blockState3;
                    class_2680 blockState2 = serverLevelAccessor.method_8320(blockPos7);
                    if (blockState2 != (blockState3 = class_2248.method_9510((class_2680)blockState2, (class_1936)serverLevelAccessor, (class_2338)blockPos7))) {
                        serverLevelAccessor.method_8652(blockPos7, blockState3, i & 0xFFFFFFFE);
                    }
                    serverLevelAccessor.method_8408(blockPos7, blockState3.method_26204());
                }
                if (pair.getSecond() == null || (blockEntity = serverLevelAccessor.method_8321(blockPos7)) == null) continue;
                blockEntity.method_5431();
            }
        }
        if (!structurePlaceSettings.method_15135()) {
            GeneralUtils.placeEntities(serverLevelAccessor, structureTemplate, blockPos, structurePlaceSettings.method_15114(), structurePlaceSettings.method_15113(), structurePlaceSettings.method_15134(), boundingBox, structurePlaceSettings.method_27265());
        }
    }

    private static void placeEntities(class_5425 serverLevelAccessor, class_3499 structureTemplate, class_2338 blockPos, class_2415 mirror, class_2470 rotation, class_2338 blockPos2, @Nullable class_3341 boundingBox, boolean bl) {
        for (class_3499.class_3502 structureEntityInfo : ((StructureTemplateAccessor)structureTemplate).getEntityInfoList()) {
            class_2338 blockPos3 = class_3499.method_15168((class_2338)structureEntityInfo.field_15600, (class_2415)mirror, (class_2470)rotation, (class_2338)blockPos2).method_10081((class_2382)blockPos);
            if (boundingBox != null && !boundingBox.method_14662((class_2382)blockPos3)) continue;
            class_2487 compoundTag = structureEntityInfo.field_15598.method_10553();
            class_243 vec3 = class_3499.method_15176((class_243)structureEntityInfo.field_15599, (class_2415)mirror, (class_2470)rotation, (class_2338)blockPos2);
            class_243 vec32 = vec3.method_1031((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260());
            class_2499 listTag = new class_2499();
            listTag.add((Object)class_2489.method_23241((double)vec32.field_1352));
            listTag.add((Object)class_2489.method_23241((double)vec32.field_1351));
            listTag.add((Object)class_2489.method_23241((double)vec32.field_1350));
            compoundTag.method_10566("Pos", (class_2520)listTag);
            compoundTag.method_10551("UUID");
            GeneralUtils.createEntityIgnoreException(serverLevelAccessor, compoundTag).ifPresent(entity -> {
                float f = entity.method_5832(rotation);
                entity.method_5808(vec32.field_1352, vec32.field_1351, vec32.field_1350, f + (entity.method_5763(mirror) - entity.method_36454()), entity.method_36455());
                if (bl && entity instanceof class_1308) {
                    ((class_1308)entity).method_5943(serverLevelAccessor, serverLevelAccessor.method_8404(class_2338.method_49638((class_2374)vec32)), class_3730.field_16474, null, compoundTag);
                }
                serverLevelAccessor.method_30771(entity);
            });
        }
    }

    private static Optional<class_1297> createEntityIgnoreException(class_5425 serverLevelAccessor, class_2487 compoundTag) {
        try {
            return class_1299.method_5892((class_2487)compoundTag, (class_1937)serverLevelAccessor.method_8410());
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public static boolean isSimilarInColor(int color1, int color2, int threshold) {
        return Math.abs(GeneralUtils.getRed(color1) - GeneralUtils.getRed(color2)) + Math.abs(GeneralUtils.getGreen(color1) - GeneralUtils.getGreen(color2)) + Math.abs(GeneralUtils.getBlue(color1) - GeneralUtils.getBlue(color2)) < threshold;
    }

    public static boolean isSimilarInVisualColor(int color1, int color2, int hueThreshold, int valueThreshold) {
        double[] hue2;
        double[] hue1 = GeneralUtils.ColorToHsv(color1);
        double hueDiff = hue1[0] - (hue2 = GeneralUtils.ColorToHsv(color2))[0];
        if (hueDiff > 180.0) {
            hueDiff -= 360.0;
        } else if (hueDiff < -180.0) {
            hueDiff += 360.0;
        }
        double hueDistance = Math.sqrt(hueDiff * hueDiff);
        double valueDiff = Math.abs(hue1[2] - hue2[2]);
        return hueDistance < (double)hueThreshold && valueDiff < (double)valueThreshold;
    }

    public static double[] ColorToHsv(int color) {
        int r = GeneralUtils.getRed(color);
        int g = GeneralUtils.getGreen(color);
        int b = GeneralUtils.getBlue(color);
        double h = 0.0;
        double min = Math.min(Math.min(r, g), b);
        double v = Math.max(Math.max(r, g), b);
        double delta = v - min;
        double s = v == 0.0 ? 0.0 : delta / v;
        if (s == 0.0) {
            h = 0.0;
        } else {
            if ((double)r == v) {
                h = (double)(g - b) / delta;
            } else if ((double)g == v) {
                h = 2.0 + (double)(b - r) / delta;
            } else if ((double)b == v) {
                h = 4.0 + (double)(r - g) / delta;
            }
            h *= 60.0;
            if (h < 0.0) {
                h += 360.0;
            }
        }
        double[] hsv = new double[]{h, s * 360.0, v};
        return hsv;
    }

    public static int getAlpha(int color) {
        return color >> 24 & 0xFF;
    }

    public static int getRed(int color) {
        return color >> 16 & 0xFF;
    }

    public static int getGreen(int color) {
        return color >> 8 & 0xFF;
    }

    public static int getBlue(int color) {
        return color & 0xFF;
    }

    public static int colorToInt(int red, int green, int blue) {
        return (red << 16) + (green << 8) + blue;
    }

    public static double capBetween(double value, double min, double max) {
        return Math.min(Math.max(value, min), max);
    }

    public static List<class_2338> matchingBlocksOfKindInRange(class_1937 level, class_2338 centerPos, int radius, Predicate<class_2680> predicate) {
        ObjectArrayList validPos = new ObjectArrayList();
        class_1923 maxChunkPos = new class_1923(class_4076.method_18675((int)(centerPos.method_10263() + radius)), class_4076.method_18675((int)(centerPos.method_10260() + radius)));
        class_1923 minChunkPos = new class_1923(class_4076.method_18675((int)(centerPos.method_10263() - radius)), class_4076.method_18675((int)(centerPos.method_10260() - radius)));
        for (int xOffset = minChunkPos.field_9181; xOffset <= maxChunkPos.field_9181; ++xOffset) {
            for (int zOffset = minChunkPos.field_9180; zOffset <= maxChunkPos.field_9180; ++zOffset) {
                class_2818 chunk = level.method_8497(xOffset, zOffset);
                GeneralUtils.scanChunkForMatchInRange(predicate, (List<class_2338>)validPos, (class_2791)chunk, centerPos, radius);
            }
        }
        return validPos;
    }

    private static void scanChunkForMatchInRange(Predicate<class_2680> predicate, List<class_2338> validPos, class_2791 chunk, class_2338 originalPos, int radius) {
        class_2338.class_2339 mutableSectionWorldOrigin = new class_2338.class_2339();
        class_2338.class_2339 mutableSectionWorldBlockPos = new class_2338.class_2339();
        int radiusSq = radius * radius;
        for (int i = chunk.method_32891(); i < chunk.method_31597(); ++i) {
            class_2826 levelChunkSection;
            int sectionWorldY = class_4076.method_18688((int)i);
            if (sectionWorldY + 15 < originalPos.method_10264() - radius || sectionWorldY > originalPos.method_10264() + radius || !(levelChunkSection = chunk.method_38259(chunk.method_31603(i))).method_19523(predicate)) continue;
            mutableSectionWorldOrigin.method_10103(class_4076.method_18688((int)chunk.method_12004().field_9181), sectionWorldY, class_4076.method_18688((int)chunk.method_12004().field_9180));
            for (int yOffset = 0; yOffset < 16; ++yOffset) {
                for (int zOffset = 0; zOffset < 16; ++zOffset) {
                    for (int xOffset = 0; xOffset < 16; ++xOffset) {
                        class_2680 blockState;
                        mutableSectionWorldBlockPos.method_10101((class_2382)mutableSectionWorldOrigin).method_10100(xOffset, yOffset, zOffset);
                        int xDiff = originalPos.method_10263() - mutableSectionWorldBlockPos.method_10263();
                        int yDiff = originalPos.method_10264() - mutableSectionWorldBlockPos.method_10264();
                        int zDiff = originalPos.method_10260() - mutableSectionWorldBlockPos.method_10260();
                        if (xDiff * xDiff + yDiff * yDiff + zDiff * zDiff > radiusSq || !predicate.test(blockState = levelChunkSection.method_12254(xOffset, yOffset, zOffset))) continue;
                        validPos.add(mutableSectionWorldBlockPos.method_10062());
                    }
                }
            }
        }
    }

    public static String formatTickDurationNoMilliseconds(int tickDuration, float tickRate) {
        int j = class_3532.method_15375((float)((float)tickDuration / tickRate));
        int k = j / 60;
        return String.format(Locale.ROOT, "%02d:%02d", k %= 60, j %= 60);
    }

    public static class BasicItemTrade
    implements class_3853.class_1652 {
        private final class_1792 itemToTrade;
        private final class_1792 itemToReceive;
        private final int amountToGive;
        private final int amountToReceive;
        protected final int maxUses;
        protected final int experience;
        protected final float multiplier;

        public BasicItemTrade(class_1792 itemToTrade, class_1792 itemToReceive, int amountToGive, int amountToReceive) {
            this(itemToReceive, itemToTrade, amountToGive, amountToReceive, 20, 2, 0.05f);
        }

        public BasicItemTrade(class_1792 itemToTrade, class_1792 itemToReceive, int amountToGive, int amountToReceive, int maxUses, int experience, float multiplier) {
            this.itemToTrade = itemToTrade;
            this.itemToReceive = itemToReceive;
            this.amountToGive = amountToGive;
            this.amountToReceive = amountToReceive;
            this.maxUses = maxUses;
            this.experience = experience;
            this.multiplier = multiplier;
        }

        public class_1914 method_7246(class_1297 entity, class_5819 random) {
            class_1799 in = new class_1799((class_1935)this.itemToTrade, this.amountToGive);
            class_1799 out = new class_1799((class_1935)this.itemToReceive, this.amountToReceive);
            return new class_1914(in, out, this.maxUses, this.experience, this.multiplier);
        }
    }

    public static final class Lazy<T> {
        private volatile T value;
        private Supplier<T> supplierValue;

        public Lazy() {
        }

        public Lazy(Supplier<T> supplierValue) {
            this.supplierValue = supplierValue;
        }

        public T getOrCompute(Supplier<T> supplier) {
            T result = this.value;
            return result == null ? this.maybeCompute(supplier) : result;
        }

        private synchronized T maybeCompute(Supplier<T> supplier) {
            if (this.value == null) {
                this.value = Objects.requireNonNull(supplier.get());
            }
            return this.value;
        }

        public T getOrFillFromInternal() {
            T result = this.value;
            return result == null ? this.maybeCompute(this.supplierValue) : result;
        }
    }
}

