/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.PreviewType;
import com.misterpemodder.shulkerboxtooltip.api.ShulkerBoxTooltipApi;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.network.ClientNetworking;
import com.misterpemodder.shulkerboxtooltip.impl.util.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_5250;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public class ShulkerBoxTooltipClient {
    private static class_1799 previousStack = null;
    public static class_310 client;
    private static boolean wasPreviewAccessed;
    private static boolean previewKeyPressed;
    private static boolean fullPreviewKeyPressed;
    private static boolean lockPreviewKeyPressed;
    private static boolean lockKeyHintsEnabled;

    public static void init() {
        client = class_310.method_1551();
        ClientNetworking.init();
    }

    private static boolean isPreviewRequested() {
        return ShulkerBoxTooltip.config.preview.alwaysOn || ShulkerBoxTooltipClient.isPreviewKeyPressed();
    }

    private static List<class_2561> getTooltipHints(PreviewContext context, PreviewProvider provider) {
        if (!ShulkerBoxTooltip.config.preview.enable || !provider.shouldDisplay(context)) {
            return Collections.emptyList();
        }
        boolean previewRequested = ShulkerBoxTooltipClient.isPreviewRequested();
        ArrayList<class_2561> hints = new ArrayList<class_2561>();
        class_2561 previewKeyHint = ShulkerBoxTooltipClient.getPreviewKeyTooltipHint(context, provider, previewRequested);
        class_2561 lockKeyHint = ShulkerBoxTooltipClient.getLockKeyTooltipHint(context, provider, previewRequested);
        if (previewKeyHint != null) {
            hints.add(previewKeyHint);
        }
        if (lockKeyHint != null) {
            hints.add(lockKeyHint);
        }
        return hints;
    }

    @Nullable
    private static class_2561 getPreviewKeyTooltipHint(PreviewContext context, PreviewProvider provider, boolean previewRequested) {
        if (previewRequested && ShulkerBoxTooltipClient.isFullPreviewKeyPressed()) {
            return null;
        }
        boolean fullPreviewAvailable = provider.isFullPreviewAvailable(context);
        if (!fullPreviewAvailable && previewRequested) {
            return null;
        }
        class_5250 previewKeyHint = class_2561.method_43470((String)"");
        class_2561 previewKeyText = ShulkerBoxTooltip.config.controls.previewKey.get().method_27445();
        if (previewRequested) {
            previewKeyHint.method_10852(ShulkerBoxTooltip.config.controls.fullPreviewKey.get().method_27445());
            if (!ShulkerBoxTooltip.config.preview.alwaysOn) {
                previewKeyHint.method_27693("+").method_10852(previewKeyText);
            }
        } else {
            previewKeyHint.method_10852(previewKeyText);
        }
        previewKeyHint.method_27693(": ");
        previewKeyHint.method_27696(class_2583.field_24360.method_10977(class_124.field_1065));
        String contentHint = ShulkerBoxTooltipApi.getCurrentPreviewType(fullPreviewAvailable) == PreviewType.NO_PREVIEW ? (ShulkerBoxTooltip.config.preview.swapModes ? provider.getFullTooltipHintLangKey(context) : provider.getTooltipHintLangKey(context)) : (ShulkerBoxTooltip.config.preview.swapModes ? provider.getTooltipHintLangKey(context) : provider.getFullTooltipHintLangKey(context));
        return previewKeyHint.method_10852((class_2561)class_2561.method_43471((String)contentHint).method_10862(class_2583.field_24360.method_10977(class_124.field_1068)));
    }

    @Nullable
    private static class_2561 getLockKeyTooltipHint(PreviewContext context, PreviewProvider provider, boolean previewRequested) {
        if (!previewRequested || ShulkerBoxTooltipClient.isLockPreviewKeyPressed() || !lockKeyHintsEnabled) {
            return null;
        }
        class_5250 lockKeyHint = class_2561.method_43470((String)"");
        String lockKeyHintLangKey = provider.getLockKeyTooltipHintLangKey(context);
        lockKeyHint.method_10852(ShulkerBoxTooltip.config.controls.lockTooltipKey.get().method_27445());
        lockKeyHint.method_27693(": ");
        lockKeyHint.method_27696(class_2583.field_24360.method_10977(class_124.field_1065));
        lockKeyHint.method_10852((class_2561)class_2561.method_43471((String)lockKeyHintLangKey).method_10862(class_2583.field_24360.method_10977(class_124.field_1068)));
        return lockKeyHint;
    }

    public static void modifyStackTooltip(class_1799 stack, Consumer<Collection<class_2561>> tooltip) {
        if (client == null) {
            return;
        }
        PreviewContext context = PreviewContext.builder(stack).withOwner((class_1657)ShulkerBoxTooltipClient.client.field_1724).build();
        PreviewProvider provider = ShulkerBoxTooltipApi.getPreviewProviderForStack(stack);
        if (provider == null) {
            return;
        }
        if (previousStack == null || !class_1799.method_7973((class_1799)stack, (class_1799)previousStack)) {
            wasPreviewAccessed = false;
        }
        previousStack = stack;
        if (!wasPreviewAccessed) {
            provider.onInventoryAccessStart(context);
        }
        wasPreviewAccessed = true;
        if (provider.showTooltipHints(context)) {
            if (ShulkerBoxTooltip.config.tooltip.type == Configuration.ShulkerBoxTooltipType.MOD) {
                tooltip.accept(provider.addTooltip(context));
            }
            if (ShulkerBoxTooltip.config.tooltip.showKeyHints) {
                tooltip.accept(ShulkerBoxTooltipClient.getTooltipHints(context, provider));
            }
        }
    }

    public static boolean isPreviewAvailable(PreviewContext context) {
        if (ShulkerBoxTooltip.config.preview.enable) {
            PreviewProvider provider = ShulkerBoxTooltipApi.getPreviewProviderForStack(context.stack());
            return provider != null && provider.shouldDisplay(context) && ShulkerBoxTooltipApi.getCurrentPreviewType(provider.isFullPreviewAvailable(context)) != PreviewType.NO_PREVIEW;
        }
        return false;
    }

    public static PreviewType getCurrentPreviewType(boolean hasFullPreviewMode) {
        boolean previewRequested = ShulkerBoxTooltipClient.isPreviewRequested();
        if (previewRequested && !hasFullPreviewMode) {
            return PreviewType.COMPACT;
        }
        if (ShulkerBoxTooltip.config.preview.swapModes) {
            if (previewRequested) {
                return ShulkerBoxTooltipClient.isFullPreviewKeyPressed() ? PreviewType.COMPACT : PreviewType.FULL;
            }
        } else if (previewRequested) {
            return ShulkerBoxTooltipClient.isFullPreviewKeyPressed() ? PreviewType.FULL : PreviewType.COMPACT;
        }
        return PreviewType.NO_PREVIEW;
    }

    public static boolean isPreviewKeyPressed() {
        return previewKeyPressed;
    }

    public static boolean isFullPreviewKeyPressed() {
        return fullPreviewKeyPressed;
    }

    public static boolean isLockPreviewKeyPressed() {
        return lockPreviewKeyPressed;
    }

    public static void setLockKeyHintsEnabled(boolean value) {
        lockKeyHintsEnabled = value;
    }

    private static boolean isKeyPressed(@Nullable Key key) {
        if (key == null || key.equals(Key.UNKNOWN_KEY) || key.get().equals((Object)class_3675.field_16237)) {
            return false;
        }
        return class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)key.get().method_1444());
    }

    public static void updatePreviewKeys() {
        Configuration config = ShulkerBoxTooltip.config;
        if (config == null) {
            previewKeyPressed = false;
            fullPreviewKeyPressed = false;
            lockPreviewKeyPressed = false;
        } else {
            previewKeyPressed = ShulkerBoxTooltipClient.isKeyPressed(config.controls.previewKey);
            fullPreviewKeyPressed = ShulkerBoxTooltipClient.isKeyPressed(config.controls.fullPreviewKey);
            lockPreviewKeyPressed = ShulkerBoxTooltipClient.isKeyPressed(config.controls.lockTooltipKey);
        }
    }

    static {
        wasPreviewAccessed = false;
        previewKeyPressed = false;
        fullPreviewKeyPressed = false;
        lockPreviewKeyPressed = false;
        lockKeyHintsEnabled = false;
    }
}

