/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.network;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.PluginManager;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.network.EnderChestInventoryListener;
import com.misterpemodder.shulkerboxtooltip.impl.network.ProtocolVersion;
import com.misterpemodder.shulkerboxtooltip.impl.network.RegistrationChangeType;
import com.misterpemodder.shulkerboxtooltip.impl.network.fabric.ServerNetworkingImpl;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.S2CEnderChestUpdate;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.S2CMessages;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ServerNetworking {
    private static final Map<class_3222, ProtocolVersion> CLIENTS = new WeakHashMap<class_3222, ProtocolVersion>();

    public static boolean hasModAvailable(class_3222 player) {
        return CLIENTS.containsKey(player);
    }

    public static void addClient(class_3222 client, ProtocolVersion version) {
        CLIENTS.put(client, version);
        PluginManager.loadProviders();
        Configuration.EnderChestSyncType ecSyncType = ShulkerBoxTooltip.config.server.enderChestSyncType;
        if (ecSyncType != Configuration.EnderChestSyncType.NONE) {
            S2CMessages.ENDER_CHEST_UPDATE.sendTo(client, S2CEnderChestUpdate.create(client.method_7274()));
        }
        if (ecSyncType == Configuration.EnderChestSyncType.ACTIVE) {
            EnderChestInventoryListener.attachTo(client);
        }
    }

    public static void removeClient(class_3222 client) {
        CLIENTS.remove(client);
        EnderChestInventoryListener.detachFrom(client);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_2596<?> createS2CPacket(class_2960 channelId, class_2540 buf) {
        void var1_1;
        return ServerNetworkingImpl.createS2CPacket(channelId, (class_2540)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        ServerNetworkingImpl.init();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerC2SReceiver(class_2960 channelId, class_3222 player, PacketReceiver receiver) {
        void var2_2;
        void var1_1;
        ServerNetworkingImpl.registerC2SReceiver(channelId, (class_3222)var1_1, (PacketReceiver)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void unregisterC2SReceiver(class_2960 channelId, class_3222 player) {
        void var1_1;
        ServerNetworkingImpl.unregisterC2SReceiver(channelId, (class_3222)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addRegistrationChangeListener(class_2960 channelId, RegistrationChangeListener listener) {
        void var1_1;
        ServerNetworkingImpl.addRegistrationChangeListener(channelId, (RegistrationChangeListener)var1_1);
    }

    @FunctionalInterface
    public static interface RegistrationChangeListener {
        public void onRegistrationChange(class_3222 var1, RegistrationChangeType var2);
    }

    @FunctionalInterface
    public static interface PacketReceiver {
        public void handle(class_3222 var1, class_2540 var2);
    }
}

