/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.renderer;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltipClient;
import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.PreviewType;
import com.misterpemodder.shulkerboxtooltip.api.config.PreviewConfiguration;
import com.misterpemodder.shulkerboxtooltip.api.provider.EmptyPreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.renderer.PreviewRenderer;
import com.misterpemodder.shulkerboxtooltip.impl.util.MergedItemStack;
import com.misterpemodder.shulkerboxtooltip.impl.util.ShulkerBoxTooltipUtil;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_638;
import net.minecraft.class_7225;

@Environment(value=EnvType.CLIENT)
public abstract class BasePreviewRenderer
implements PreviewRenderer {
    protected PreviewType previewType;
    protected PreviewConfiguration config;
    protected int compactMaxRowSize;
    protected int maxRowSize = 9;
    protected class_2960 textureOverride;
    protected PreviewProvider provider;
    protected List<MergedItemStack> items = new ArrayList<MergedItemStack>();
    protected PreviewContext previewContext;
    private final int slotWidth;
    private final int slotHeight;
    private final int slotXOffset;
    private final int slotYOffset;

    protected BasePreviewRenderer(int slotWidth, int slotHeight, int slotXOffset, int slotYOffset) {
        this.previewType = PreviewType.FULL;
        this.slotWidth = slotWidth;
        this.slotHeight = slotHeight;
        this.slotXOffset = slotXOffset;
        this.slotYOffset = slotYOffset;
        class_638 world = ShulkerBoxTooltipClient.client == null ? null : ShulkerBoxTooltipClient.client.field_1687;
        this.setPreview(PreviewContext.builder(class_1799.field_8037).withRegistryLookup((class_7225.class_7874)(world == null ? null : world.method_30349())).build(), EmptyPreviewProvider.INSTANCE);
    }

    protected int getMaxRowSize() {
        return this.previewType == PreviewType.COMPACT ? this.compactMaxRowSize : this.maxRowSize;
    }

    protected int getInvSize() {
        return this.previewType == PreviewType.COMPACT ? Math.max(1, this.items.size()) : this.provider.getInventoryMaxSize(this.previewContext);
    }

    @Override
    public void setPreviewType(PreviewType type) {
        this.previewType = type;
    }

    @Override
    public void setPreview(PreviewContext context, PreviewProvider provider) {
        List<class_1799> inventory = provider.getInventory(context);
        int rowSize = provider.getMaxRowSize(context);
        this.config = context.config();
        this.compactMaxRowSize = this.config.defaultMaxRowSize();
        if (this.compactMaxRowSize <= 0) {
            this.compactMaxRowSize = 9;
        }
        if (rowSize <= 0) {
            rowSize = this.compactMaxRowSize;
        }
        this.maxRowSize = rowSize;
        this.textureOverride = provider.getTextureOverride(context);
        this.provider = provider;
        this.items = MergedItemStack.mergeInventory(inventory, provider.getInventoryMaxSize(context), this.config.itemStackMergingStrategy());
        this.previewContext = context;
    }

    private int getSlotAt(int x, int y) {
        int slot = -1;
        if (x + 1 >= this.slotXOffset && y + 1 >= this.slotYOffset) {
            int maxRowSize = this.getMaxRowSize();
            int slotX = (x + 1 - this.slotXOffset) / this.slotWidth;
            int slotY = (y + 1 - this.slotYOffset) / this.slotHeight;
            if (slotX < maxRowSize) {
                slot = slotX + slotY * maxRowSize;
            }
        }
        return slot;
    }

    private class_1799 getStackAt(int x, int y) {
        int slot = this.getSlotAt(x, y);
        if (this.previewType == PreviewType.COMPACT) {
            if (slot < 0 || slot >= this.items.size()) {
                return class_1799.field_8037;
            }
            MergedItemStack merged = this.items.get(slot);
            return merged == null ? class_1799.field_8037 : merged.get();
        }
        for (MergedItemStack merged : this.items) {
            class_1799 stack = merged.getSubStack(slot);
            if (stack.method_7960()) continue;
            return stack;
        }
        return class_1799.field_8037;
    }

    private void drawItem(class_1799 stack, int x, int y, class_332 context, class_327 textRenderer, int slot, boolean shortItemCount) {
        String countLabel = "";
        int maxRowSize = this.getMaxRowSize();
        if (stack.method_7947() != 1) {
            countLabel = shortItemCount ? ShulkerBoxTooltipUtil.abbreviateInteger(stack.method_7947()) : String.valueOf(stack.method_7947());
        }
        x = this.slotXOffset + x + this.slotWidth * (slot % maxRowSize);
        y = this.slotYOffset + y + this.slotHeight * (slot / maxRowSize);
        context.method_51427(stack, x, y);
        context.method_51432(textRenderer, stack, x, y, countLabel);
    }

    protected void drawItems(int x, int y, class_332 context, class_327 textRenderer) {
        if (this.previewType == PreviewType.COMPACT) {
            boolean shortItemCounts = this.config.shortItemCounts();
            int size = this.items.size();
            for (int slot = 0; slot < size; ++slot) {
                this.drawItem(this.items.get(slot).get(), x, y, context, textRenderer, slot, shortItemCounts);
            }
        } else {
            for (MergedItemStack compactor : this.items) {
                int size = compactor.size();
                for (int slot = 0; slot < size; ++slot) {
                    this.drawItem(compactor.getSubStack(slot), x, y, context, textRenderer, slot, false);
                }
            }
        }
    }

    protected void drawInnerTooltip(int x, int y, class_332 context, class_327 textRenderer, int mouseX, int mouseY) {
        class_1799 stack = this.getStackAt(mouseX - x, mouseY - y);
        if (!stack.method_7960()) {
            context.method_51446(textRenderer, stack, mouseX, mouseY);
        }
    }

    protected void drawSlotHighlight(int x, int y, class_332 context, int mouseX, int mouseY) {
        int slot = this.getSlotAt(mouseX - x, mouseY - y);
        if (slot >= 0 && slot < this.getInvSize()) {
            int maxRowSize = this.getMaxRowSize();
            x = this.slotXOffset + x + this.slotWidth * (slot % maxRowSize);
            y = this.slotYOffset + y + this.slotHeight * (slot / maxRowSize);
            class_465.method_33285((class_332)context, (int)x, (int)y, (int)0);
        }
    }
}

