/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.api.identity;

import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import java.util.function.Predicate;

public record Condition(Predicate<State> predicate) {
    public static Condition ALWAYS = Condition.of(e -> true);

    public Condition and(Condition other) {
        return new Condition(this.predicate.and(other.predicate));
    }

    public Condition or(Condition other) {
        return new Condition(this.predicate.or(other.predicate));
    }

    public static Condition nameContains(String substring) {
        return new Condition(state -> state.name().contains(substring));
    }

    public static Condition type(String type) {
        return new Condition(state -> state.type().test(Type.of(type), MatchContext.of()));
    }

    public static Condition of(Predicate<State> predicate) {
        return new Condition(predicate);
    }

    public static Condition type(Type type) {
        return new Condition(state -> state.type().test(type, MatchContext.of()));
    }
}

