/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.api.identity;

import com.sigmundgranaas.forgero.core.api.identity.Condition;
import com.sigmundgranaas.forgero.core.api.identity.ModificationRule;
import com.sigmundgranaas.forgero.core.api.identity.ModificationRuleRegistry;
import com.sigmundgranaas.forgero.core.identifier.Common;
import com.sigmundgranaas.forgero.core.state.State;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ModificationRuleBuilder {
    private ModificationRuleRegistry registry = ModificationRuleRegistry.staticRegistry();
    private Condition condition;
    private Function<String, String> transformation = Function.identity();

    public static ModificationRuleBuilder builder() {
        return new ModificationRuleBuilder();
    }

    public ModificationRuleBuilder when(Condition condition) {
        this.condition = condition;
        return this;
    }

    public ModificationRuleBuilder replace(String target, String replacement) {
        this.transformation = this.transformation.andThen(name -> name.replace(target, replacement));
        return this;
    }

    public ModificationRuleBuilder ignore() {
        this.transformation = this.transformation.andThen(name -> "");
        return this;
    }

    public ModificationRuleBuilder remove(String substring) {
        return this.replace(substring, "");
    }

    public ModificationRuleBuilder replaceElement(String containing, String replacement) {
        this.transformation = this.transformation.andThen(name -> {
            String[] elements = name.split(Common.ELEMENT_SEPARATOR);
            return Arrays.stream(elements).map(element -> element.contains(containing) ? replacement : element).collect(Collectors.joining(Common.ELEMENT_SEPARATOR));
        });
        return this;
    }

    public ModificationRule build() {
        return new ModificationRule(){

            @Override
            public boolean applies(State state) {
                return ModificationRuleBuilder.this.condition.predicate().test(state);
            }

            @Override
            public Function<String, String> transformation() {
                return ModificationRuleBuilder.this.transformation;
            }
        };
    }

    public ModificationRule register(String id) {
        ModificationRule rule = this.build();
        this.registry.registerRule(id, rule);
        return rule;
    }

    public ModificationRuleBuilder takeElement(int i) {
        this.transformation = this.transformation.andThen(name -> {
            String[] elements = name.split(Common.ELEMENT_SEPARATOR);
            if (elements.length >= i) {
                return elements[0];
            }
            return name;
        });
        return this;
    }
}

