/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.api.identity;

import com.sigmundgranaas.forgero.core.api.identity.ModificationRule;
import com.sigmundgranaas.forgero.core.state.State;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class ModificationRuleRegistry {
    private static final Map<String, ModificationRule> staticRules = new ConcurrentHashMap<String, ModificationRule>();
    private final Map<String, ModificationRule> rules;

    private ModificationRuleRegistry() {
        this.rules = staticRules;
    }

    private ModificationRuleRegistry(Map<String, ModificationRule> rules) {
        this.rules = rules;
    }

    public static ModificationRuleRegistry staticRegistry() {
        return new ModificationRuleRegistry();
    }

    public static ModificationRuleRegistry localRegistry(Map<String, ModificationRule> rules) {
        return new ModificationRuleRegistry(rules);
    }

    public static ModificationRuleRegistry local() {
        return new ModificationRuleRegistry(new ConcurrentHashMap<String, ModificationRule>());
    }

    public void registerRule(String id, ModificationRule rule) {
        this.rules.put(id, rule);
    }

    public String applyRules(State state) {
        String originalName = state.name();
        return (String)this.rules.values().stream().filter(rule -> rule.applies(state)).map(ModificationRule::transformation).reduce(Function.identity(), Function::andThen).apply(originalName);
    }
}

