/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.api.identity.sorting;

import com.sigmundgranaas.forgero.core.api.identity.sorting.SortingRule;
import com.sigmundgranaas.forgero.core.state.State;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SortingRuleRegistry {
    private static final Map<String, SortingRule> staticRules = new ConcurrentHashMap<String, SortingRule>();
    private final Map<String, SortingRule> rules;

    private SortingRuleRegistry() {
        this.rules = staticRules;
    }

    private SortingRuleRegistry(Map<String, SortingRule> rules) {
        this.rules = new ConcurrentHashMap<String, SortingRule>(rules);
    }

    public static SortingRuleRegistry staticRegistry() {
        return new SortingRuleRegistry();
    }

    public static SortingRuleRegistry localRegistry(Map<String, SortingRule> rules) {
        return new SortingRuleRegistry(rules);
    }

    public static SortingRuleRegistry local() {
        return new SortingRuleRegistry(new ConcurrentHashMap<String, SortingRule>());
    }

    public void registerRule(String id, SortingRule rule) {
        this.rules.put(id, rule);
    }

    public Comparator<State> getComparator() {
        return (s1, s2) -> {
            Integer p1 = this.rules.values().stream().filter(rule -> rule.applies((State)s1)).map(SortingRule::getPriority).findFirst().orElse(Integer.MAX_VALUE);
            Integer p2 = this.rules.values().stream().filter(rule -> rule.applies((State)s2)).map(SortingRule::getPriority).findFirst().orElse(Integer.MAX_VALUE);
            return Integer.compare(p1, p2);
        };
    }
}

