/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.cache;

import java.time.Duration;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class LayeredMatchedOptionCache<K, V> {
    private final Map<K, Deque<CacheEntry<V>>> cache;
    private final long entryTTL;
    private final int maxCacheSize;
    private long now;

    public LayeredMatchedOptionCache(Duration entryTTL, Integer maxCacheSize) {
        this.entryTTL = entryTTL != null ? entryTTL.toMillis() : Long.MAX_VALUE;
        this.maxCacheSize = maxCacheSize != null ? maxCacheSize : Integer.MAX_VALUE;
        this.cache = new ConcurrentHashMap<K, Deque<CacheEntry<V>>>();
    }

    public V get(K key, Supplier<V> callback, Predicate<V> matcher) {
        Deque<CacheEntry<V>> entries = this.prepareMap(key);
        this.cleanUpEntries(entries, key);
        return (V)this.findValidEntry(entries, matcher).map(CacheEntry::value).orElseGet(() -> this.addNewEntry(entries, callback.get()));
    }

    public Optional<V> getPrevious(K key) {
        Deque<CacheEntry<V>> entries = this.prepareMap(key);
        if (entries.isEmpty()) {
            return Optional.empty();
        }
        if (entries.size() == 1) {
            return Optional.of(entries.peek().value);
        }
        Iterator<CacheEntry<V>> it = entries.iterator();
        it.next();
        return Optional.of(it.next().value);
    }

    private Deque<CacheEntry<V>> prepareMap(K key) {
        this.now = System.currentTimeMillis();
        if (!this.cache.containsKey(key)) {
            this.cache.put(key, new LinkedList());
        }
        return this.cache.get(key);
    }

    private void cleanUpEntries(Deque<CacheEntry<V>> entries, K key) {
        if (entries.isEmpty()) {
            return;
        }
        Iterator<CacheEntry<V>> it = entries.iterator();
        while (it.hasNext()) {
            CacheEntry<V> entry = it.next();
            if (this.now <= entry.expiryTime && entries.size() <= this.maxCacheSize) continue;
            it.remove();
        }
        if (entries.isEmpty()) {
            this.cache.remove(key);
        }
    }

    private long newExpiry() {
        return this.now + this.entryTTL;
    }

    private Optional<CacheEntry<V>> findValidEntry(Deque<CacheEntry<V>> entries, Predicate<V> matcher) {
        Iterator<CacheEntry<V>> it = entries.iterator();
        while (it.hasNext()) {
            CacheEntry<V> entry = it.next();
            if (!matcher.test(entry.value)) continue;
            entry.hit(this.newExpiry());
            if (entries.peekFirst() != entry) {
                it.remove();
                entries.addFirst(entry);
            }
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    private V addNewEntry(Deque<CacheEntry<V>> entries, V newValue) {
        CacheEntry<V> newEntry = new CacheEntry<V>(newValue, this.newExpiry());
        newEntry.hitCount = 1;
        entries.addFirst(newEntry);
        if (entries.size() > this.maxCacheSize) {
            entries.removeLast();
        }
        return newValue;
    }

    private static class CacheEntry<V> {
        final V value;
        long expiryTime;
        int hitCount;

        CacheEntry(V value, long expiryTime) {
            this.value = value;
            this.expiryTime = expiryTime;
            this.hitCount = 0;
        }

        void hit(long newExpiryTime) {
            this.expiryTime = newExpiryTime;
            ++this.hitCount;
        }

        V value() {
            return this.value;
        }
    }
}

