/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.condition;

import com.sigmundgranaas.forgero.core.condition.Conditional;
import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ConditionContainer
implements Conditional<ConditionContainer>,
PropertyContainer {
    private final List<PropertyContainer> conditions;

    public ConditionContainer(List<PropertyContainer> conditions) {
        this.conditions = conditions;
    }

    public ConditionContainer() {
        this.conditions = new ArrayList<PropertyContainer>();
    }

    @Override
    public List<PropertyContainer> localConditions() {
        return this.conditions;
    }

    @Override
    public ConditionContainer applyCondition(PropertyContainer container) {
        ArrayList<PropertyContainer> copy = new ArrayList<PropertyContainer>(this.localConditions());
        copy.add(container);
        return new ConditionContainer(copy);
    }

    @Override
    public ConditionContainer removeCondition(String identifier) {
        List<PropertyContainer> copy = Conditional.removeConditions(this.conditions, identifier);
        return new ConditionContainer(copy);
    }

    @Override
    @NotNull
    public List<Property> getProperties() {
        return this.localConditions().stream().map(PropertyContainer::getRootProperties).flatMap(Collection::stream).toList();
    }

    @Override
    @NotNull
    public List<Property> getRootProperties(Matchable target, MatchContext context) {
        return this.localConditions().stream().map(cond -> cond.getRootProperties(target, context)).flatMap(Collection::stream).toList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionContainer that = (ConditionContainer)o;
        return Objects.equals(this.conditions, that.conditions);
    }

    public int hashCode() {
        return Objects.hash(this.conditions);
    }
}

